var count = (function times(BigNumber) {
    var start = +new Date(),
        log,
        error,
        undefined,
        passed = 0,
        total = 0,
        n = 'null',
        N = 'NaN',
        I = 'Infinity';

    if (typeof window === 'undefined') {
        log = console.log;
        error = console.error;
    } else {
        log = function (str) { document.body.innerHTML += str.replace('\n', '<br>') };
        error = function (str) { document.body.innerHTML += '<div style="color: red">' +
          str.replace('\n', '<br>') + '</div>' };
    }

    if (!BigNumber && typeof require === 'function') BigNumber = require('../bignumber');

    function assert(expected, actual) {
        total++;
        if (expected !== actual) {
           error('\n Test number: ' + total + ' failed');
           error(' Expected: ' + expected);
           error(' Actual:   ' + actual);
           //process.exit();
        }
        else {
            passed++;
            //log('\n Expected and actual: ' + actual);
        }
    }

    function T(multiplicand, multiplier, expected) {
        assert(String(expected), String(new BigNumber(multiplicand).times(multiplier)));
        assert(String(expected), String(new BigNumber(multiplicand).times(new BigNumber(multiplier))));
    }

    function isMinusZero(n) {
        return n.toString() === '0' && n.s == -1;
    }

    log('\n Testing times...');

    BigNumber.config({
        DECIMAL_PLACES : 20,
        ROUNDING_MODE : 4,
        EXPONENTIAL_AT : [-7, 21],
        RANGE : 1E9,
        ERRORS : false
    });

    assert(false, isMinusZero(new BigNumber(1).times(0)));
    assert(true, isMinusZero(new BigNumber(1).times(-0)));
    assert(true, isMinusZero(new BigNumber(-1).times(0)));
    assert(false, isMinusZero(new BigNumber(-1).times(-0)));
    T(1, N, N);
    T(-1, N, N);
    T(1, I, I);
    T(1, -I, -I);
    T(-1, I, -I);
    T(-1, -I, I);
    assert(false, isMinusZero(new BigNumber(0).times(1)));
    assert(true, isMinusZero(new BigNumber(0).times(-1)));
    assert(true, isMinusZero(new BigNumber(-0).times(1)));
    assert(false, isMinusZero(new BigNumber(-0).times(-1)));
    assert(false, isMinusZero(new BigNumber(0).times(0)));
    assert(true, isMinusZero(new BigNumber(0).times(-0)));
    assert(true, isMinusZero(new BigNumber(-0).times(0)));
    assert(false, isMinusZero(new BigNumber(-0).times(-0)));
    T(0, N, N);
    T(-0, N, N);
    T(0, I, N);
    T(0, -I, N);
    T(-0, I, N);
    T(-0, -I, N);
    T(N, 1, N);
    T(N, -1, N);
    T(N, 0, N);
    T(N, -0, N);
    T(N, N, N);
    T(N, I, N);
    T(N, -I, N);
    T(I, 1, I);
    T(I, -1, -I);
    T(-I, 1, -I);
    T(-I, -1, I);
    T(I, 0, N);
    T(I, -0, N);
    T(-I, 0, N);
    T(-I, -0, N);
    T(I, N, N);
    T(-I, N, N);
    T(I, I, I);
    T(I, -I, -I);
    T(-I, I, -I);
    T(-I, -I, I);

    T(1, '1','1');
    T(1, '-45', '-45');
    T(1, '22', '22');
    T(1, 0144, '100');
    T(1, '0144', '144');
    T(1, '6.1915', '6.1915');
    T(1, '-1.02', '-1.02');
    T(1, '0.09', '0.09');
    T(1, '-0.0001', '-0.0001');
    T(1, '8e5', '800000');
    T(1, '9E12', '9000000000000');
    T(1, '1e-14', '1e-14');
    T(1, '3.345E-9', '3.345e-9');
    T(1, '-345.43e+4', '-3454300');
    T(1, '-94.12E+0', '-94.12');
    T(1, '', N);
    T(1, '    ', N);
    T(1, '\t\t', N);
    T(1, 'ertgrt546', N);
    T(1, 'qweqwdewee', N);
    T(1, true, N);
    T(1, false, N);
    T(1, 'e 4.3', N);
    T(1, '4 .3', N);
    T(1, '4.0 01e', N);
    T(1, ' 4.001', '4.001');
    T(1, '4.001 ', '4.001');
    T(1, ' 4.001 ', '4.001');
    T(1, '    4.001', '4.001');
    T(1, ' 4.0 01', N);
    T(1, '4. 001', N);
    T(1, '4. 001 ', N);
    T(1, '  4.001e ', N);
    T(1, ' 4 .001 e ', N);
    T(1, undefined, N);
    T(1, null, N);
    T(1, Number.POSITIVE_INFINITY, I);
    T(1, Number.NEGATIVE_INFINITY, -I);
    T(1, new Date(2012, 11, 4), N);
    T(1, new Object(), N);
    T(1, function () {}, N);
    T('0', 0, '0');
    T(0, '+0', '0');
    T('0', '0', '0');
    T(3, -0, '0');
    T(9.654, 0, '0');
    T(0, '0.001', '0');
    T(0, '111.1111111110000', '0');
    T(N, '0', N);
    T(-1, 1, '-1');
    T(-0.01, 0.01, '-0.0001');
    T(54, -54, '-2916');
    T(9.99, '-9.99', '-99.8001');
    T('0.0000023432495704937', '-0.0000023432495704937', '-5.49081854961890952566173969e-12');
    T(NaN, NaN, N);
    T(NaN, N, N);
    T(N, NaN, N);
    T(N, 4, N);
    T(N, '4534534.45435435', N);
    T(N, 99999.999, N);
    T(Infinity, '354.345341', I);
    T(3, -I, -I);
    T(-Infinity, -I, I);
    T(-I, -Infinity, I);
    T(I, '-999e999', -I);
    T(1.21123e43, -I, -I);
    T('-999.0', I, -I);
    T('657.342e-45', -I, -I);
    T(I, 123, I);
    T(-0, I, N);
    T(100, 100, '10000');
    T(-999.99, '0.01', '-9.9999');
    T('10 ', 4, '40');
    T('03.333', -4, '-13.332');
    T(-1, -0.1, '0.1');
    T(43534.5435, '0.054645', '2378.9451295575');
    T('99999', '1', '99999');
    T('3e', 8, N);
    T('-3..0', 13, N);
    T('0 0', -0.4, N);
    T(' +3e0', 4, '12');
    T(9.9806, '+ 1', N);
    T(' +2 0', '1e1', N);
    T('e3', 4, N);
    T(' ', 0, N);
    T(323, null, N);
    T(undefined, undefined, N);
    T('undefined', undefined, N);
    T(null, null, N);

    T('-19.851', '69.11', '-1371.90261');
    T('-0.0251', '-1.09821', '0.027565071');
    T('-2.11', '-21', '44.31');
    T('-1', '7161', '-7161');
    T('-4.61', '1', '-4.61');
    T('11', '-0.0000271', '-0.0002981');
    T('-1', '0.0000224801', '-0.0000224801');
    T('-3.6', '-3336', '12009.6');
    T('0.000000219', '-110.42', '-0.00002418198');
    T('312', '22.87694', '7137.60528');
    T('0.29976', '-5', '-1.4988');
    T('0.00000000000000000010018', '-74.6', '-7.473428e-18');
    T('138.583905', '9.73380', '1348.948014489');
    T('5360260.6', '-12.12', '-64966358.472');
    T('-7.01', '-0.0000000988077', '6.92641977e-7');
    T('0.0000202', '-56583117802', '-1142978.9796004');
    T('116727.96', '0.0000000000000019308', '2.25378345168e-10');
    T('-136636.46', '6.5636554051', '-896834.639212729946');
    T('12.1712598149', '53.270389', '648.3677449597909961');
    T('76', '76019.61784', '5777490.95584');
    T('0.0000714939', '1425786', '101.9350017054');
    T('-3221.71685', '-230', '740994.8755');
    T('0.00000000237457904', '-892315', '-0.0021188724960776');
    T('6511.4', '0.0000000000000186', '1.2111204e-10');
    T('0.000000011188562', '0', '0');
    T('-25379.8', '3', '-76139.4');
    T('41.9279', '23.4198661', '981.94580385419');
    T('0.0000010', '58236.222', '0.058236222');
    T('0', '-16.39257632', '0');
    T('0.000000004846959', '1', '4.846959e-9');
    T('0', '-30878.5', '0');
    T('-8065.5', '-0.00000000058314173', '0.000004703329623315');
    T('-443850607', '-1', '443850607');
    T('-0.070884', '0.0000000000000000002106611401', '-1.49325042548484e-20');
    T('15510739.6998', '4.13', '64059354.960174');
    T('-1182.8', '0.00000000000006116702878', '-7.2348361640984e-11');
    T('0.000000000000000024429766', '1.492', '3.6449210872e-17');
    T('-521641.171', '0.000000044916564267', '-0.023430329181534636657');
    T('-1.4', '-50.3861389', '70.54059446');
    T('-906235823', '169450901242', '-153562476945135592166');
    T('818.5', '-0.0000000000000002572', '-2.105182e-13');
    T('0', '2', '0');
    T('0.00000000000000000723208622905', '7281.27407', '5.26588019315858457335e-14');
    T('-8.30486506', '-1110043.7', '9218763.139203122');
    T('1.8', '0', '0');
    T('-0.000000000000339156493611', '-0.000000000000000000167265', '5.6729010903843915e-32');
    T('0.00000000000000283', '4.074', '1.152942e-14');
    T('39.85', '33086328', '1318490170.8');
    T('4.1183805089', '-5.126069', '-21.1111026568765141');
    T('-464.2025675', '0.00000000000000000106831881858', '-4.9591633849340270415e-16');
    T('0', '-0.0000000000073', '0');
    T('-0.0000002358363833', '-37968.0', '0.0089542358011344');
    T('3.4', '-32545254.52', '-110653865.368');
    T('0.000000247', '12.88', '0.00000318136');
    T('-446908', '0.000000490399599', '-0.219163503989892');
    T('-0.0000000015', '91', '-1.365e-7');
    T('794881.3', '45.2898548', '36000058.66023524');
    T('5', '3046563.8', '15232819');
    T('-95094833817', '3.101', '-294889079666.517');
    T('-12786.5', '-0.0000000684878615', '0.00087572004106975');
    T('66754192.630', '7', '467279348.41');
    T('414951476.81', '-12.875', '-5342500263.92875');
    T('-2.486307', '0.00000000000131610556936', '-3.27224248983875352e-12');
    T('-0.000000000000000477405019421', '-1.1', '5.251455213631e-16');
    T('-367046.223', '-0.0000129', '4.7348962767');
    T('0', '0.000000000000093338247', '0');
    T('0.3341376', '-8', '-2.6731008');
    T('422580779', '-10829.0', '-4576127255791');
    T('-11.6639', '-56.51836497', '659.224557173583');
    T('-1', '-36577.4', '36577.4');
    T('61.5', '-68269.0', '-4198543.5');
    T('-18.10728', '0', '0');
    T('531751766', '41.50116', '22068315121.04856');
    T('-7.63315110', '3', '-22.8994533');
    T('1249.58475875', '38582.13', '48211641.6081111375');
    T('-2', '0.000000000000001022', '-2.044e-15');
    T('10.750', '0.000000000014145865', '1.5206804875e-10');
    T('14', '0.044276206', '0.619866884');
    T('12175855.915', '52.1893', '635449397.1047095');
    T('-1', '-0.00000000000029721', '2.9721e-13');
    T('311354.171224', '194857.1428', '60669584203.5706187872');
    T('0.0000008188', '6375.414052', '0.0052201890257776');
    T('0.00000055577528074', '3', '0.00000166732584222');
    T('526170.543', '6065.11546', '3191285094.94589478');
    T('0', '-27078031462', '0');
    T('0.0003450371', '4044.753', '1.3955898453363');
    T('0', '-5.681398758', '0');
    T('-2830933', '-1', '2830933');
    T('2.8', '14.36338836', '40.217487408');
    T('725.6556', '-0.000058977271', '-0.0427971869738676');
    T('0', '0', '0');
    T('591.1', '-182368.115408', '-107797793.0176688');
    T('1', '-8.44', '-8.44');
    T('-48988695', '3.99', '-195464893.05');
    T('-54145231.29', '-164.1', '8885232454.689');
    T('1.9615', '370.5', '726.73575');
    T('-2317170.34468', '-0.0000117290196265', '27.17813645069548986202');
    T('-3865301765', '9.90928729', '-38302385651.92906685');
    T('8.9648', '-3', '-26.8944');
    T('-10645.1', '-4208', '44794580.8');
    T('-390304.9', '-9.540', '3723508.746');
    T('0.00000000043946', '-0.0000000000135', '-5.93271e-21');
    T('11.167962', '907.089236', '10130.338118257032');
    T('328719912.6', '1.13', '371453501.238');
    T('8.0902', '3', '24.2706');
    T('-0.0000000000000000000103885880', '54949757', '-5.70850386173116e-13');
    T('-60096046', '147.9066', '-8888601837.3036');
    T('-1.1', '-4', '4.4');
    T('-2.3781033', '1.488', '-3.5386177104');
    T('18.64', '-13492494', '-251500088.16');
    T('0.0000000000000000078080114', '1362291', '1.06367836581174e-11');
    T('0.0000006699', '-0.0000000000000059', '-3.95241e-21');
    T('-279.40', '-4199.537182', '1173350.6886508');
    T('-346081282.623', '5715.5169', '-1978033419605.4328287');
    T('26098.51437', '-0.00004277160560', '-1.116275363379572472');
    T('-0.000000000038243914682', '6258350.6', '-0.0002393438263964435092');
    T('-0.23215784', '1.7', '-0.394668328');
    T('270.08569', '73.4', '19824.289646');
    T('0.000000000000000253826', '-1', '-2.53826e-16');
    T('1773.911', '167', '296243.137');
    T('-609057.1664', '-2', '1218114.3328');
    T('178326076.8', '-299396.226', '-53390154391306.1568');
    T('-99153591.8357', '-67230.718614', '6666167232273.3544197198');
    T('0.0000000000001596', '-0.00349909609', '-5.58455735964e-16');
    T('1.84', '0.00000000003464', '6.37376e-11');
    T('73.5', '0', '0');
    T('0.000000000000000049', '-198604', '-9.731596e-12');
    T('1052854077', '2.8', '2947991415.6');
    T('28.3', '5964', '168781.2');
    T('2085.7', '-338.192', '-705367.0544');
    T('59.12705', '-0.0000000000016294', '-9.634161527e-11');
    T('-0.0000000000000629', '-0.0000133901915', '8.4224304535e-19');
    T('0.000000000000000000010713336246', '12.8722', '1.379042068257612e-19');
    T('0.000620507896', '3.9', '0.0024199807944');
    T('3', '9.6', '28.8');
    T('-1', '7', '-7');
    T('4.07', '4', '16.28');
    T('-2473.25538', '12.3', '-30421.041174');
    T('-1310633', '-9', '11795697');
    T('-3.90', '3031.9', '-11824.41');
    T('150.0276', '0.00897', '1.345747572');
    T('2', '-8.8', '-17.6');
    T('-3030148.8', '229674', '-695946395491.2');
    T('2', '775.7549', '1551.5098');
    T('-613183.18515', '-3', '1839549.55545');
    T('-0.000000000001224', '367.376621', '-4.49668984104e-10');
    T('-0.00000000000000000737581', '1.3490', '-9.94996769e-18');
    T('0', '-1.15490644', '0');
    T('8.437', '-12103106905', '-102113912957.485');
    T('155.8091088', '3.465', '539.878561992');
    T('179142.3', '0.0060', '1074.8538');
    T('-301.3766', '9.6052', '-2894.78251832');
    T('48.15', '518165.306', '24949659.4839');
    T('4387518.42726', '-8069', '-35402886189.56094');
    T('-28.3', '-77.67', '2198.061');
    T('9', '0.00000000000001022', '9.198e-14');
    T('-1071.62294', '0.0000010', '-0.00107162294');
    T('-4.15', '-3', '12.45');
    T('-661.167', '453', '-299508.651');
    T('-104436', '-1098478.95443', '114720748084.85148');
    T('0', '3.630588', '0');
    T('0', '-13181687.0', '0');
    T('-1.111', '-3.78770', '4.2081347');
    T('0.000000042325027395', '2.89323850', '1.224563987727687075e-7');
    T('-21.7', '-0.00001926174637', '0.000417979896229');
    T('28151356.2', '0.00000000003236052', '0.000910992525337224');
    T('0.0120', '-862436.56', '-10349.23872');
    T('3649.71055', '-692509.6', '-2527459593.09628');
    T('-3', '-1', '3');
    T('-1135.91888551', '12.37808265', '-14060.4978485386674015');
    T('1', '2172752.822', '2172752.822');
    T('-0.00000000000001091997', '-117.1', '1.278728487e-12');
    T('-605.91910660', '2036476909', '-1233940269312.8094994');
    T('-85793626', '-403556966', '34622615410698716');
    T('387.034155496', '1.51', '584.42157479896');
    T('-212937', '7812.350', '-1663538371.95');
    T('838667.59', '-297101', '-249168979656.59');
    T('0.00382632083', '0.000316896', '0.00000121254576574368');
    T('0.000000000000002582', '-295757466.2', '-7.636457777284e-7');
    T('-0.000000000000798713', '21.52', '-1.718830376e-11');
    T('0.00000974', '-2.9', '-0.000028246');
    T('0.0000000000281', '38.82', '1.090842e-9');
    T('-3.237', '16967081.13', '-54922441.61781');
    T('9.8', '-0.0000000001333', '-1.30634e-9');
    T('5614.9', '-76.1668', '-427668.96532');
    T('-1.8', '3545.0927', '-6381.16686');
    T('0.00000249806256', '-1131.1175', '-0.0028256022777108');
    T('-0.20706', '11338.58322', '-2347.7670415332');
    T('1908.3417145', '-138.575', '-264448.4530868375');
    T('0', '0.0000669436', '0');
    T('325.22245849', '-14504.56', '-4717208.6625157144');
    T('-13.8825', '0', '0');
    T('0.0000000000869261985', '1.1243', '9.773112497355e-11');
    T('2588680', '-2.639437', '-6832657.77316');
    T('847973030.3', '1300.4', '1102704128602.12');
    T('-669.7', '-1150.41', '770429.577');
    T('-1', '-6.761867', '6.761867');
    T('-4', '-128.68', '514.72');
    T('-0.0000000000000000148', '-389336', '5.7621728e-12');
    T('5.1', '8.1', '41.31');
    T('959895377.84', '976.5', '937337836460.76');
    T('152', '-1325188.6822', '-201428679.6944');
    T('-1013851164640', '-116895', '118514131890592800');
    T('-0.555030', '0.0025719815451', '-0.001427526916976853');
    T('-8.61456', '-0.000000000050', '4.30728e-10');
    T('-0.10822', '-42439', '4592.74858');
    T('5', '248', '1240');
    T('1.00560719', '-0.00000000000000538', '-5.4101666822e-15');
    T('-0.0000000000000000880', '20.26149480', '-1.7830115424e-15');
    T('-215.544104755', '-4060438.71', '875203626.65949706605');
    T('0', '13031.6', '0');
    T('-0.0000000000000047877659854', '-208.19', '9.96765000500426e-13');
    T('-4', '-3160383', '12641532');
    T('-0.00104402960', '-6', '0.0062641776');
    T('-6', '-221362529.2', '1328175175.2');
    T('-5658.7', '-0.000009428149284', '0.0533510683533708');
    T('-3', '-0.0000000000000000171257563600', '5.137726908e-17');
    T('1577941089.0', '-0.0000000000000054178560', '-0.000008549057596685184');
    T('-3', '-19154.88287', '57464.64861');
    T('-5.3', '-0.000000000000000094150109', '4.989955777e-16');
    T('-275.9', '-618029.6', '170514366.64');
    T('-0.00277412', '-2.0', '0.00554824');
    T('20896.13', '-2', '-41792.26');
    T('0', '144.50', '0');
    T('0', '37399', '0');
    T('0.0000000103050173', '-6.752', '-6.95794768096e-8');
    T('-1679844', '0.00008795', '-147.7422798');
    T('1731362.632', '-0.0000000010867236', '-0.0018815126323525152');
    T('-116536', '8818.8637874', '-1027715110.3284464');
    T('112359.12', '-6.3736', '-716132.087232');
    T('0.02767509', '4.002781363', '0.11077733447134767');
    T('-942581.9', '7.504907', '-7073989.4993833');
    T('6603793', '1.604', '10592483.972');
    T('91689.093', '5', '458445.465');
    T('4351694708.6', '0.0003242690', '1411119.6914630134');
    T('-2.38', '-39', '92.82');
    T('-759.5', '0.000000324', '-0.000246078');
    T('-6.1623', '-10.1485', '62.53810155');
    T('1819.975133', '-1918.4931', '-3491609.7348320823');
    T('-544', '-2373759.39656', '1291325111.72864');
    T('-2143.2', '-0.000000000000000000162130', '3.47477016e-16');
    T('0.621559060', '53.8', '33.439877428');
    T('-4624.6', '0.0000000000000190537313036', '-8.811588578662856e-11');
    T('-6', '-50.943', '305.658');
    T('-3021.479', '3', '-9064.437');
    T('-965', '-0.000415509858', '0.40096701297');
    T('0', '6465897.6979', '0');
    T('74528068.573', '-119403349', '-8898900982117850.977');
    T('64.56', '0.000000017086', '0.00000110307216');
    T('-9626.07', '-1051902.812582', '10125690107.11121274');
    T('1.4514', '-1', '-1.4514');
    T('0.00120840179209', '-492240', '-594.8236981383816');
    T('-1.163', '-3.5', '4.0705');
    T('-390918.9935', '-3.9645296', '1549809.9209329576');
    T('1130.013737', '3', '3390.041211');
    T('-5', '-6733821263', '33669106315');
    T('27774.358123', '-0.0000000000000128441670', '-3.56738494049618541e-10');
    T('0.363631323', '-3819136980.1', '-1388757832.7919876723');
    T('-0.0000000065598472', '53857.08', '-0.000353294215438176');
    T('-240695', '2', '-481390');
    T('0.000059', '0.00000000000017987993', '1.061291587e-17');
    T('37.17', '-61.7668', '-2295.871956');
    T('1.475572354', '266461086.2', '393182612.2135309148');
    T('-0.000000000003907', '-31.5', '1.230705e-10');
    T('-0.0000000000000000000894018', '0.00000000000000001599913222', '-1.430351218905996e-36');
    T('0', '-0.00005850856211', '0');
    T('32.75', '-2.57293', '-84.2634575');
    T('0.00000131', '43', '0.00005633');
    T('-129602.62', '-0.000000000000000123490', '1.60046275438e-11');
    T('-2941.6442', '2.013048311', '-5921.6718883729462');
    T('1.01983639584', '10710047', '10922495.73175700448');
    T('0.4077750076', '-3', '-1.2233250228');
    T('0.359', '207160.173586', '74370.502317374');
    T('-26222.646879', '9.8', '-256981.9394142');
    T('-2', '-1.1360', '2.272');
    T('6717280984', '564735824499', '3.793489214890694027016e+21');
    T('-7', '0.000000000000000000179598', '-1.257186e-18');
    T('-0.000212', '754.3', '-0.1599116');
    T('-8.6', '-44061.183', '378926.1738');
    T('0.000000000000000000013', '956', '1.2428e-17');
    T('-3', '3.8968771877', '-11.6906315631');
    T('-4485.1947117', '444609963508', '-1994162257095211.5806436');
    T('0', '-3353199.6579', '0');
    T('0.0000000000000000000293', '-4', '-1.172e-19');
    T('-225', '5.09648', '-1146.708');
    T('0.00000036757', '0', '0');
    T('-78694.836', '-43.8', '3446833.8168');
    T('0.000000000000018028989162', '495', '8.92434963519e-12');
    T('-4036233', '-0.0000000000000000000134620360255', '5.43359140533119415e-14');
    T('-2.19', '-481624.5154', '1054757.688726');
    T('-6', '-33692.483', '202154.898');
    T('-0.00000000387466078726', '137145711.9', '-0.531393112039787150394');
    T('-52.6685', '-107972.8', '5686765.4168');
    T('-7.137137210', '3.06', '-21.8396398626');
    T('-174.1619', '-2084784202', '363089977710.3038');
    T('11', '-0.15', '-1.65');
    T('177.3211', '-85578219.525', '-15174824022.2144775');
    T('2', '-1', '-2');
    T('-681.685707574', '222753546489', '-151847908952971.868407686');
    T('2225288.04', '-2945.03251212', '-6553545626.6317910448');
    T('-829419822664', '0.000750870', '-622786462.24371768');
    T('-3.887', '-0.0000000000215299', '8.36867213e-11');
    T('14780708.1', '-2000820.86', '-29573549092050.966');
    T('-65280872367', '2756.0', '-179914084243452');
    T('-1.1', '-16652196529', '18317416181.9');
    T('6153.32891899', '3.07', '18890.7197812993');
    T('1.6664', '10.5', '17.4972');
    T('-335.16960', '25.16', '-8432.867136');
    T('20.7', '834', '17263.8');
    T('8029.51', '-1', '-8029.51');
    T('3544067.44', '0.00000000000000000108040', '3.829010462176e-12');
    T('-0.00000000000000861840983', '3', '-2.585522949e-14');
    T('-1', '-5.4071', '5.4071');
    T('-0.000000000000014799305202', '-77.4875919308', '1.1467625223519416640216e-12');
    T('0', '-31045268779', '0');
    T('-437', '640.03', '-279693.11');
    T('60', '0.000000000000000371281463', '2.227688778e-14');
    T('-1', '-0.019533338878', '0.019533338878');
    T('-1117.048', '8.967', '-10016.569416');
    T('-0.0000000000001992331', '17762516', '-0.0000035388811264796');
    T('-1.209', '-3960.47030', '4788.2085927');
    T('-994748.5', '-10809803.2', '10753035518495.2');
    T('-3.0521', '0', '0');
    T('4553015.460', '-6', '-27318092.76');
    T('0.00000000403775332', '0', '0');
    T('10628.68130', '-1.196558', '-12717.8336389654');
    T('-0.00000000003389', '-113275.58', '0.0000038389094062');
    T('0.0000000000000000000810', '-0.000000002954', '-2.39274e-28');
    T('0', '0.00000002678', '0');
    T('12309', '25980042.9', '319788348056.1');
    T('-7.6', '0', '0');
    T('-61.22', '-349.3', '21384.146');
    T('-1.845209', '0.000000052784913420', '-9.739919730680478e-8');
    T('395.326251', '-371872028', '-147010774681.007028');
    T('332.72', '3715', '1236054.8');
    T('-1681921.54', '76348.91498', '-128412884660.4906692');
    T('517583042', '-13.9', '-7194404283.8');
    T('-21.723616577', '-0.000013157028', '0.000285818231564853156');
    T('-116.13334149', '0.0000000006536', '-7.5904751997864e-8');
    T('-4.1', '-294.0876', '1205.75916');
    T('-22.05', '-6.7', '147.735');
    T('-22.9', '-0.00000217178', '0.000049733762');
    T('-50.5', '0.012432393', '-0.6278358465');
    T('-2', '-0.00000000000119764950', '2.395299e-12');
    T('19381.0141', '65.916071785', '1277520.3166816971685');
    T('-4.90', '-22.5701', '110.59349');
    T('0.00000000000192902409442', '289522860.5', '0.00055849657378990048841');
    T('-27006298.37', '-8164.7', '220498324301.539');
    T('-8776869', '-143972778', '1263630212072082');
    T('-79325483.3', '248065.2', '-19677891879911.16');
    T('-26.2', '28441.8', '-745175.16');
    T('18.71', '97792.4647', '1829697.014537');
    T('-150.68501', '-1.3460', '202.82202346');
    T('-43.0091494663', '-5.6724', '243.96509943264012');
    T('12.359', '-1.261', '-15.584699');
    T('0.0000000048694525', '-13', '-6.33028825e-8');
    T('-26799', '-3.0401', '81471.6399');
    T('0.000000000003271187802', '0', '0');
    T('1', '0.0000000000250081008', '2.50081008e-11');
    T('23.590033588', '0.000000000000000880594309', '2.0773249326711650692e-14');
    T('2.34', '-35556883', '-83203106.22');
    T('127410324', '48.0', '6115695552');
    T('2.4', '2.0', '4.8');
    T('17', '-0.00000000000000000467960391085', '-7.955326648445e-17');
    T('-5827035', '63.01', '-367161475.35');
    T('-452352446648', '13167459.5', '-5956332520963450756');
    T('0', '27.51619908', '0');
    T('-6.8253', '-203490405', '1388883061.2465');
    T('-663513.1', '235798', '-156455061953.8');
    T('45846991454.7', '0.000000000000011371170', '0.000521333933819940999');
    T('-6940453.30', '-0.0000000000000000000429869089', '2.9834863373180437e-13');
    T('-299.7692790', '-2.0', '599.538558');
    T('-0.000000000000781997707', '-0.00000000002498', '1.953430272086e-23');
    T('-211968.876', '-11448', '2426619692.448');
    T('-2', '224979.5', '-449959');
    T('0.0000000000007372', '3', '2.2116e-12');
    T('2.14', '-96.5220369', '-206.557158966');
    T('246.3484', '-119174406049', '-29358424251121.4716');
    T('2301100.91737', '-431951.5', '-993963992909.347555');
    T('-13819448.15', '0', '0');
    T('0.0000000155919108142', '8.51', '1.32687161028842e-7');
    T('124616457', '513907736', '64041361285211352');
    T('-5298.3584942', '-4.1932', '22217.07683787944');
    T('158463114', '0.0000000000000000001405398', '2.22703743489372e-11');
    T('-65667302.5', '7', '-459671117.5');
    T('-1693481.437', '-27743783', '46983581502656.171');
    T('-0.0000000000000003099934391', '125', '-3.87491798875e-14');
    T('-0.000000000000004272052', '0.0000005661', '-2.4184086372e-21');
    T('12.95933', '209420271.72', '2713946409.9091476');
    T('3.1', '-1.31573054798', '-4.078764698738');
    T('0.000086866', '-103057641552', '-8952205.091056032');
    T('11.1', '660.353292988', '7329.9215521668');
    T('-92.940180', '-1', '92.94018');
    T('97808795959', '-97', '-9487453208023');
    T('0.000000000000000388699', '-399', '-1.55090901e-13');
    T('227578760.552', '-40082.64751', '-9121959239968.50902552');
    T('-4.31547', '-29.771127352', '128.47640695373544');
    T('27.8', '60.0346682', '1668.96377596');
    T('12.7', '60805396.70', '772228538.09');
    T('6.808549', '434235.18', '2956511.50055382');
    T('-0.000000000000000000764', '798867', '-6.10334388e-13');
    T('0.000000000166682635066', '21.7', '3.6170131809322e-9');
    T('-17.0856584365', '-73.70395', '1259.280515120874175');
    T('-0.000032761108', '137.87702888', '-0.00451700423385679904');
    T('6.7467', '0.000000000000000000017375144', '1.172248840248e-19');
    T('156.9', '-90.01049', '-14122.645881');
    T('-294748892', '-46912.02', '13827265916481.84');
    T('-1145.2', '77', '-88180.4');
    T('0.000000000000000000049300', '336.35', '1.6582055e-17');
    T('1.0', '4', '4');
    T('2791.3', '372.0576', '1038524.37888');
    T('0', '-1.1', '0');
    T('-67196.498357', '36318.97052', '-2440507642.87511143564');
    T('0.00000000484838500152', '-0.00004296', '-2.082866196652992e-13');
    T('-1488.65084', '-2472469.6620', '3680644039.21081608');
    T('-0.000000000020', '-9.9', '1.98e-10');
    T('-2841.5725628', '-0.00000000000000000049499064214', '1.406551827547777476392e-15');
    T('75.099315636', '0.0000000000000014', '1.051390418904e-13');
    T('3', '-2.7', '-8.1');
    T('0.0000096', '-0.000000000027265607', '-2.617498272e-16');
    T('3256481', '-8.7', '-28331384.7');
    T('13650.44', '-53', '-723473.32');
    T('6', '-8.1', '-48.6');
    T('12.819672478', '-1.0', '-12.819672478');
    T('0', '-0.00000000000000000001480', '0');
    T('-0.00000000932497', '1', '-9.32497e-9');
    T('0.21304', '-0.000000000000159938', '-3.407319152e-14');
    T('-40', '-10124.4', '404976');
    T('-138.46343', '-72.2', '9997.059646');
    T('5', '-65625447009', '-328127235045');
    T('127.3760', '-572993.9', '-72985671.0064');
    T('3793.636', '-14016.5', '-53173498.994');
    T('-0.0000342', '-3.21', '0.000109782');
    T('1.054585905', '1', '1.054585905');
    T('-18462488840.1', '6264.198', '-115652685667176.7398');
    T('-55413', '-9808.30460312', '543507582.97268856');
    T('-1.11918007', '0.166606078', '-0.18646220203846546');
    T('-1.6', '68.418', '-109.4688');
    T('73090459.50', '2990.3', '218562401042.85');
    T('672.231', '19.8', '13310.1738');
    T('-0.000028', '4.8', '-0.0001344');
    T('-0.13900815895', '103606359', '-14402129.22010276305');
    T('0.000000000000054', '-0.0000000000000000492', '-2.6568e-30');
    T('-0.0000000000000000000484559', '5.193', '-2.516314887e-19');
    T('418.8538369', '0.0000000000000079', '3.30894531151e-12');
    T('0', '675966', '0');
    T('106621', '13.56840585', '1446677.00013285');
    T('12.198402747', '1', '12.198402747');
    T('65.314804858', '-0.0000000036124', '-2.359432010690392e-7');
    T('-16207.72', '-0.0000000000052877', '8.5701561044e-8');
    T('-26109.4977159', '-60149.26838', '1570467185.380666093242');
    T('-0.000000000000030215', '2614373', '-7.8993280195e-8');
    T('0.00001270329688', '2444.29', '0.0310505415308152');
    T('-871.457466', '2348528202.8', '-2046642436441.6221048');
    T('-0.00000000000000000063864554', '397.146', '-2.5363552162884e-16');
    T('-24310822171', '20.60', '-500802936722.6');
    T('-19.860', '47497302.8', '-943296433.608');
    T('-3.55', '0.402200053', '-1.42781018815');
    T('1311.50024013', '4.4', '5770.601056572');
    T('-361', '0.000000007669817618', '-0.000002768804160098');
    T('-0.00000001735304418', '164354775', '-2.8520556717689595');
    T('0', '194.3', '0');
    T('-3.7', '-1475870.0', '5460719');
    T('-5888926.57', '-1', '5888926.57');
    T('-11.644', '-83797427.047', '975737240.535268');
    T('-0.005286102', '25.9', '-0.1369100418');
    T('0.0000000000000545367483', '-176.8675', '-9.64577832995025e-12');
    T('-112.5258392', '0.05538900297', '-6.232694041650542424');
    T('-2032574', '4.7', '-9553097.8');
    T('44405.894', '8', '355247.152');
    T('1430.7023529', '15', '21460.5352935');
    T('-0.0000000000000000010538367753', '-5.05921', '5.331581551965513e-18');
    T('1107.1', '-660486.6', '-731224714.86');
    T('-0.000000001271832580', '0', '0');
    T('0.00000000003329420451', '-4.58', '-1.524874566558e-10');
    T('-1.1331472', '22318736.7503', '-25290414.05613954416');
    T('-1320771192.0', '0.000000000000000144797721037', '-1.91244658612921966104e-7');
    T('6.0088825', '-2.06', '-12.37829795');
    T('-0.00000000000000130', '-14.851119896', '1.93064558648e-14');
    T('1', '-54959924930', '-54959924930');
    T('1.22', '-0.000000000000000000447152061675', '-5.455255152435e-19');
    T('0', '2460.4318049', '0');
    T('-48926117262', '0.00000000000019101657111', '-0.00934569915711302150082');
    T('-1.9', '-0.0000000000152246057022', '2.892675083418e-11');
    T('-0.0000000000000000262046', '-18965.321', '4.969786506766e-13');
    T('-1.5349403', '-3984579.1', '6116091.03912773');
    T('-0.00000012', '663568053', '-79.62816636');
    T('-54228857.6', '0.162776', '-8827156.5246976');
    T('0.0000000000000000001875935465', '14.25202', '2.67358697658893e-18');
    T('-13.1992', '-8.93496384457', '117.934374777248344');
    T('1.4', '0', '0');
    T('383.512', '-4258970898.7', '-1633366447302.2344');
    T('0.00000000485581523775', '0.026476965410', '1.285672520872576762275e-10');
    T('-113.2617', '-1.3158604', '149.03658586668');
    T('229813.79204', '-4.40918501496', '-1013291.5280939017289184');
    T('-0.0000735399', '6', '-0.0004412394');
    T('20950', '18.05', '378147.5');
    T('-224.09235215', '-0.0000000000000000000330291504', '7.40158000265211336e-18');
    T('-1212.5', '-89187.79', '108140195.375');
    T('0.000000005360379781', '-5.853730207', '-3.1378217045031744667e-8');
    T('1.721', '-59400291.7', '-102227902.0157');
    T('3', '510831.1558', '1532493.4674');
    T('-79731.7076', '-0.00000000199301902', '0.000158906809743878552');
    T('1', '7', '7');
    T('1557292', '116069515', '180754127153380');
    T('13174514.5181', '0', '0');
    T('11.5557387', '-0.00000000000003525009362', '-4.07340871023257094e-13');

    T('59429490631462462063898399891833', '85.00891132032463441584595955', '5.05203629890205609747397099201262363916734883085091009335515e+33');
    T('-0.000000000000000042109349317791897577655162141761006017167', '-13008827246961207056988713615056579178448396076639.2633976291', '5.477932507570985534957063193452340625430871365299670940723162464475095465880668702087454656216987597e+32');
    T('8591855.554373470161526044552421978378391766637549711729320', '-4.18144454943', '-35926367.5773248178055078206847122253956635626957707604812328535202876');
    T('-2283433141014849078.33114178969776355920', '-453.97', '1.036610143026511036089988438269093722970024e+21');
    T('-834090482593334176100123.7933568971710257756', '-2311068.681', '1.9276403914416302737519348190500409072951706328939836e+30');
    T('189532.2', '2968613550973672055370920.6', '5.6264785726585220673297239734332e+29');
    T('5.5765', '206791541', '1153173028.3865');
    T('223004397.925983046564773982957421494273449', '-0.00000765764399', '-1707.68828752147254136863163630226113151989615142151');
    T('-9', '-861605.04321559065136010082968313802', '7754445.38894031586224090746714824218');
    T('0.000000000000000000028090298007095127212699390661641605', '-6917964065283873879.11378929124954598', '-0.1943276721961993069547944346297165198267413742521737520171142577284979');
    T('-12902.95204428144349964281942884855605291385221512', '936511255610118037649.1', '-1.2083759820067154006199526430520916600744894425420426553143497592274392e+25');
    T('0.000000054421393267623019090', '0.0693540337668146867938144', '3.774343146319828330922834963772562065116896e-9');
    T('-0.00000000007483922', '11963887185334360.01202905021298539073645325022668', '-895367.9851184189424994447352806605141113868134295543896');
    T('-136818356017962729836947190424992612288254', '0.000001250702751', '-1.71119094258963391622539632506259119343595682786754e+35');
    T('89886141515.402264741', '165920325588054483132342147189817', '1.4913937866089484761163201125053970911515450613342397e+43');
    T('-4910559.69867254476135299557110880352698481', '-0.000000000000001251373615473295746877725841601861845423548', '6.14494484412532005943449278569391549262463086794696425713068030612078654982181230588e-9');
    T('188388334026044880874021952902236669508901633565820006', '-1428610610603915751990.6', '-2.691335729036024155624090667679961618627273975496253699574106150646158039436e+74');
    T('2569238997875.3944611244282198384307876980880850', '-45354701.13646736794503189060', '-116527066896795434703.141029468202286044275680813636330729593599972883501');
    T('-20273871998054251005', '-0.00001018031347', '206394372190847.50529696253735');
    T('0.000000000127882266384995374972957752031634640610096', '56084430050054721499878916115459816143192971582.9', '7.1722040237117373866688717282573432808847848059761445842371981626319357370527308468409584e+36');
    T('954627502168195877866647607616261900931', '9.96209474259629834949998607', '9.51008962048762055845159388440432218351076192328571371885622003117e+39');
    T('27452502565473996463690067929.18801932606917287121704780', '-15999511778834005759916561695256821.291408', '-4.392266381547719678372690910805800180664096055687896418712826017984317410615883824886612653024e+62');
    T('24739272583405.47186561318831947000688841802596024659835438', '0', '0');
    T('-14628477765152447836551575115758391.03361640644696947989', '1896549844807094292937664785889813670098706728.8', '-2.7743637235263904499250092914009953677085505785952534916815852412079339245487773243303684333379283832e+79');
    T('-0.0000000065376926', '400694118953983940534743481756583594', '-2.6196149763489805485528325035782515637752044e+27');
    T('6159556.6345747363', '12428.3903194610108', '76553374049.32049544464848654145204');
    T('1', '-214152.677228898078143751453160882566438516677', '-214152.677228898078143751453160882566438516677');
    T('1234245458508975352.84372029387871714', '711.09788699', '877669337572736089357.1591886677375895858960086');
    T('-12435092008252.828827', '-0.000000000000000130972832307119388', '0.001628659220320498210781727802616997876');
    T('1222155005674.47827107178853812873657', '-1.9217613579329307675966802225522', '-2348690263309.514070047950271986297573047714307144600821921806873954');
    T('-9610326782.75790', '-1925856563138573766.221666413429', '1.85081109084807161320054127390660041302158391e+28');
    T('1897933.1084909834795612591951194123752666123', '-19444.86721593176768385769', '-36905057279.327795521442821058258453663270782572671411150172721603587');
    T('0.000584193054195683632690208', '-15427224.032385517626932779704097', '-9012.477125240345688831570386428613444841606254309382176');
    T('-9193123344.97483292546402603464388933977', '3', '-27579370034.92449877639207810393166801931');
    T('-208355', '18.5077', '-3856171.8335');
    T('0', '-7.9', '0');
    T('-146.9974821', '27.85613660690160', '-4094.78194224817268246136');
    T('0.0000002221395758167297538432', '-11018022952341415341382543191308.248305367013916352', '-2.4475389449721144325377299337884145675514764946137036517351977553240064e+24');
    T('-62634425863308865890231971109828114770592016347.2857222333045', '-0.0000000000044191162667', '2.7678881018796339994185288016784587422371771822944265151385376844431015e+35');
    T('0.014785725196930589141008331862', '1405730020396633.72', '20784737782660.25819955773732132563645741958664');
    T('3060880958477929473167827.136432332645114184906595927797020', '-134990224.755007177950183445', '-4.131890085332574931410011369432785413898866996911658019131150911202211096837243339e+32');
    T('-251157.56', '-35553.75153', '8929593483.1210668');
    T('10660825.6584256928', '-54.80641419272238648411', '-584281626.672080870616452029619482941408');
    T('0.00000000000000000018196806510154644625549186906147312734531', '290466772346954491087868523893813560578350699536244189', '5.285567654026668587345538632825206167793448119823731989523008725260266169443990119026948390359e+34');
    T('801946936195133455122.3263199289', '3353455956475898285353850471499087737905097359235396953.528', '2.6892937299611674351748616442698675657013699635861635172559630870783247800626545335641592e+75');
    T('88876291341359997.22', '-242985336224765018278774996045975', '-2.15956355339905308693512776069018053139845369921895e+49');
    T('-677.8706245402', '-40041.8855', '27143217.9316521785471');
    T('3.1852520702012', '0.00000998870874036575237809441602188548308619567919990770190850', '0.0000318165551938868335179942506676244968068581347935045219680140052189902');
    T('-2897031868709978067512290.19826378134251899155435029', '-0.0000000000000313426136', '90800550447.862773034512424935249089493462002949664538517944');
    T('-286245211287.816038991926811942762853058522756387871', '-905725.51698541', '259259591978255100.08416583456412844730858064475954566698860796211');
    T('-301283745846510635986864779646783.59226306843', '164455867753899', '-4.954787986333307027587976990843711993792791415951383630857e+46');
    T('16627939773', '-24446.50', '-406494929660644.5');
    T('2835613541302657637165162939561661439198237', '-34702274210562114517526690656890036690211485', '-9.8402238665467925464317665495284869217720281504532926830801758242091305082784369151945e+85');
    T('0.000000000000167329000479220734904842317239446253923254', '-335462.843', '-5.6132662217107750155727738207852552086794690651122e-8');
    T('1606900543967463817538016297544283302866330961.38117', '-12172415089417043266077235.5931339752547820885496331722', '-1.9559860428582011548778770036179464667831089769951903599695351323242935536918541220406695361968160447474e+70');
    T('25175391597018424433550189069315474558138086224811394.9498', '2697842514071148.65', '6.791924175882585620347727294751149080055684613881481427569426305249508777e+67');
    T('33605644614556574.500804536703659893409117374', '-32.543409918351171133101366277860678601667282494', '-1093642268261945046.079483918411013199812861395190797870188216612955697572700923777661450756');
    T('-16194637333856709349021519708.8552324881761540256020238975', '-468.317375400951782165492196622874246631857734334382', '7.584230051762041449005379580598839525796458346850505580761259136785876093027076066542485326077054219893845e+30');
    T('45938105933592236851533187176.70670204189811056', '-23728.6', '-1.090046940455836751355290385241202650071383506234016e+33');
    T('0.0000019359500318287540988972385182980431073131086249', '-1.433', '-0.0000027742163956106046237197427967210957727796846594817');
    T('3.383292222691', '-0.00000000000000000008416407858503881', '-2.8475167250671594974339763771e-19');
    T('-1781216226076936151337005862078252102700230837', '-139003643961.53840777847576996', '2.4759554610811353724544585499901643072996118138112041996180785490331025652e+56');
    T('-4942215729757062263164723577.197780606517', '-15241705.579', '7.5327797060859772211128133542568249856768162658343e+34');
    T('20212448898283508798.6625218057881201405', '0.000000000000000000473337907308896740021174588136160473489005777205', '9.5673182631015315198993602152061224371243489547543953762429365302559862133611162973025');
    T('0.0000000000000000000336083585075308914988259705527435231286920', '-1042029834722073772731648833.0978', '-35020912.2608826168412442748054117197175486895048242174316983271784220776');
    T('2376653285350901814422.788590453876', '-7116898082702.215', '-1.691439920976175340680854757410757210391140053534e+34');
    T('-0.0000067077602282', '10325935005362413727223741709915.3224340753', '-6.926389614794815252662513824455946141306951378398346e+25');
    T('118620396179863704912953340.8484888231431511', '0.00002664482432944840555300828814', '3.160619618102041148915830017998160333002812044061355761312703976357954e+21');
    T('-0.0000000000152038475299141990408716170165065', '0.000000000000005856774815228245375399878344009978104812414293866282', '-8.9045511307771647940461821641351376995341987855772716940834996589432243659697783833e-26');
    T('-552929555032574543198346', '0.00000000031628803556881', '-174885002769189.22345730619750676118826');
    T('0.000000000000000045838', '3539579713.731326460', '1.6224725491801654227348e-7');
    T('1392529024903490704995506782982906.381429', '-696.803141131', '-9.70318598668840847367530799623705904459432004456199e+35');
    T('0.00000017046264046382452', '77820777096586290650583567570533323989282', '1.326553514683081867495692236827890756347852656781320879464e+34');
    T('173.2', '400230281235477723305446756183676238679630391', '6.93198847099847416765033781710127245393119837212e+46');
    T('441.339801980', '3859926956832539877913158087979570115173.37608', '1.7035393987857371577386465661853388929161435925152686384e+42');
    T('146444036588433930865962234014095372651938826216413', '-52287041949860150983876138.09252718579', '-7.65712548440629977355786783708824277254343945936126868688503521615280343003456839837127e+75');
    T('-152996991626635397079841283901340.65158799', '139164451.4055465586500905725256511816907743', '-2.1291742406419715449781823729219758981469966625530964344454535418866326578427680657e+40');
    T('-2392095943969007513831013778238', '283213.66941826693939894680290224', '-6.7747426989201568951320097088428601075588412800688116615345312e+35');
    T('-15192560288102281367737239879605.47240096086', '-81553445736510122', '1.23900564105440798918085016560369292282227123306201591582492e+48');
    T('1.7067661013360140299015089144175628', '-8518082392971818901480808577069938345874733', '-1.45383742767114563412540521449653172561766842289564535605710831784007839607324e+43');
    T('111116813960956208515375359292296052638950332201721672', '-6723639335232846900768096240894018745358463215413', '-7.47109381153635523540473499319528741906993971058857734750058361188185043050515216086975306279606530536e+101');
    T('-19017520.49675261317806237143645102654220495050', '4439261178196804.5636234243239638305', '-8.442374044679588557398641259522603028251217372386419857709859483039768004289025e+22');
    T('17312453768.05379', '1726.44336801935101862147113581125657128654142147602', '29888970991998.0896280136870221704774967797321308901016337045551158');
    T('-2', '-8.63876', '17.27752');
    T('734608.2', '0', '0');
    T('4.1351657034625927353146715451605855050687982255845069770', '29034498780299324669067501513285520', '1.2006246357352024765485891656111571028229380504313388083084112136514462841267544463307304e+35');
    T('8113870024531627718699652079910.7068190690295904975254176585', '16923534495569343509614671152502455712381.505727413', '1.373153592527270771522358333649474524182371877317191394431842566433920202044363434189424789373922626777224605e+71');
    T('-10.01', '-4864429445729841.069760518121786', '48692938751755709.10830278639907786');
    T('-2257142436339514797101935880.78', '361.115', '-8.150879908987438859554655755878697e+29');
    T('2334599.31164827194227', '-29960204503173960913.6', '-6.9945072809951386426110474550748535657872e+25');
    T('0.0000000000000042471515826788460724024393725389035009593598059706180678', '828398091382.612675070213', '0.0035183322649037987809384707757042363075619742175811901626183872501809043713944414');
    T('-0.0000000000000000000284493127383335026590175755701910596367998889566726', '-0.00000000000000000013237', '3.765835527173205746974156478226190564123201301194752062e-39');
    T('-0.025286262', '-0.10797436581647216600797099911020807463243214320798554', '0.00273026810331915910538504877190248824967123287037864285665148');
    T('-2.16564935772054852403', '123868749404533277771925133166764554.44147780538237283827', '-2.682562775895750704487504519843216927715513029094342900139628307846103986281e+35');
    T('488112856156098659519479388744402.61', '-3114334168535743226695852106494538175980162249914143.70', '-1.520146546028510353469309736526975923164123845906295275264771051373672808879616446195057e+84');
    T('13062458273.90637045335784972', '-422551949801626.741267985176602715381458097174737967000518', '-5.51956721284152853764296726669744927261362132472755924039708895768532345915860615496e+24');
    T('-1774897196938188058987.040101468413944266333770483137507', '-546064776871.3594927107191784', '9.692088418156530694143698199431520418181775404052225935078568528036161040292642488e+32');
    T('17667764535653225248288857836.95612603671740964890', '-0.0000000000000000319890032591629766', '-565174177313.13507635499469894977748029671843469133582435048491574');
    T('-281835819.9184911063', '-7175814054420814885484554.4', '2.02240143761032232334599327109026978241853272e+33');
    T('0.000000000000000001503903188910', '2473558551492927739005724.481043938460207033289961875', '3719992.59354581446800290523978683389613115250358419250482280625');
    T('224371010310.537303586', '-8046248744083810452149728.077812213', '-1.805344959919976464767416627850984855572049419079495818e+36');
    T('21241841371778633003043.69805019497112440', '3019928870075002318121482.417', '6.41488500121878843990786691028203447626143414100289387726373196748e+46');
    T('-0.000000000000000017364919937061080720023417741392471545683503908', '-0.0000000000000001101', '1.9118776850704249872745782933273111171797537802708e-33');
    T('439522909103802363083392888521183473696.816065', '-2.2', '-9.66950400028365198783464354746603642132995343e+38');
    T('0.0000000000000081177461857815960900264491259569062173810350', '0.0610415335877925918303617472579311', '4.955196764565624988836180976890473307042478930774835424434663605140744766885e-16');
    T('-186798563956757871041672400714377.094855823', '-1262567588714917541983982710.193577', '2.35845812470293091731202495176066945197325419055745256762489749711235648871e+59');
    T('202739871381.909125537', '20323942031180.7301604586345358572504650', '4.120473393374958139010105109821762644139100410749336624705e+24');
    T('-0.0000000000871057582376852096451379468926610553156501430073631916', '-0.00000000000000000204556363069958967723715901466977445824097114499093', '1.78180371075520049530019591335531323553330829840490421849868550913658281328132369671225257713629597852188e-28');
    T('43650.3286859870996376890566772833', '0.00000000000000000001310330289622533562857521522228834136757813518300419196026', '5.71963478292282611553143218521780871633322080859969244917523136988043505512171959238361658e-16');
    T('-1092205601185294', '2', '-2184411202370588');
    T('5860768904954696696.24176142662833543847', '0.0000000000000048972255', '28701.506930951217005600908223400663331828964985');
    T('-85896656824567.02163635501735158916726224558523587655', '32321.39', '-2776299344922992287.4470686942774805948582718361870079644045');
    T('0.00026', '95786603846831218908589843126114668233645', '2.49045170001761169162333592127898137407477e+37');
    T('4045878451917596479346482', '-2.2547', '-9.1222421455386047819825129654e+24');
    T('-0.00007402891873793970469482766866928008041088343139', '580', '-0.0429367728680050287230000478281824466383123902062');
    T('-294517422548703614947348777318332.649869292704089396942', '-0.000000000000018464905130542546160683866082', '5438236266653724351.349152153311431266266033202633265447500622081254643984468321244');
    T('-83.506', '-8171012757524040761112.5', '6.82328591329802547797460425e+23');
    T('0', '-0.000000000000000052054568154502662326801153388437977', '0');
    T('-848457792560875.315304639536969249869368391843456', '2786837672040308423168750746536175069.979124227', '-2.364514139444808677729215519365182902026897625419714103499744958027008402375235640420961008512e+51');
    T('3114192', '0.00000000000000007442771895146280027117559688227552768887141498150', '2.31782206936893840902092874406007390124461849564067448e-10');
    T('0.00000000000000000004917302646400565894337036110048', '-422918872', '-2.079620088498342188194690499484768025856e-11');
    T('-497313848.92', '72015813415347226684601.47954307807272704460158688818499730', '-3.5814461352690899900766892687894799291942231391683303086680262807916e+31');
    T('4026.7272674898467547880850473160814529617052037657449361', '-21157682685', '-85196217784587.2940970833078499068622793775121577888984306494014285');
    T('161789945200634672.93574932528', '-8005803048483811151653134568908048072385822541265', '-1.2952584365012698158369216496463941318557463003471359935387477829065387076792e+66');
    T('-0.00000000000021548823070578223953868560097628121116323968225230682924', '-49653567182460198793826479862157.077878', '10699759340379041130.65114538401855139934323670216223964167385329900350710562551938222192755272');
    T('-5565648526946998.206396582068274786458395468246488801913', '0.0022945055453979742566004395333553200630524525428518539025', '-12770411408815.9541406930749916678604063671114068656466120089976699763004963995450912686342679576306781385154825');
    T('3.271826', '-23890.6474306628013', '-78166.0414204757505261738');
    T('-0.0000000008805699092114903173390188646922', '9284821552.25745813417849639083469216233186', '-8.175934471316238510307959904561765618357930068136953080998844682973153492');
    T('361333176.6552043788873570', '425816532338214481.0652246362221874080822', '1.538616403020706012031174663425818903103785031033415757451967454e+26');
    T('2805.024', '3138666568668923617772609.35105', '8.8040350531139788020189957723196752e+27');
    T('15516261613526.6610074517562', '-0.00000000000000000236624580694534592762621412652683109621677385955', '-0.00003671528898247448920639683215816512848818717755547603887938060370189964171');
    T('-0.000000003258489294057571', '-0.0000000000000000001263694100620034334234551033555508871', '4.117733697834092773082498224393477748428351275212341e-28');
    T('-21061048707054855665564434392186020553808698597863.879494', '181831629693595281071297779845', '-3.82956480945997219565546562178683388176250894166635033461551679226752688144082199843e+78');
    T('-0.0000000000000004150087739116129831368627055614', '-1518028660414097725821098740744462450073.304250189994494', '6.299952131211430047024557585815135401837971947761937657558761468690680184406091789316e+23');
    T('-329353403844205335310.931518048486742714840512646142', '0.000000000004737902605006197777999824176859382087', '-1560444350.041118731605073747643365481135986445785795088564232590700292190358983404458354');
    T('-36414599958286461846528123709871289767333710768520', '-11982666807671338.82516899790506494507', '4.363440182347893057208595495864483712233866372669435753275016489496855915098212851964e+65');
    T('119742066861.890807047', '22054829383.984629241', '2.640890854724681514607753859168565061327e+21');
    T('-484485733573777836334476960525005005848019789', '-14406177805616860655.8627771810687838', '6.9795876221485617831711438674257823866674330443283469578093046623068838325626182e+63');
    T('5988848948477.078723617', '-6.5', '-38927518165101.0117035105');
    T('-1.0', '-63379703.864490098873312332', '63379703.864490098873312332');
    T('-0.506613427677516177791327725446313117452', '-0.000000000000025064675288473359447414244747114622651598944039', '1.2698101061517425226884571964189454600296022874042153446180321519393920461477382268628e-14');
    T('-23042537.21970212804132180', '10390764065108.50823342162627716811120', '-239429567711406187063.05734442567122738046800108051885738416');
    T('9812550833139441428690193893295885866528739.860970333644852', '-6934084675959416258239634601815942.0149731256600469716450344', '-6.80410583641450037528576307977037672169914839765125030421279633360096772675136555394720496053502446210349236989229088e+76');
    T('0.0000347689', '0.000000000085057549281766287602723911010', '2.957357425222803877030347389515589e-15');
    T('17309197932605.95272164347202723030822567422328', '10372291249693770815173154703247665392420536', '1.7953604225558623153970783373103876250250653717733283278048673842023984171292886092127808e+56');
    T('-10.68586744857482180099209534824648355512284245440', '674588.26676653525901087', '-7208560.801031027382439380269948592059745431252505648164243884987079328');
    T('-158425376406388668464703992996848728.8980383980010724', '516624932849644105480296.4740763529887132394681136194056', '-8.184649944763013743333361097416811851476935800617569830052596874617614630479435342869900779234127425056544e+58');
    T('43701371988184830897740842', '7444696727806908941269732116534493096172849746185.16', '3.2534346104111212105848066810541857916878449567515264310528659180255182630472e+74');
    T('18985671206766137596695783', '-4918195942924959263752039745340080571253768938', '-9.3375251102824433332331539143355814981375199246602425748207454160988454e+70');
    T('-8164454926564686613685695436631269148628112649072225137', '3017566861500503598.7', '-2.46367886286161259704778334978048504960179943566519245177920238542851005219e+73');
    T('-167.140200050688164319586013710074703990054053511303270', '-124707.791051624249704808849761672566349962496678', '20843685.14424789642526902036712772659312890967899817539551993752122248668554302671208072486282553706');
    T('0.00013717932814418', '-236889624553106847157555062629.1419261258', '-3.2496359540522243673339058837639891572432570371217844e+25');
    T('0', '-7377966474', '0');
    T('-1165159893843574357027338982426', '-7258741844369034621359206819796872729971572863114', '8.457594876822935516127237999861301735400382433503942145536493041682252149634564e+78');
    T('127327741', '-0.000000000000001314349415125924728376790639', '-1.67353141912655226200255348893816499e-7');
    T('-19', '674693830910632347225468600360472778098653805584.98', '-1.281918278730201459728390340684898278387442230611462e+49');
    T('1115499473064514172110108362485045185533368299248344166641563', '26727699066738.5277545215239', '2.98147342251737349166633853134205297966348378257402631237265170730493167637686598378557e+73');
    T('9531022923010697243825538443.3659', '-10497868918011538716', '-1.000554293003294813441624977396834705527412812041844e+47');
    T('36948.619152016593259861704969912416', '-109424973578674628984651491823525807602358729239', '-4.043101674477927092300739573396847025094408695070482727807518216276085630888331424e+51');
    T('-0.000224994118800115645797961334226721592496197539765940949883662', '231860.641001', '-52.167280606449958627644387092820869098935873225250256147940687697225662');
    T('-81737025015671727638688.506795636777200442300', '5419138.800783060', '-4.42944283723002262118621171335050352165263579845818347438e+29');
    T('-1466856541.9549101', '-24128674849693158122765920.4', '3.539330455197531614891444994295155372575604e+34');
    T('3719432135548', '54707696881', '2.03481565841010488825788e+23');
    T('0.0000000000000000347350240379700980370747179429442891350492370249744117', '0.0005534400198558475169798243101266211771697229801', '1.922375239326751185420171365530525629522813111237423841789162415238003577693927327244648617996830717e-20');
    T('2248441073845808666637746763786280194954645599162114623.5', '-6334923145497633015473724024497.97', '-1.4243701399993365995217919270799399913979461349413953499228708640778427689308423183064295e+85');
    T('-2833.50779749', '0.000000000000000000027787099520949762309607915049358999802', '-7.873496316224179511483613883698024416527436609698e-17');
    T('0.000000000004441882942767312311877169439858885409', '-0.9432493370398481379786084999178021934162', '-4.1898031409738770478382967231410155261701150266906290976528356507851700442258e-12');
    T('-2107306488.021444213082463895093082025238625832167567', '-0.000000016561760020640192077800', '34.9007043445492445900173806825761285679208256730753889935834487955007126');
    T('-129070822817.42205', '336811489052744821.06', '-4.3472536026398913255504341077748373e+28');
    T('0.0055725231631263368659868273181674133608110946135789308', '-152412560828753089910310350.5653132', '-8.4932252556962839520515736693985586025569561774936573592091065011026694067884882312656e+23');
    T('68902.0767970349411722981874624462811895157551795177137623704', '0.00000000000298788286086686468161985148648212755894442142', '2.05871334339993176415426311877635990320333360195205545566288301397039058040718828895421507390094595733968e-7');
    T('88153860095637039945277243438872776.064214155', '106.735', '9.409102257307819458559166578448085753213897833925e+36');
    T('3.7075516820964288985011546648796', '23633186593.70572408884166096265287527701858061993092', '87621260708.792430109916115951342109977008394099657174865349158237730095429102117232');
    T('-35505760506401161908713691885731701346896104.7570686644891', '-5457648514664450630675291184021238402035211', '1.937779610897920137400487822865364585421914753043232864073023463191678738063333894770237751635257001e+86');
    T('-120.55403235772170', '6237.155894', '-751914.2934654306175666998');
    T('-50246944566472610231911381270921126440112308695', '425722751177060307857193841626947340', '-2.13912674790799614679030549405709134417922674778586880217918152980768287325891213e+82');
    T('8119749715097219059818517125264159.064450132566482', '560418609424712067.0940695322762258473926083185', '4.550458844211485491057203230529751310726950775388516102150563306194801442473073934282587480517e+51');
    T('0.00014717424858', '-7244528491321.3877', '-1066208037.026626286030354466');
    T('-42181198581127024501.50753334291048422600', '-0.008682426489650895544', '366235155926002047.202675730675546783334970920687585688944');
    T('-57.3', '-96900776925224476370583151961084756', '5.5524145178153624960344146073701565188e+36');
    T('1083976078583942678025084625.271006', '-0.0000000000000000534905554182086699326584150063088902383604755', '-57982482503.506901999157564033733434733806444040999020955818569250676306523353');
    T('1058587.736740719', '2.2', '2328893.0208295818');
    T('-337676088587247469427246609', '2694990217595978128', '-9.10033755458704844211026116003411819226167952e+44');
    T('-180266997707357275243150935948776784257767.114595713620465125', '0.00000000000000012929550822108208448723385741716775647229370346', '-2.33077130840613978574569769854573934386258812596377482210267408630672963476159438278046789605387340218325e+25');
    T('667863393175854.7645678', '16647944315358092755156.00', '1.11185525798577381655823461635163932295615768e+37');
    T('-2607482796153.37663635999672298', '67905.1', '-177061380021074655.829689213473629198');
    T('0.02649777513989417670980608', '-3.7', '-0.098041768017608453826282496');
    T('41727029296529241379347405093482273986363238008823.7495', '-0.002796170808176706621979157103112461500671267733114714664', '-1.16675901230889282855531874612261889002345278810932959186816789276573413038428661947418401753559128959112668e+47');
    T('-11232695034932926234846674550549966790.9183', '-535612384919640506677833697180021817295233383415483', '6.0163705767354292540256743939915265501958563028272108803751138896375435530577152378000080389e+87');
    T('3.481826810306751', '0.01981896398982153971994255430994006244', '0.06900620017226469113521762438686245737379444049353244');
    T('-500336401148192185730936', '-0.0000000015351207243732', '768076778560892.7643589222652324493152');
    T('0.000000000000000010152819846152021274527085743667507483', '2034271405274844529575.93770552252121', '20653.59109593400315620700194269765880413700716562682807038424236270121443');
    T('-8', '14804.920611063196753', '-118439.364888505574024');
    T('-7644880', '32.933', '-251768833.04');
    T('0.0000000000000400490024778789822215877572796299412810612705023875', '0.00000000000023561893047293924977558189853184387736389392033215150171', '9.436303130345939646688036612188083884147595770701765354726302304762424603125782629215278913888534265332625e-27');
    T('-669622098209324787.5786201166', '-442008.19657257', '2.95978456014644004507422179531566173761662e+23');
    T('3750095561598843110.3554570', '-0.000000000921072821137', '-3454111098.455188785930556597852894609');
    T('509.01003417', '-0.0000000000695541947', '-3.5403783020913832899e-8');
    T('0.0000000000000000635110973210625767420869099697944141102671291', '-302.6', '-1.921845804935353572215549895685978970976683326566e-14');
    T('-10277403.8756777588787330367830', '3.73924958', '-38429778.12561843210264377872295730114');
    T('-566623967.574094904804042946014964033941069', '-0.00000000000001662953909014460365351667', '0.00000942269541818623958668998623752446360099484415277625603154138912023');
    T('0.0000000000000000060428627571787342505274', '18.65854757486578220960', '1.1275104224320402610478848029208041233734304e-16');
    T('6026260424.00', '18673139236042341642133200165212521277908.5537452', '1.125291999700035578262744750920904785263182229257757399648e+50');
    T('1351407130504734.056748656589882', '-16213.40426049972577134801362523633', '-21910910127395164076.55243444398575049081525274237838315413681306');
    T('-1749812757762436212668429.46101826944561361814636104616270309', '-259646', '4.5433188330198551287450703583554958847579349723006019196120650614e+29');
    T('70245313181709005413989461536786.3825442617', '-509184726219286329641748', '-3.57678405606165250356068075267063781878365698344246156333141574516e+55');
    T('-16.20', '-83495.2179048376073493099472538', '1352622.53005836923905882114551156');
    T('17522790821382422258618581410703033443568', '5481690529703238.18676804112985115150792', '9.605451649954285042649291504450317447918361312248424196122189225108309342505856e+55');
    T('3', '-0.0000000000000000000298256458973606523936524717292889013', '-8.94769376920819571809574151878667039e-20');
    T('-57135112812568.466051', '2713703246.301287433494800761485396936819', '-1.55047741117257327421574162146466373193666197915868993431769e+23');
    T('0.000000000000000018433', '224.613695971469169', '4.140304257842091192177e-15');
    T('351655210258904818533038059328', '-317039471793459879795242832647363526701869253095475', '-1.114885821139012575684668438594527497497409491712701452561241865985548506983408e+80');
    T('-1317999447639091934290806166798244489675877673.24510838', '51973652129741187036804.3069426597647651181729', '-6.8501244798785198639385417890806274968448700953804306642353363730416792643087698202422857568078902e+67');
    T('416970579045160473905951389152873165527755895', '900715.23677692450', '3.755717538336730295514426258945023234083011232063852048449275e+50');
    T('337048915259856.8484', '-0.0000000007165482473721426233042063689577689', '-241511.80950813224169860503564044515006631691904953476');
    T('-124735.945324536963828', '43656784749.045127925982651536524807752332', '-5445570315501972.252440976832268388353995138128083224266646896');
    T('-229.309150279271759668506974147516151893493701324327298', '-56277750392608320423429992502109.4808173149501499937169775', '1.2905003122157966621553106534643794501210439187980937861478914275127685562045563793515134308625165671789301795e+34');
    T('-773.26721', '506120106.96085084420866486187778058202', '-391366083034.5187115273789355692667516507815642');
    T('-16179029077993579729752892854', '-0.03205622515938674669127103', '5.1863859898442754973726890489016131925911697266421962e+26');
    T('-379694977175773597575402239067729598591749627164211967089', '427.4134', '-1.622867211576197909699344273675511380147349200949881951741975926e+59');
    T('-0.000000057593691704585518467986423410653803725013114132854316233', '24689.19870977557359290982947617857947691050', '-0.0014219420989240649383441724944840134755882327254494635758934109877771747341652064425031912888381465');
    T('-104', '15074917718070702275412', '-1.567791442679353036642848e+24');
    T('-2', '-971091107444027282033715.48309206', '1.94218221488805456406743096618412e+24');
    T('1.0', '0.00000000000563083386598228603', '5.63083386598228603e-12');
    T('219100199509205287520379236835.595422414343', '249215953689501338499522.46564075955864255', '5.460326517424660882913977937259236613421658567164008732143598687724455221273009465e+52');
    T('-3956981388.58456771827964370777', '-3850656424026801387755000322904.790283281327', '1.523697580370765854419130687951064298276236466076285768791284492428581079e+40');
    T('734.960286303554479116990306863761301115192463389214', '-130000607393220114986132790422441608', '-9.5545283629357036833302332771199553820796316440028291953441171730648555190680692016112e+37');
    T('-0.0000002666120264878701311448', '322570889825538918018562439468.0160867345870', '-8.60012786223824197974573415201224841889283841235410512800651976e+22');
    T('0.0000000004031032595796909999049', '-2712762676362394173603186', '-1093523477307807.4647872649597513148096163370114');
    T('0.0000054604495949732794611395765459328765263001334150', '-298907.681810114352964823611311466161', '-1.632170330074440811222971888249135550087671561067062039655656486575779653557869815');
    T('670489501929686.291032', '627223395167741302962881364608526379428084315920', '4.2054670182466566942266803112300612071880467870075440896463575082944e+62');
    T('53314.110410802505016043147844064319142110836740', '-290216592240562577134439451.5', '-1.547263944176020278887164669780998856796671698801721678198701042353164811e+31');
    T('0.00000000000587199496778346240428737868027766', '-551005.316277', '-0.00000323550044440047912772450593052565891047747182');
    T('-89694219111352199451730456185908593505562.881', '6.32', '-5.6686746478374590053493648309494231095515740792e+41');
    T('12678032520049858276397.8', '-0.0000000000000074933793548296330814995251238051875041756343', '-95001307.14560031424594545397066655517994845175009207951656553412454');
    T('-523228.1027985605', '2361103.2', '-1235395547847.6101519436');
    T('-422058160.089943171946211', '9455722182962.552320564582039151365712747392896268147', '-3.990864706862835827499020129041439986893906907628633530927174587244916641017e+21');
    T('-265.20593471797540408456443', '-1', '265.20593471797540408456443');
    T('-117096397.7', '0.0000000000020', '-0.0002341927954');
    T('-0.00000084780432839108612959331480507149065703369783040', '-0.000010825079810960431632673973072527105', '9.177549518911214340736347681158868989278870466087868848313439029850170283692992e-12');
    T('621.284586089902789096175355124878176656898069', '0.00000000000000000001841815997332304201462126563776625573631078', '1.144291889556362115393585911981542504972877752024640554149220155131163404208000456588382e-17');
    T('62838970696961.93575529768157435967750130012543934643251895', '7799025017418', '4.900827045344027526036434980262455014867740735222443957786401853650711e+26');
    T('-247353051265858.992388279974222435772900701328741022620334222', '13.03830659799478334978416300680018326059', '-3225064920353791.19824546858361898880804876150878659765687851458354866130547449520822131539552091098');
    T('-2139441231754725391266252450690990152166777909', '26220446827901878.81347', '-5.609710505864567774726728960484243595395230887890837315312192763423e+61');
    T('14286913921.940840650', '-1242844090.352406582', '-17756406537257697634.0436449596731583');
    T('2437674767843424972272.34179653188260607311276734', '403927988104479.6110322848268399591134551070', '9.8464506462804905964641906770409128324751565746334602350400894172348609324599790162580538e+35');
    T('-282975256.593232221485634', '0.0412485784400225687488894518785', '-11672327.068171452858593608252189019369153357222063469');
    T('-256178508.2486827293794161556160000481333795995', '0.00000060622407729698677', '-155.301579786376201792071982290374904153826835212494097939398615');
    T('-92215568824012627934.74189852734', '802821222.0162469626002', '-7.4032615652217143799840729492067368601093636437189468e+28');
    T('0.00000000000631216424157187020311390', '-28896.442960029403', '-1.823990939609188046299993634327261580017e-7');
    T('-5868684173183824149727150676541321228.27946209763645', '1767678018.67', '-1.03739440114535694186833871290131127571890503338033620259725215e+46');
    T('-1464504298805396118871695503432730.5230', '2208833322892572033925', '-3.234845896720779321449912432206390896261116508330538992775e+54');
    T('195.36', '-13214599838.47575096481496546334113027', '-2581604224444.6227084862516529183232095472');
    T('-178.8581172026568', '1542628302874005920400457301.7905298303732', '-2.7591159379557450261955452194656628921038300499237551776e+29');
    T('351875781344.0280054729542235343559317', '0.0000178856834451374927', '6293538.83712970189834558679045935052951438284631044859');
    T('-307.61455274208', '0.0000002438400533036931515021270613358401352036899', '-0.000075008748937620515500399556886599434410402744867379000992');
    T('8320.987246030626877296', '0.00000000723034', '0.00006016356692446508273598836064');
    T('0.3178832760474045258804752', '57.66675963865299188481', '18.331298472973254687278485883883193525626461712');
    T('0.000000000000000263835146673878760137331888121481766389116183835336431047', '-2.082954760', '-5.4955667461965393109095371006242790355341756731284907525076043372e-16');
    T('0.000000000233346878395806113798662159173733434871136164480744154169890', '10289471873381.87490244310848109593247868', '2401.0161419951076855155738296198869665643993521903141787021173990086767696510557356775276055229452');
    T('-0.0000000000301270068082410889159', '-18488503331.384508718698847', '0.5570032657388091474587525501237955790818099673');
    T('-538244397964164173070105649994388625', '-2280.52363653', '1.22747907178713620859177763155650252117906647125e+39');
    T('11816719921.6984115', '24346834400764849090360336454820099097991.85306443422359', '2.87699723093810199016709496254407379606350048843381923576632239138827285e+50');
    T('-0.00000000000000000614056701921479118164625780', '-0.0000000000000000004526129846', '2.77930036570313218519067348427902988e-36');
    T('0.0000000000000000000211718849571685401', '-21818432978682095763187832118707.42059881629', '-461937352970.349445849940275487640330004420702796016087398229');
    T('354307691910025309530301150.530797676735046789927', '-0.0000000267343273366', '-9472177813397840300.1738065546659359293415312312254736184282');
    T('-0.00000000000000000001564140879', '0.0000000000000000012127764653067414424836974110', '-1.896953246475399564472178411611564269e-38');
    T('-2192995405.921', '-1492963957482', '3.274063099963661175050922e+21');
    T('-69077326289723825817911969975.2', '-160.497210320954020046818', '1.10867181659309712810734480548942940388027429142989136e+31');
    T('-34636483655.3', '-57826095450336990.7625812016394354487909856618', '2.00289260991541487342513087342333948596839502091235357754e+27');
    T('0.00000000000000000918981946289', '1.09999674198752514', '1.01087714686325481931551720546e-17');
    T('213150740', '-13337847744665673.1379595', '-2.84297211678281928195418951503e+24');
    T('-7062099495908.198413696', '-1.058736021405', '7476899123064.10206563783530116288');
    T('0.000095694936784775916676475094824420202134897751844986130', '-336195659475425245294044969885823799340891152365601.95879727', '-3.21722223808168692686768515627014434144106705991738803812388959163318091496999877734952100401367322242946318651e+46');
    T('26868896167028748101420733486377', '480507267329881259405862882', '1.2910699873389304567069920812073966334143151295977876958514e+58');
    T('-17.084476787578052926829789715003022556', '-42587983371473135737559540519744259126585114576504024.779', '7.27593413339692893938094555667816327719803206600514992485982114723845688369293247684119915124e+53');
    T('-76372412484569384.3511', '9012097234036431278745.3269231299', '-6.8827560730887716103930962801811543430595527769250789e+38');
    T('60654377820540327528', '-0.000000000000015117053045659', '-916915.446964550856786185798600952');
    T('-1331839674', '0.00000000618492062771114573665144', '-8.23732267252668770406834370123056');
    T('57436192370710.8629215108579', '105737032624.1773726358981981702798798174015047365867', '6.07313254651038202363973449861725599835500772846363988048609447329832343472993e+24');
    T('-965563477.0996002946011879837917175', '-4271362438679787505570708994903.70810816', '4.1242715682442838707409662264403439596770359705507151544781327654021648e+39');
    T('-0.0000000316616', '-2.4', '7.598784e-8');
    T('-2.385', '27.5499221426824606177', '-65.7065643102976685732145');
    T('-2266803.57818655', '-765116.77815066069', '1734369450442.4824101199545717195');
    T('-32731559035569126148642.446165008', '53704467616503577993.2664889330721452187634866311652474', '-1.7578309522633972201948025668355694620574985124468833198585070981942000057664555429792e+42');
    T('0.000000000000000022575861041290712552639790861752973874588224619267844', '31.3944076810173444579596934007549380765', '7.08755785280277370389292313902506994649964414578494551292873810891605957242649610987662066e-16');
    T('-11.858586370905899290715', '-991047772227373783020319210519807971818.824767583950836915', '1.1752425604652188758145553608664648912870842306418133290829487635928729138744225e+40');
    T('-2011971696758986575760307857385008882209510.6', '-5525155372891673776761633609.52070459365483366973020593', '1.1116456230453892069924547730202138929609342602851169377795116783945568725725156231784447542517858e+70');
    T('101703650999596029193296586451725488', '25620023337044890752720058833900.03506', '2.60564991207231919895254185864449131548456396842795048651050944069560928e+66');
    T('0.89310', '-4483944764830427741251990095', '-4.0046110694700550157121523538445e+27');
    T('83.0660898', '380025540261.5474990692628313817425000', '31567235653659.2200446528027713580805854765');
    T('12249047873.6982', '-142475289409910528840622723.707048987614004620751135579865', '-1.745186640801000235481534461055817862532388247975966963088442739006743e+36');
    T('-0.000498899320558508419779744140203069146893', '-0.000059386343271843835168818993', '2.9627806308777237249170821580126645410922765507304403542845338749e-8');
    T('-2297433.28538549', '-285796548778125338857408803711103260149820899037579434872', '6.5659850401116294498139439137406267368280581599271391787641901086880728e+62');
    T('34167188438641414252422741077347811417020.59175671639136', '-1876839.0519778124207491962458916326915672158166', '-6.4126313557927024892196883907714297942957465376354294400472573526515361182444034644427066219867584576e+46');
    T('12880636073104135025.684594372389347', '0.00000000000002717486381885835955193357797034462478107970045332718', '350029.53118687937886399193088901600225479341922014167752066254086091217423503253755146');
    T('1602471.60609897', '4948980398.148665647375032297236242244605323466522685367809', '7930600567173612.25671087112877473741757520842649668372026733910210605673');
    T('370646280676040583641049478094.841', '1176.901804728', '4.36214276643352994796521564113760876046208248e+32');
    T('5547404728207', '-411636889958330609055.5065082479', '-2.2835164296592677798830108543636613032785153e+33');
    T('-0.0000000000000000717041779275895653254585995816746449', '0.00321217261726873009981380480107282271306898444464862589', '-2.30326196882768081444918769519152717431393087666881910579487955526028795479141279838696461e-19');
    T('0', '-399327.602', '0');
    T('157.8', '584.2802770', '92199.4277106');
    T('-10542363099197242246550684296314627705', '-4850153229755188101.33556814417023579013954', '5.11320764348234189624759367689059634200461502178300975633252267426243050999557e+55');
    T('-2562650836927093177981.565429254128045484667799300595712', '-0.000000000000000000317395222174952988716141595565429848789500451120', '813.37313174330395999646102020198262859585476827525658527707087140151929076326008633676971110873759744');
    T('-0.0021383531474526630012273967098296654028460337299367', '-1407391260514289948513', '3009499531618102701.7588489539730050863932112182078160238774067897491271');
    T('85399454218074127051769295076.287333823347313330158', '-0.4092038950326248225015994759', '-3.49457892996962542239070012424224836131258038173055372705839875319563364641922e+28');
    T('33.127135132152', '204.48590', '6774.0320419197206568');
    T('-20073920159741041234.22437514622641538676580', '71857.713649597096', '-1.4424660066635461364336974246302806972842556483481805121168e+24');
    T('-0.000007522084816187962395438426656921829236', '256085.25', '-1.926294970674698397026448350044490870358369');
    T('5220.8153048375064912183804758', '-0.0000848053870645192181', '-0.44275326271911063141541592413054755924692197198');
    T('218437.2', '-0.00000000000001820193740822812', '-3.975980242028607494064e-9');
    T('0.157577570127431677', '101.0319296822', '15.9203659846066164839488230494');
    T('-14.33490', '290.67243363958433117', '-4166.760268980077428888833');
    T('0.00000778430585574695128213792486514057213166437662675439', '-0.0000000000000658092384657839808153501892941795', '-5.12279240351449754074675940343526036050666862079292855468757563270534826950003073005e-19');
    T('45215297824632433459231894077144.81', '77667936.103345159', '3.51177886233727320835487431074370227708584865547479e+39');
    T('14342668379445830286426805277231689892104589', '-0.00000000153230966', '-2.197740930800139119461236060924109647979621945502974e+34');
    T('1087327540724260701412332282353.246979912226498912687', '-31181.1155292590461395304941342272532923707', '-3.39040856654682932656823122420611037707430356255272533055260947181604908300590629044625370709e+34');
    T('29098578027968222529887', '-0.0038633633262596785860098746949622820633214200572090', '-112418379199558110812.573170785518748243461139468530838004471322252305383');
    T('45167443.85086931970589523202133', '-0.13322343827726157227081356406399769062787658346986566850596', '-6017362.1680079665574862292748307786959075342072628967876653391403467312455019622919521268');
    T('-1277104346263109522212350488222850419104.598041084894694', '-0.000000000000872545304590848146374055', '1.11433140080444089775987766493651597528395567239169697675262925481314760876417e+27');
    T('347.048067026229351381168979388696389522228278049448558', '-580372453576496014579764354612', '-2.01417138168992971509920131695177453316685553118682774156732799236522441451364049496e+32');
    T('85.9498795419121819013954981', '0.086819059343222766234152013147244', '7.4620876924921221071832372576722493425329853011417540222364');
    T('0.000000000955538852', '2796816770377393398221585073517643123820923752.2574913', '2.6724670860207620944890322427693843122815393358116556452019876e+36');
    T('13.3499409389365943266698006822510800901', '-142605023.688711727210398330', '-1903768643.839955511708245141067882976861272713746574494353289533');
    T('0.000000000000000000780', '-722296330274145516124092200004225017552775396318.66', '-5.633911376138335025767919160032955136911648091285548e+29');
    T('0.00000000032533771679445565923566197211480872204653266', '-33902055423889399559039392315', '-11029617306247268880.3792855595203258365194772546962226666267013992005079');
    T('0.0000000000000000477109133480553184558657389005693925237508746393136844750692', '9544079599812049753877281093753.806913927594670', '455356754773575.186639624987152382218896113143126632346387917730524427522867133635682709085290515537801164');
    T('-0.000000000005212381313104274295521085956757682135609555632962511189216', '-0.20258211424784772185707', '1.05593522667463662312577979622174586506157166623770153687938400565136484167735712e-12');
    T('5.939336816620258503935', '-181.5', '-1077.9896322165769184642025');
    T('0.00000000000000028', '0.0000000807854522591970390113967313771890503193275103759', '2.2619926632575170923191084785612934089411702905252e-23');
    T('-1420735136825498697880142035376838692614.60263288147781831', '4794758649393115914238372958725703', '-6.81208208579077187760278480672518379981721734276502252436200522274670249079192835816102193e+72');
    T('-14302450490637670545279313.292191928068', '-0.00000000000000758231718292500972333975206250950391475327599176587054817182', '108445716113.09624528335189894213613395592525495466249866985446295108569636686802306848015834464376');
    T('-0.000000000008450771622', '-69748785787966613339823993495254469.001291622669751588', '5.89431059605905165095631246704409058304793926203868597659835736e+23');
    T('-1179004888.823228', '49931113655424934777966552716734550837488773547523258643790', '-5.886902710413423665263191856093556409577570847449923030469713801232995412e+67');
    T('-739484608100691619531927074065663059218837785449156', '27.88287', '-2.061895319467253133749818345565325454400115552276670835772e+52');
    T('366.123540796397283114420', '0.000183575228961067940921266500079', '0.06721121282973553030230705091816031104204619829603918');
    T('612.24659918919924258642657076118376830990940740', '412296990330.330273291603849583', '252427430185686.8746606867196534961374184185494504035865409741651638262671142');
    T('-1253.044774927718837481270804718997', '0', '0');
    T('89.955', '3.072147874', '276.35506200567');
    T('137440172231079014714878951462.97980416140395', '238.92817663651290090629461162158684942088308705117640', '3.283832974778000222556804923252233207004641698923980593985160071015425606241073037967932310678e+31');
    T('0.00000000000013007478162945817837283572658276879385007', '-9605773255988262156131.54662615327683681096194', '-1249468858.6547626741062732720588036874502171676524751175204550553355667396106328363358');
    T('-959.0561817087475466288631232777115', '6.5232691288079290675200146125939736359903603475043077091979', '-6256.18158293308052505705738568867991673577610410424533837553637598105441295850976942461260585');
    T('1232651308.483980691765841289013994011162', '0', '0');
    T('0.244059666606121846715993202008963667291853198185038924811401', '-91.8912', '-22.4269356360364638409486745244460821438491406050610488476294115712');
    T('0.000000000000009298467342175115268976111043399158', '298.30', '2.7737328081708368847355739242459688314e-12');
    T('222487581688568714558163241.2498688', '622765319764779384998.16290716', '1.38557549953973970068746587697772147617465686740636673376580608e+47');
    T('-0.0000000000000001094619824042797469992', '819334825', '-8.968601419736362575863380714e-8');
    T('-0.000000000003213357903869884', '502881.861925654510', '-0.00000161593940573160560373542857777684');
    T('-0.0000000000000225850887358266958', '-9657.24', '2.18109622343174999747592e-10');
    T('0.0040522596025230943461061874749446981', '-0.0000000000000035111456723673138306010083', '-1.422807376670785399057088730766337512497448065110252859909423e-17');
    T('50.4', '-0.000000000000000012807615227380978390330730165878274412863', '-6.455038074600013108726688003602650304082952e-16');
    T('34509655900.4271549037478532640245880287700031396795737736', '64.71924', '2233438702537.161140732834214879190678535092737997675858151324064');
    T('-0.00000110516283770184738962025591', '-12341997806576.504800', '13639917.318826066245556761603362081169343368');
    T('1443495892579134888970475033389', '-263878898.64', '-3.8090810632514586354552763528830654669096e+38');
    T('-0.00000000000000000069532890943744308434473313878', '-57497447967704543918096254112146', '39979637790820.12873785593753087723013293250902050457270162188');
    T('-0.0000000000000000007659553263900774084490506', '-46179282173901700884047955896435818818778979617487', '3.53712671499703607070284553536887181481970539221145787819001524983163078422e+31');
    T('-1', '-80.5351111304083830696255443', '80.5351111304083830696255443');
    T('0.00000444632', '7', '0.00003112424');
    T('1748652238406104265.08687786280471813580897620802429129', '0.000000000000000000175013', '0.30603687420016752574564975540304213510233635309495529153677');
    T('605.35473313', '-8105969267.633939755450293', '-4906986862768.52514719110958199530709');
    T('3531.27893', '303826595361824791936490465665622559869413', '1.07289645457484761411696267955090137099952167836809e+45');
    T('0.0000000000000000000139500802384964877256638688566332365116099', '-669823.809722799400662636451451747822858695293904', '-9.3440958912884554771068695881482229864014701239462146074951636707559395049094067886960496e-15');
    T('-14328.20453041484587995049563830419841249274151406721890138', '0.0000000001737045483', '-0.000002488874295905724415190916871212750963235628741729704355101435146654');
    T('435835890288235470264209317728368193', '2502287905711035099019387753673794537858483', '1.090586877143053196441416655157728683500541851046587666747641275079364352431219e+78');
    T('1481352883141719129158247138.8038050', '-606388568.443511765388700681359582935123762319163277946633', '-8.98275454167975836154301999007742562427000217610359536587169076287724303365227616247338565e+35');
    T('-2254195545465844946364682.85626170910', '-68792607248889229037631606.018565330920642673825', '1.550719888214274947292592996004771619292172071432516539437011341424210097883343075e+50');
    T('-26784210511779136785823800676221849936631.56183', '-0.00000000000005019147414519109521634075017431467167600186829521963593473', '1.3443390094013180964383583232553726446281441447994273009124279348757959259512742782394910442001518393559e+27');
    T('-8770530121852166665068897500281', '11987190432239629.9682', '-1.051340147623357682201798135592086804701933955210642e+47');
    T('-392092775092295510505846799423331218731967579086912', '-0.000000001347740911042761337967635461776381177269782335301', '5.28439473916174872080749764195178381030762509320641795527675022371094325058097973324110528604680512e+41');
    T('4015679.55', '4.713361052', '18927347.5882828866');
    T('-908765.598832994503098008148905108990', '-393227867096205311879272472100531195041.383622646628607', '3.5735195811950419553683668422021541455075148867700124530307768773407398811212098138687693e+44');
    T('-2369253560877872972694', '-11.60552475086080768', '2.749643084183325817302731177345942548992e+22');
    T('174098.34305585608863845094930842', '1.38', '240255.7134170814023210623100456196');
    T('116951064421932980', '4525883193151806788', '5.2930685688844070019747986244506824e+35');
    T('600225026818135855', '-127962986020756918725', '-7.6806586716037565057838021298243384875e+37');
    T('-355276.30', '457734732040.627839182124360081830', '-162622301980885708.381620168789740259629');
    T('-0.000000000023259793972698088534519974595546178', '-2551236.5', '0.000059341235365627366949498869167230146749097');
    T('-138631', '2.3', '-318851.3');
    T('795255541856527997999067123124137485004290563483625370482792', '-64991504618917159513144692611330263343972554177.85101068', '-5.168485422178800786099741762775612989901343114104453511664262171013611241941946296162984705040765106162199674821856e+106');
    T('96045012606945538626605174.6240481976236369294325652245732', '-0.000000000000000000038130457744062248428043049303932284765937539238468630', '-3662240.294737062792567245617774026857299030801472930205579945585215779769210281070679229934569639844413338716');
    T('421989371626234493675627719459467707.14836401276576921755856', '3', '1.26596811487870348102688315837840312144509203829730765267568e+36');
    T('0.00003674095297032643311401261648', '-25144265134553986531', '-923824262782066.66182891576601261318521398863088');
    T('-383466.04881547', '53724954971092', '-20601696205553692514.69239324');
    T('-0.000000000000000014783370871610989705993827634590792', '-5.75544555955339866871', '8.508488623824452763835260497721954711915248063842451832e-17');
    T('0.000000221838708829447458147931597976839', '29539052824125603227.9202610', '6552905338548.867330870922184373002548907167329945216834979');
    T('1417021083070041108879006664525950600252.582747034547', '20386.077908379675293435494662791207239424304698951', '2.8887502197282405761889040724952549395790613139212743588512735905545957366555623236526443052831660197e+43');
    T('442.735', '0.00000000000000878277865798641273232492264611347738525943901036', '3.8884435091436144410458746277270504101628377302517346e-12');
    T('0.00000000000892', '16797743856811194', '149835.87520275585048');
    T('-28.32380770960', '3481300309.0', '-98603680531.4870622664');
    T('-0.0000000000002514438408283789730670345516227699', '0.001175682622527705754776427124', '-2.956181542035476048733420921784296951833346097731013663707676e-16');
    T('-0.0000000000000125727922878', '-13.313', '1.673815837274814e-13');
    T('-0.00000000000000311161', '995915309552512177', '-3098.90003635669241507497');
    T('0.0000132726799331352407876197984124', '-0.00000000000000000145179351917753148242751859389117949850796347504360670810576', '-1.9269190709043414470286356436843451767202221286209940752290325354825996720087060259295424e-23');
    T('-1305365.7803110685680577657011785720', '-1.13', '1475063.33175150748190527524233178636');
    T('8499682132744325149884.2', '12753066384420249097484638996.8248053537637250207', '1.0839701048535906248094606671098895649828222408103379536302544124760294e+50');
    T('-27597428686882882379490857905609.4308', '0.001777076303502550583927', '-4.90427365570610811144061901744727200974205360973380987516e+28');
    T('3851.5801', '2.4681503', '9506.27857928903');
    T('-254136480693014397618955753399722664599889.09', '-23582875375875972784153503.3854654728889123761140614', '5.993268952647068812676163151455910299034928531722912670375198720068520525866107064371629450126e+66');
    T('-36756.5', '278541826958821478.87226349825573265453570107573513272911903', '-1.0238222662611921688168353273636837316441496590258406157863626195e+22');
    T('434677757893257627333239169971.36582235872933', '-0.000000000000068725189442692668129', '-29873311257739028.68226613696221684789246137143439950127182852357');
    T('13480614688014170819.34130485033', '-74790845792983147611.766920195511401471625734274890', '-1.0082265743258914745957730201044196850059871310317319787175533254133776825272137e+39');
    T('43288920440971609207698898895824622861', '-8750.436', '-3.78796927827813844188979922058384029569317396e+41');
    T('-0.00000000000016299662731892671518950597', '0.00000000189502990635948720606833476337904040553896306692718740072', '-3.088834834050979272599008422371925718929124189963816260765249621332298025452222984e-22');
    T('0.00000000000000014', '2825.871550945769438271943129439745088808390801', '3.9562201713240772135807203812156431243317471214e-13');
    T('-0.00000000000508', '0.000000000000002145872435', '-1.09010319698e-26');
    T('6668343.896256', '-30256115.746220409', '-201758184760723.915056805888704');
    T('1910671461073245653125406909', '-41009469551.2913732728', '-7.83556231054046679894479520055900512189070617752e+37');
    T('8289.8635', '-66806493292579558025822119188753113864024114483099524877158', '-5.53816710309150098924394843355494049132717469773268118146494087933e+62');
    T('-0.0000000000000005326', '2424634.43200073035390412054', '-1.291360298483588986489334599604e-9');
    T('424284.1840077187212673385', '970.3396784215570868735428784067', '411699778.66940253812593312501264900866190088462962956795');
    T('-35760922777.0406357', '-7761344319.06347958972953830', '277552834840052130228.57982929972823169949731');
    T('-0.0000561650355483525921131526685343539', '-111333300972076302345', '6253038806812103.7204293271893852389242141697156298955');
    T('13512458606466223813008490671514544370375', '764.975563481753223231576796031842139048653', '1.0336700636505365489288540708376614928455337024474216176633151377504345359376854875e+43');
    T('0', '-1183974879.82128974148434577518', '0');
    T('11143820497441188022611097072500689220.103841042188', '14333893036294350850719062076858.50886743820472767247', '1.5973433102598649386055415009433149402160776376532075449909743742363111723311690413638261800831616436e+68');
    T('-23955066895875385312189828216196343.2', '-0.000006008550114741720774296140761236324588', '1.439352199458576433136766578653842412823876234519218069316485509338466016e+29');
    T('-2668354.95894041993791850076178801129928639334916993835', '2120902450621765046861513300898', '-5.6593205715454758964489377686065817529188126202588690397558408061055411762596596383e+36');
    T('-357473707639070742000106223385951624969553570180519146672', '-2880014494.9', '1.0295294595461685945268041406912380369425230533019395520223390959728e+66');
    T('0.1576', '-17946110296096494652', '-2828306982664807557.1552');
    T('-0.0000018223152394757689929568141403865013237549366458944677798', '-5052597332068.33289300934043046685446478', '9207425.117162735564750314224408158434255360168962984445546645230422805472786347453701483895444');
    T('-0.0000000000018113502438791982724283161334170828780578698749690297210', '467569918734591161565.975984', '-846932886.330478617799083574720382758183324318393500300146312171222449646868220464');
    T('-43456291089.3917040495022986696', '0.00000000000000000160606215298685200471957781912132661', '-6.9793504427851792555934505781676792541584728405006755687190078056e-8');
    T('-850368', '-16365313992958404661804115212963911454627853490846168779', '1.3916539329564052655449041845417695455848978517303874852260672e+61');
    T('-573001586626626136559291430.708491137026124496587', '0.00000000000000659091710510594985802988231762972361602034', '-3776605958550.27888864268809093797447339962539247097589384819969254713146626305667085257958');
    T('944831849965628473424387135285.11628879031122854553239231', '-9167656497046734408050.66645416827001933707275561667810469', '-8.6618938479540792582928343057162520481532362870957700270661322678213334143541246056098522215623568551067323309339e+51');
    T('-0.00000026160509100', '24622004042950607868289417294478649240.52229821030', '-6.4412416082584616798891690256590608321239167108346686373e+30');
    T('-0.000004846613578004694945875951019296774584875442', '1', '-0.000004846613578004694945875951019296774584875442');
    T('0.01331120519980531178226823546536111232129742873981595748', '-566030091005684186432778.7962173603', '-7.534542690641137182401329425400191730488017551596028318788787538488664119896612542640044e+21');
    T('29160798123715526401', '81.21430510259265355460162080077758', '2.36827395585454415364839027902703656652482945981888958e+21');
    T('-0.000000000000000016948492474809672735628387832748072035504038167841614', '1562956864069228066615011300882107599329713429.314843972', '-2.6489762649129436461814187882951473845942013738702479876336587925692515948461245980490938479637262418650808e+28');
    T('12.90597368208644830150566402904732366667482473', '604431199603296.47474454963005587100955', '7800773154712085.1940792711683581731610862958146209226570359806010190800492344061715');
    T('-0.0000000207428179', '-197640319459879.188', '4099617.1562541003526838652');
    T('-1', '60210209731827764276966194255', '-6.0210209731827764276966194255e+28');
    T('4583913614531584761660.71', '-0.00004564661231066039596029736975879852374375394905', '-209240127628081229.8988189542842449222791835905813694075712860987268255');
    T('-79843798348570415955954652124494715927', '56861144183144013650375039269786414203977063811583167481', '-4.540009730027938310459807409573958130149645615816392783432439536138537446203669899681959169887e+93');
    T('-0.00000000000000000011314', '-3.526', '3.9893164e-19');
    T('132407155319180608772091166836747467896048163329803.57610', '-723665204004.7159777491682569458925', '-9.581845106573894955821546492296266642173629363834000697071816757006018496183651070616925e+61');
    T('-322521422170779513210597092315316261621', '41262058870589483714064.04798992976852435145735153', '-1.330789790863694859369204982948722773695665386328207265159910537452461498636765724463013e+61');
    T('45.38814', '269533555865235093537499029287212271314833820844669369384370', '1.22336267683091115583931011911520907801556615372327715913294993718e+61');
    T('1001606998247.1329297768570186489508291933755', '5.20052838227', '5208885622264.472940958083743279523476777800178015652385');
    T('-208725364670066089848651768887053413406981733447545233.37431', '46428363895460548499939303066133160314818660457470.1898', '-9.690777185114533186791052743948505833183422796131294760780293146823565795246823794373752025269078880430890144038e+102');
    T('-0.0000000000030479119204492183257505452809182072468706814247166', '0.1831953518167469517279635239571573090896007407998', '-5.5836329657315139902372580139052711078742199613978215448274609146206088053118483963543265377233668e-13');
    T('28.71', '0.0000000000061362523', '1.76171803533e-10');
    T('-76698670010634912042.111088324461002234771829964608794', '-204.3415360766065', '1.5672724045005890926079579860206010656480530112197034797251387577561e+22');
    T('-1524.1774171342348399240363', '-287256761224.40001067164619002', '437830268377351.631000336578138459542103286567115177726');
    T('-46386057531584301786849973746261104490857090', '-4.80529036', '2.228984750949274409036809536091615714528682827146524e+44');
    T('-1333480998557541026668203845446224930066438742734237449871', '0.000000363031301806973352170691602189509034079482081910252260722435', '-4.84095342841206873734133792646560873902386616947445713637359576061752353209536356871478780155826152779923290557555885e+50');
    T('0.0000000000000011328263767573913302830489935960640008976331311323634607', '86336988667731117573.758284472483734537177637', '97804.8180526097967631959070730320562045880918766169966194605514255032840380206192312923918439683659');
    T('0.00000000023383059155254587815392387016693739292933749', '-739769226366265.5531389494840049176644417', '-172980.675813593093567219554957028220425661619804809222561967458157553863975311729333');
    T('-6750356340240.984376193207629621761115', '6785896266076286.1666119258989601680226719364211', '-4.58072178839256802270353210343421354282744424281215396734873712247233250402922455265e+28');
    T('0.038352390', '4364267397803.554078375378060505', '167380085304.84704939994306577393135695');
    T('-3677.765452', '-153097604617851523106898348175.2705689839321002774', '5.630570810474899941481304477948773393614882215140213363848e+32');
    T('3564276717.02076515', '-3724708.5652442', '-13275892016787721.61135498059963');
    T('163961034566390719', '13906850976432268007907879396507766911641292643', '2.280181673656455617109020414398350949017013169011794072158180317e+63');
    T('-0.000000000000000000097053790888310241217758521607840846169737665', '-174167724848769605456951958316132823954.290613019997555', '16903637946965240719.160592454311893126986143375067836000624105979381554916207439134564513291409075');
    T('18174121469196263476021234179885', '598847655451717090028982590433609440', '1.08835300317228983812760587141239606682288560521096139829987941144e+67');
    T('2862482160141173353.377689153266444043', '-2.5521116576031457307341661427802694156525', '-7305374090577323175.0048432033414644577500405016939717138581879110681995830575');
    T('-0.00000000000000828251723257466281232072431185606927126573858797644180340', '59246603229200010807575028.948615845949794986267082749', '-490711012217.3627547204685981714157886628710287556950766147835640216213833020293343764393555822441764905895466');
    T('-0.0219725', '-42388.442458578279694893', '931.3800519211112505960364425');
    T('295211627171624947864455852710547075994077285904641205668', '-32114221914552039416309', '-9.480491706745564194049269607588763971795849392568309012222499652763032742439412e+78');
    T('18076895076744235516275796550556474017044744513472', '1110616783295453.907507694897679', '2.0076503062103110248911265925095057715921072859968017387492670202835863677031488e+64');
    T('-30509248597412319207476984175234018573.80700', '56489216853846845634764972404741.4102289', '-1.7234435600671472183595024375663260504322309432173684665884657236439010994144223e+69');
    T('0', '-37.8349097', '0');
    T('-2851475309', '21590640', '-61565176865507760');
    T('-82809184867575581.300036713702885747495702565', '1983849666549698977150.0321478', '-1.64280973786792195412167897641267648031706071732558941631564732096919107e+38');
    T('-0.000000000000015392923450383', '-100527447118222995497036068167.83978088878', '1547411298153231.68196185030647190431319404613997140274');
    T('-90815267.41287893625890527712', '-1377.468328268', '125095154584.42972566162438210224966962816');
    T('-61531326072626014632609689592827828109737644', '6514.9664391', '-4.008745243164772945370376441467418441994843425659034804e+47');
    T('-0.000000000000000127087490497875', '0.000000000001476615944219678865852759023586345893215179308071704', '-1.87659414780029158895646469218881896708577129747276999389159629e-28');
    T('-500.0464508771550', '3031251990944702206548861174233303005657140.843654', '-1.51576679978620832480902504570356096303779609394637710501532437e+45');
    T('-155.3658', '-1.487280412', '231.0725110347096');
    T('-7246163852901276.04365667671658743999435118996620258393', '5112736623675367552557768126133416.065405138439108', '-3.704772731188096277860254002053708999588540456247342592474290019026821786006110036086254157751656433444e+49');
    T('0.000000000000006689933708640329486606383032', '729332114805.1424421852307098335222592037429719271268', '0.0048791834996288611343551405747438154907187127049172382481758395023666868320324576');
    T('-1.8', '216561.426678096257755924379012116313', '-389810.5680205732639606638822218093634');
    T('-8058045.0444', '1329279770290237732458883752.79771', '-1.0711396265608420509738201250987261701168324e+34');
    T('-0.122934172485398496827140448263042340165490502305', '912702090990315108628442662833971663.8', '-1.12202276281587270916014575371637467822687977597732727219667936221931017460398585059e+35');
    T('0.00000000000000175417191262247437274343236218710277615977753', '159777383.0958810142116283', '2.80276997699115404345306815091460487951017642480659328034789667052099e-7');
    T('1.832596787409', '0.04233218045723559484149346857663058272000354', '0.07757781790994800381556406308518949782645811636510742786');
    T('7764032078986972842.005528691471157135', '3814413634570635467562869035571042157068430937090750616', '2.961522982133170619249946192718193418202399599536127455799771152758136779037896695123404516e+73');
    T('-17135339502484788763', '-115136630978196546781', '1.972905260983705133684367626946832621903e+39');
    T('2732768992944344069188.78233921094751884724609431', '547802187776316166043551795761072525805362767.4739838', '1.497016833022191997667345517507111060165004561416898656598340429974721721725596504177233879086212178e+66');
    T('0.00000000000137207147854597410975017122036947235', '-31922289389067969062352250596.5480447', '-43799662800630948.884223648169873969145520154519727429336909041963214045');
    T('794.15', '17485441159196003764239999', '1.388606309657550638937119520585e+28');
    T('1.7375578177138444239721', '5', '8.6877890885692221198605');
    T('67346906173389358', '-466873.6162827458603696333231123965906193638807697765', '-3.1442493630625071474606471872766565213027787746877671241569093138487e+22');
    T('0.00000000000000008330954900095391223717198750270140816415917', '-1255116.84123905597608550718171171454784329986782439', '-1.045632179871276258673769748937031166781342825771332297107555550761723897353461461042815681563e-10');
    T('-149004811516278801454193569023908186952042538093822927716', '-397664736597845838069915', '5.925395912343267570007772381296883214350181601356111567003076787081507599926414e+79');
    T('1000073564757252670366408149537245435047377806404.1015', '143493737303.17', '1.43504293385121986151561356719338126856345712035100585929836951755e+59');
    T('-120791171186.75073588795', '-3356641846898638185.78959337380788876290302345', '4.054526999413445597874488228850145076904199735090551400294754224275e+29');
    T('-0.000000000000000021645765186475073728477012180542023658755317897440133896819', '-2892.41876465002535699255875339650679491474379', '6.260861740056875851324591106893702672467555630128663303516124593419559504118801178122464786716968100401e-14');
    T('303590.733684425609632655982112479958446', '-1079042632393906270486', '-3.27587344445239960885966209642701728797406978059884116224756e+26');
    T('5560006241690.3561204958103356609', '-26134.5', '-145307983123456612.03109775521732979105');
    T('-21241252966066639793327', '-9918174602168819276153472753.0892247103917800902408030', '2.10674455686285247587982556750283161206049081499338374032384978521582521581e+50');
    T('0.00000000000000000011710898531900697150827118078795784040', '1416082645912.362', '1.658360017906513490504921316067138338281826491830248e-7');
    T('171974954737627841.3571', '12776560683821406610094.4', '2.19724844530274182316145798323728537865511024e+39');
    T('-0.00000000000000068754763933835169744516274824757850275393656608356918004', '-6.09469365736868', '4.1903922366142608309254800108912871683678914634852117466941692915771472e-15');
    T('0.000000000000000001400696', '8637225390591.816150963722258184', '0.000012098127055700394515390281912149296064');
    T('-360824784680774106563254315862091.5', '19099425092005944.36343728914640', '-6.8915459463496190545354254880571561783649870472046644721536956e+48');
    T('-61.150780875663855271841725817415551', '-0.0000023333939193095575001578508180794664583584954721238120', '0.000142688860256305217839982589618557627868898235253332040049384167607214599532790926200412');
    T('-29783331896.867208404770028328881856', '0.00000000160', '-47.6533310349875334476320453262109696');

    T('-838472500998941781878534497598346150189438395681961909493802795126225423951505690327678802846577883568622319410118', '-2884829948773734005744162960155700874127.0681001892763437635520740604769472972181496111013', '2.4188505821049618555759179210300843443018778137981932674088381260022683344838428233063800820435344194302980110031387348601685636929132993133036482870813353080292469079495502993056630049417824321203429534e+153');
    T('796691.919974655750', '-344177691021', '-274203585471964324.87434102075');
    T('-0.000000000000000000037241136189493487515236242635317406', '-236633306915237035867656873537286323242534.531', '8.812493209800553514615822924219854143174591731693607256359134469397049100346586e+21');
    T('-36918999197803067902650019640975752121441727061986591604616945161242737830954924822209930.0610216157567', '-630816248640.220238311747288806', '2.32891045775094316018876017621573827476363455570577127733350185252461212627985116895575049148402627634872854943933909453127151295002e+100');
    T('-356285686518395271578252895087932787716516776378851836556183.490949109645090654856023328687155015449097603555460351788748359722414863145', '536192552176752561042209607723742909268910764247931780563.2', '-1.91037731558344763167084704445859558938320679866577929319697485737868113003820206731226346686676150919266490086231386325706954806002421869189844369048659180671649946432503759091893660299023264e+116');
    T('-10868240043.323', '-0.0000006987483137538548533133640114148563911523216092560534998', '7594.1644037440686677326890935142678911031312404730399664663577718354');
    T('-0.00000000000011591017649385438295796980510866337031921451760232710693439920068628049494341909991139678975519329366780780539554769715433124600', '26133984739171981586185319', '-3029194783605.121387520277919164440375428744596566999709645269433197968011145816158998774967743687046263521357854521385482216635698201872145379668177474');
    T('-1711273540905209744011506141193.37033113722759550410761924564724', '0.0000000001293732763469758906747311439702612890496046217356893762894231050676460791112722303394750148856', '-221393064712797651093.576041646381279748254325855686348423517448454794870494445248164160406818767744894597164595179089851596941716698075867505673842006555744');
    T('-63062954745.8598353024049107700099585768452939988302739544094597635', '-0.0000000000000000007066107653369429290153271704760473112899492658449746935736601687393998875372553088763481649809909245944916440347928986666226', '4.45609627173810154902373805273164378070520471666107189671611539018934456392187448488034184668558120645401564953529878995106460890572197110823797727327567501341707822274253599872751551397551e-8');
    T('-0.05396306543212365254900360568584', '0.000000135925517648212', '-7.33495760274574245053942000380666682810971808e-9');
    T('-51311181621759783527978578699650628367670018837603370537970304306.5', '-0.0000000000000171073617238152543', '8.7779894447982604608252727389859997980275463423154981803549625152925376395768264295e+50');
    T('780360810680597937530828803485426316757997822572046380524663475663587783713055764905934635773988266249773631591980851269802869685048538490187809566', '0.0000000000021114006241457087', '1.6476543027298657092509209956166007749872751971298560901265194443520620935869459922698982198083609063920515096925628739206594316734184930365483909751507976717094242e+135');
    T('-0.0000000000000001558591643933212408712480642149933587830724439341932663613727360989832586450936995132509861377299507330923270242750447693180038078839868789871', '-899234589140276920.9563731186', '140.15395165697510406375504229464266777072446771644043491265354600675571562268623460258428521212930915552512830838365872392420849552201444571287189837930690619037363617006');
    T('-192128620208427347208760897481755790502927310252099946847941391701541372730741701901004842683652084499599551669587901.095113423628696460069833', '-150027.013347965686304316841127', '2.8824483068535959518771144524961420793873335181555629802553828843970441540984506755823649963472492988719283593979140183046911245632653583841810467259116227616668386421791e+121');
    T('-0.00000000000088119558575179620805745334627526', '-2342970366196339369130467230746566743437618438527.293007742982263818470063380858096529305084867946540343494845177603781376', '2.06461514423948373213684382167619940227586580537675167441830145669955691286212463457073538034124876268856699464885544965251476720909351479389090095755776e+36');
    T('-6635456782135376051461227670659894416124826680462504047183309508524677837974389566804395212269550349799505694436932101464692080338', '-36033.774951979165187136955049120300', '2.391005563910499861359276356470099138701070047532575485529233046218042255556441673237652214828582412128576389116490428262479007258867518065861096006448051838266614e+134');
    T('1.0795693', '-0.000000000000000006209261744497244037804821960982585015091967690457481640260325487223225820327780029749670765451353356', '-6.7033283550236685978221251810425966169333249952098001341386914040137368425931872572708312434887817265895708e-18');
    T('0.0000000003205206100151839365357713821428922286825107015046701389076172910755564034571464044704259976070021361285911146439621197151315883353504731', '181280954003418224438635307210393590651533286700798186230089972712042801144671899167602413575288941132381001', '5.81042819613101098829202896183160808144566548341644020145672547798396356491584355574818346795299101366223635188614907521125965341055497357077467758341149862217405975928504053356664898994511933823140023871980627595465353142713441016064148015731e+97');
    T('60.273280', '-1948051519028114.87884169', '-117415454660806895.9645912570432');
    T('-83193336723730904831044', '-8597513002342', '7.15255794190492657393641372686305048e+35');
    T('-20357731434704594485933.435192883517106779904094737872189392050585959795325610691798979690389882855327158774541534046886050', '57101254487124.26556892385946827693467498483828207557125700861375680904187175758285473565759248405589101', '-1.1624520034335964384881547289755586531335208559562766632031511288008463494925147406785220580646246607391536758053170339436847553410796246157934498139151632371860559137134623242512914876401966834601783673486087092780486894105e+36');
    T('0.000000000000196393242447331955075189676455271786947264076645295021258862881929479958110333580', '194877.520544633956108976283205922142563827316236038257841914758325718909245819798140', '3.82726281398572106089641076236903647054748740721743415697957940132522454065934785001420361718935697399839562856732355534966588993484025198806123215220764836635412e-8');
    T('-8071576425880681257819461150', '-1591541556785189268475083517665125202173160434133152.98399538151538621882421945398094', '1.2846249310556773308688003659431424152963795381736069812397375172279784904016650744805487687134414853173170481e+79');
    T('6215707454580399344821610342', '145319540897984402903779835609411326583090144758472486922947576644983828825850438698150473186142966520100265693', '9.03263753655802873031730925036374079283112281131923966584171630907427735951790460941752213245331152538824074995769485027917034562316597006e+137');
    T('-129348079468144673220614626836759706', '-88248178940421789818564716716211678654401184759743634646878788943183256531349288163631708018145656009375447214258101552585320093130', '1.141473246250472885515118898707262713605663944616163164881785239559268827685334536245384449464192711247404249908389352393586709492073897298343118518559610042335141978e+166');
    T('-5780259200186462371596484655187034250137478170873403737601291296553629304246338.1', '20317804349924669254706871559', '-1.174421755212405947511968636545739798982946944457429152629522410545955272538056812944623926565594717327880979e+107');
    T('-774.0', '31209403299230592237921875076234864775333333322171087161573695825372946329.47956111641', '-2.415607815360447839215153130900578533610799999136042146305804056883866045901718030410134e+76');
    T('-35300012822981309972161307966314653.5746532880996436', '0.000000000000000000330318102723213448', '-11660233261792292.2796305229097940998500752778977839907195278155271328');
    T('-372377963884127526301703864441812802765174863559283045963633022003526893443086066813180.3717468998054326701855782319548515', '0.93426382293185456943254764459757361885785459231935724261799663689196168735639052920121741580138452492', '-3.4789926011396505505944781064660804224349193623867972766690000964018527357693140898258100416659583488178405935796093105315794205956790824509036660608118406568210299647359494344226952122917410385314738577518950473221664938e+86');
    T('24266165641723085835767787003697599948414575.4598063181549354935463146230534386950113305', '-114046436224578769506685348541641847469702436631296179876858707928490406027412029206934467.22255852787626', '-2.76746971227383645895497368320257172653365323571255355106207704032170926692669369847993108061766552826817226048614230592101594822309797349385303976310250855456022415694582167365528080196393e+132');
    T('3296856412996342216590213367517526056709903701721644610.791416', '-17873043539632614693589701036988.4471469786937536273599351623416309394', '-5.89248582134006296943775735259576640781981176325731275908604121314963017378308625998703430431944837580972601701118670108255361904e+85');
    T('-579102350347312720630005129054780607559620407558223441199264163920137899902249163147321939579047776302298780448678174736222915', '-219492399337234160290652558813948662413370806048542871624923.1888570368753037439767245955297245131205931820059590', '1.27108564339563247096015910701131062607103942871909341223369812880561545119021551254208157534581993545107836369462180155951136922383213991699434467561508645543330227906067804094605876984754845169252387320636979899325902200224418682350485e+185');
    T('-0.00000000000000006163518675166495062601637166684339458092498600493044751669369089730774084108109728725760785705955545530', '-0.0000000006634126736829635005496725883566808801526308721290044433770358933738076656970776547028344255382880585757916925487', '4.088956403587081499616844261176845350066362599955649570127728925758519680545486693543687506509190342330458809847232254048349532057461695086500962967500458536634636810198879285867211023138454828380781894359544592311e-26');
    T('749330908047468986174543866383750336261268464649133307531895834594094676053587911029106522535833685617906328029183872567352948262609142814490', '1.72', '1.2888491618416466562202154501800505783693817591965092889548608355018428428121712069700632187616339392627988842101962608158470710116877256409228e+141');
    T('-135986987299837104129797979843691621285208421388144053924300522288644.5900287109133895483', '-17962494534979782634275.37015590780316964667993394', '2.442665516201689090665690743015967257236753951326674341795336278365795371226492213646697861453424431171591440002808134392672856130439302e+90');
    T('44006442863122570049153802624466247185058307274072774466983112669894864433785226136933.2', '46790892915789.3411524668861472382045424537291525565291001608139420856967742081828733644952251814', '2.05910075561317027401508721128826736996297356066394448240229549087424917958568533386066515904891204498637800861760830895225068854234088512703986966936540011209421699582958756520968248e+99');
    T('-0.000000000001357086727370149233250058639705046544732320894727648668175942', '-879468576980759082.033452675408474697409162575095118715838878', '1193515.132959700504049250941775088529954670578739886689678357661665327443107825618722158521731867085586347456416627873076');
    T('9809841.727201839210709', '-0.0000000000368880827799595678609037922161591383619613563735115949331671506211385891506096678952335776345631106186087', '-0.0003618662536913229896876574465145932640958294417169072448132935373449094813864973395333355003851497225742989014305327367357205683');
    T('-126.76', '-302985778493402807197323438', '3.840647728182373984033271900088e+28');
    T('124867100493.457541072094721668121610280880363817443143804305', '-2790.963779772728898849783002651075720477860575346862492661675565992697657575735773', '-348499554762481.440673495837344907334116857684623288727299421812123101984255650489865544241755462317555675735472100548275529499295106699902765');
    T('15521419716240482198113978224037109244552806478255554247304501803343108406125114544385881082700492397181091385635182384771169625695908585249481', '-2836586261373793936479454372136.74149007596046739828188227468752645', '-4.402784592410408295066853625044872038760273286404138338015606642746110634158840973424236636715346429517243853338608937452735485971423525672323975187535426255868008698725535902235665305652922137074089203627245e+172');
    T('39568702947499980.31043424352839120626194373', '-0.0000000000000000110532060314654733243303464490568893422715164279635383512851140023129429730151730074105250113850458826687408847800122155909183172465757401122037579', '-0.437361026076572434440085826634462269408809302675686544261100147571961623746441124718245098250484230095790472367852085991196762852617202769222972427292049884929603478563067747014298264342967');
    T('-99609250253802741981.4964874360244285', '883485457775161795418874408210783527590114513274007831727657306342804460473168388.873823683132057229380427284612779592765741821135482015', '-8.80033240591215667544412145489909369089691076369957723858897861506204032139051216834675560840680969094658338799237500038744626460350984691160948888063757133290716624034275e+100');
    T('23.384657', '6358331922737965853097929789343578523627007160605428122392114297855155.13891249819092314840480065973772043562526917541987676891872705', '1.4868741110537783235240747553388183892758395838730184898029361236013863860525612320785833880636058134030234898750019986664922343269294087185e+71');
    T('-14723458729544396106728.8730102546343094999696645194153', '-133727558.268817344562', '1.9689321851736756223818822532522079871040093348444209468925006088388745986e+30');
    T('14302541264229922914', '-0.000000000235627544641501596076737344190020766746331735586147665546911192908467378811964334722559869070841801090200096029602404948591646484821330808', '-3370072680.224254836492035508073157091195119213264445104738613033613662085628770149276109216999634545944893478819818145213075837742045845104662438460733334512');
    T('11859540992913956563027495896462810455142079490183890981402926486193538086518056969511874125054152356620542433.487767032922718042853047303427', '955192395684300504821406379834312349326154.0693', '1.13281433727376500867653857943948863816132096768226862985682668025650778093862402486711549896946612114014654961667306187363301784449098292029152064116984771872264804563492799411078854911e+151');
    T('-89992.89188302466393156671880484242772885323991845613962309150678501746987154469202208826173765453391736170812306681487216203314', '46028644449145217432303817391775774045082825030.2022387362122235067512142165', '-4.14225082343410889148864685916871924839200546263861436771489245494114989348152499951206927264038619116817258198774738485287373362091029303295538404627178066368057815540301560861820242440073822631213481e+51');
    T('322550604700426997899532770743249875139977021368583.850723996627574052487902691354294316078353979975', '5051247930821098558310030929577132446128131203947693097941889018946508950010.817010609850054994957659209938580530674194319', '1.629283074578125979757678549954520448550932971582730260571009370631223791910921098102919850864213539220310377679206053786662498134329234965312607315294965577812311728138336208121595820208987331544983981561498920184762025e+126');
    T('-18162869148539225267245', '-0.0000000004082605569565299430913769521458041940383792216884928840151413981544379047647242539071550738140637320695619458956310444200164926', '7415183074511.198888443043591378591772024538336265966741297786740921169768779262078997101641290939777807031074347273941892988987901012164049542564887');
    T('56.437', '-0.0000000000000000363636129586261117394059679281224058126111740191432401889546', '-2.0522532245459818682368546119594442168463368281183870465440307602e-15');
    T('0.0000000000000098328737846670488651996142598', '-0.0000021680510741625274383109785118138365114445962436956704809668310586255130207174432385040177431879924758023695894509584', '-2.131817257095195181206361651183585087468603124720413551197211179755387449478899738202568963063585962944228052493622001429362279056649894941659232e-20');
    T('15353773892289910580447352912374084465426576602840471898589013750906506890933921327042063374884073.37459230997064', '-0.0000000000010024383418176318716576007775600816833200531168899324061052647625728403071186802669732334255658386493460274446', '-1.5391211641229945537862597203687187815529728355277111549164845611017692299846743962405790219289790424490140365517893874940113367036665712735367218576203409806863531895103340714121294126379877846187972625242851311660226544e+85');
    T('-131317855179200803975486750.21706572131621841705391042457406222193797630804760305734762283213938032', '0.0292170474534535827560241963251081294772380763588549279699135998743535144719442580701100219852823099329042846816782892289228', '-3.836720006256455223034915613925802473646371948151381349060669000949432685656690149745351896865724762974757845038322594373778118540209910046753684013004635293983638022635663512882017379734293615901239976258135149413119296e+24');
    T('-1.2652', '-11354', '14365.0808');
    T('9907551115374943050635613568695786302517118070997561724624950969636860315016878905709.592450615294116872101107020677899332545772518264112371602200', '-1.4', '-1.387057156152492027088985899617410082352396529939658641447493135749160444102363046799342943086141176362094154982894905906556408152556975732024308e+85');
    T('-490.0344807942463855', '-9323932874.185090992679891416847', '4569048604961.6964723167091758356936009232035565185');
    T('3604969916487266.77582902266201875313967241643046258256599229303814897912723083869145048', '-32491432188732331176981674049239559807795.05', '-1.17130635583966083474238734587571010296057134092517034186160396265057194098968738205898514560270240397013328401070407840495064124e+56');
    T('34703234002309873855644196344429559904012545590136.8731266774035', '-30509195306542390332337786607824589011847240852960.400475884124826629604413425289601053748170330700373748814', '-1.058767743945114695217780865659236851886438030887854601194770945013467876376008466686358099101594157300090732314055284541644607734865797363613111496055241101601318724449e+99');
    T('-0.00000000000000000001846850219978014536016505660530611315774081617188936233750581313204111802184283556512413812', '172294.1773686139898820857102416866146212540421600646329719718', '-3.182015393741558008777043196173134950988956232467393142872076553361750999454632625636035727486190076054675229759462180914335313087408443832697591945016e-15');
    T('-18106034022632087299566240966', '0.1062593952762739525593394732713320570280318748229897368327', '-1.9239362260965274886455362609833980864707868629715502819707822658572629454695338283882e+27');
    T('-15954726647545197343337193.777996734931237024726479085', '0.0000004481748063179037', '-7150506525118665829.3250763667151579960827175193664627204716990941145');
    T('-0.0072925304890', '-1691234031.569314001265549', '12333375.739253610871043600667823461');
    T('-1865227748847755571775855702643769331381101998226093529507611331692677750602855545329939048493285354105512957820154901.7086', '2210049489063501217982642732440647263267341254731067280328753568541239370364.8214774408688801128406378268765465307868425869089870377072', '-4.12224563332804677406698803644377193820506176786228016964994619508823923498100669710299638948960004422089468802904369403398678960200548365227202005570666224092394691081191293375038692545892613850007520900934668836420552876480141825643798919514009790652192e+192');
    T('-29657447.9015389403059670276084073033511112446764971506273354986137667779619286113465', '-1827855316102176003105358531801341705072592351.135', '5.42095238088512761081531495719462889138251775255086295922416345110850703827501143639893274817453208270263341869965571991680731532775e+52');
    T('0.000000002303893648170578350944498774746492391128813731693885869943488294353601573494998681870582486295872268039945356590815', '-32442262.91320156091101969855721550263008139081880143903731313592785661221100831', '-0.07474352345800499923522516975799224318500890706048459253531640566042618663498550717397089326803150428347426693483873444675443808499665437424291063143582928567184402307096634148635840535523467265');
    T('0.0000000000016576004870465706885062', '-55848857027244311015.8188471734270775276780246873885866419886637427519716023962487120351937093495264631807155', '-92575092.6093544619318438795137350300013067044584954352726853911684860351652174681495037636300286854678776361173457113848293421861');
    T('4060428408888.0232603235503282900294503488016711959024243468046984749052603493273497544632749564430853860097672053826937821420346478', '-56342167050275452604675195079699398.2675991078629882729119248786198064047635210295605913955475957472202624', '-2.2877333570925316685876047368022072172371889058683599394540501407358757119526517889443532452252466779232915679501821225464672490791576862382231853032125642473217365895411111636095821515831491602289971848581424815174345498160459900758272e+47');
    T('26299685148174659.21498806517835627517278416660123809400463889', '-0.00000000000000002810938946123709113663641801589824230970112320150509166', '-0.7392680925379544113700127042857131426674666337496775201943962811858815880839349410511049278268042443619259946506574');
    T('-0.0000000000000000000237245065931924834498369898311931358407431388348456381998654995741405648243043023156623847512508812546011581686473004618459451222129595962653', '78470.0567305612051127506377842349815403261', '-1.86166337827238752251588053847936462363465535270736342476553827797069992977676755247798085804488792284146627152984361709483184324719876052483334166262924374381677162633704456690411433e-15');
    T('-183824463031586708', '143807363604069401113874611858643135635193494053567940110697592615174793997761093.2327486120912246439210504605813271646434876', '-2.64353113945062034769011701589673384301679059470040712450349324003153646920125387527703799373682836286840975022033298195495859192205669228208e+97');
    T('4709101207483984726787440699170240831795242716.2138423114488136479566547686742376976336667025624304570806054934', '-1', '-4.7091012074839847267874406991702408317952427162138423114488136479566547686742376976336667025624304570806054934e+45');
    T('0.000000000000000000038532944598313834956548814879372', '-40661.8380161978165598078232608918885279594361853172147', '-1.5668203515437617982746501980121696087743512254235020270033803551407710522231355251684e-15');
    T('2334886001264116563500830341789350499377618860287461405266703471620193083331061.9777697176990366889825738659887530082768575891812891822435971810032332', '26035538.8683211892476845585304290220478694825782227287031175818318794980679029048408253481320254733533048872460665035942196191856378829543', '6.079001523901094420088368729082607832663817841432796296671692743644677805701345873443864752415327061436957752682222783317280683048921810139315200905217552914921575411464462577484189557662106960763012918216551898062340176680217599395447139612485659290222974247963252522982643623146784276e+85');
    T('-7778469807.563', '38672644915681385296338808681298386088589', '-3.00814000855232415447033790891667731035489355100198607e+50');
    T('64622392353741.4865906677596431143150394253242646025467', '0.00003378584792447508795371328648463423391931923728963301558475258018764078318119181', '2183322320.579271598509382338738236518894882788661215479990430711558769726756727680434235068590712469349522851338102909922320467182527');
    T('-0.000000000000000001648136935803060530512720919823086792624816339685214001103485134801966927382343845709538610434741849', '-4391532746732420685914713997682658712351988556515487377264609238454668698925221533684202870806667745235943356', '7.237847324678369711768998633093781574995948295740118328002527697546317476553671589822452609098233955280840336196399777925163783629478472302267347352300512328538053758750290707036775767388047947510115846705244e+90');
    T('10333000414188250420538344710287739407808614536951039.810025625233444425363102180125538936079684897578202747788108257631148570', '9335', '9.645855886644731767572544787053604737189341670243795662658921155420371076455885147190596830385851889252265060199058498677190095e+55');
    T('0', '0.0000000000000601453886227057059980502655211529623918792629968455990334450008543269999122651600055853233978797789838530557724224959611814658608426039511317644', '0');
    T('-2297750624251138979504978190262936680523712405752289172826124262469129120913490453904199762531745620.96952540734690968359393491107', '-40416204690650952371389732084289462889292036515283404683019111928741464.2687913586781776783223', '9.2866359557805037179029429569778710628234868409496948754232191472442648400693401233340833685175058579432758055493241234301333517014914341123314199162326187649292261109846406979086483744843709435080273472996954914317297861e+169');
    T('4343355589964158622184590891340741623549153108779.436816', '-0.0000001064974529896251240308460910120111005761688204576301219728', '-4.625563077594334790148387774508543628581450404563732480957583510623242646260781687362461885461530966385708706048e+41');
    T('-11563484501688268.66686509003783', '1322408781913756518185807148018074515.664891437493116279057', '-1.529165345455618514610777438327506360176848752673257181206491978239020817017600896672631e+52');
    T('-7105422094.2179667', '30559895492351516.966189644412389996', '-2.171409566283465162387924857949138932897137105411332e+26');
    T('0', '111016869919462691384357858914534606927438531477.1293238954660357640541427103317553925', '0');
    T('0.0000000060932574133709382983', '-22.267165855523514466854715520800113116277499916129314878467293624269528017916046898922489352991777889888803407846', '-1.356795734239288861313869942530919648656125995428613119992994317378914675143711278820250703114800246598130872149242193747276361084618e-7');
    T('-44333.76', '-0.000000000000000001470079352177070580940', '6.51741451803737246384545344e-14');
    T('-21357371607823146.894996126592622902999367699791992019397626730636288058416175548036595334380731548047707750374539844136475793453543167632520829674', '-2082610833875897815259749572708491274194096.1328444788624505568347915241817370559885019276541831998071798466253171806140327187679310', '4.4479093493565988402652146155895503067864965364415050875276153305362992271006919883790488712645218749008589188930440013166012155736226914204651235463946650075417869390037652928234175055618130254249241986895815834958749240488411354040161221049340462201305247819550627184384494e+58');
    T('0.00000038779', '904315692695033441415603523306856029010929442362969497588323373295.4261037009085085062076151428035395486146494122744116706', '3.50684582470207018246556890303165699490148328453935941469775920930233288754175310513622251076227784601557274895585894101741974e+59');
    T('-108092399126602892192263936618253.11634898323699426667272696837431678187861415020697', '-10577768091951217923840244460858974390254947969430786022673684947578297621240080038309605361343066868902863031903186141346699486064112972330793516', '1.14337633046383576973976076259460800215089889515619540807214976204561990493150424651385392676061643973011767877937603525233712134586553308518682088934561533581793269433365489470332685181218952765840412804140387512176915573400652e+177');
    T('15467641140816407251201603.17330929847758676216749067445955101305983585263772950', '-577622788567995038.889222735426051145123753952194531865720030753211409854898055689387177412129339425045834175708407053831', '-8.9344620083274171838850431285315863222279965262274085151307500736726521153163765171506606924039712216379344449734092210186563577666902614357166638103925323472931546721201173791263892223252481167145e+42');
    T('-147577569629276477202061028275376955899710718777', '-1836553374816.4194414', '2.710340835498528403441827678365194491127557859039387630435108311678e+59');
    T('19607260477306481515065963386476904146461.13', '0', '0');
    T('-7587887623467943790564171894728147122394166719543547263769028178587424899740120.3214878', '-0.00000016920971191816124290279600506057889818397766687630546391612272642869578133220841440723450090978526958058420544559571', '1.283944278834391917935678304507329917170307310293334436436941584511090251795678415124232910095377726352226968886370226267649132152891311373385442150371798069034937442982381537637461944916510337784497338e+72');
    T('2183744843588421584150515470170983080333529023791.649929295654521467545253432380589261845763800323659', '7388076664655153708968991031349105352802.87524801859750438051677178784807521032697033391834', '1.613367432047663606017519920365670781068592286431464441643858801885153492675086468494328491512664083724900475004088922960826586460789211331922609342243762356185315284210154800101939767600606e+88');
    T('47663056245673578412988857668839696666285127435258253279539956729954000870254229114622792532345', '346546822020292249515761823895055766746157088669680742020667195407870883898961673353876509569868596891010435068343.891429081941502924502622209358', '1.651748066971262047841009039410535405983991643212862547257807586948128858978665397570993212728686939913279771853555026022126342707912524337215453128506654700200787070955669974964782729940854858026583385489299889179192801828417090757668451e+208');
    T('-108127035861913115550264284316138800046955088009916843670136654902573526429629906417162564166515174290526454135619208.14401004096640476727920000', '-41876811.2693259587009484684', '4.52801547390097523332116417273670654479155983631591114406304348746150113439265113473586255636518700022503707400603551613864908028442586791089724406027095241367517728e+123');
    T('-22930937565270017519558999696163059408815.2103786274010528531899481200409337071', '442710909275310619619476456914560821720723777371027183.19798799', '-1.0151776220056066916079907416732180895063328275280083903607063874114903814021738290370272558746844782372813173058269500111226243281691977729e+94');
    T('-0.000000000000935', '-1394991975035345206923314783009363790456653341293996952.89914882995729104423', '1.30431749665804776847329932211375514407697087410988715096070415601006712635505e+42');
    T('-0.00046024', '0.01162786573878994938984477754797863400638858513306671988962769958859110982', '-0.0000053516089276206863071821604186816865151002824216426271620022524586531723835568');
    T('-1627.2108799123697489132363803597735986233989579218110364523089725598273552977977776687575769964049313924', '56699994277601502191648', '-9.22628475794822699354291906781040053919455063547635119292864057974253393511179708715340019643722079742642013165442036762906752e+25');
    T('-27116910291.9182040738629485', '12691061832825245519.40893289319955481488011346305686826840916092434155363686258532264816410801529729986396433852053976574899754971', '-3.44142385229909206506408450914121490994466313457211336682505249135405026892531659087017902656062527076358954643091265672241689615713870521464190780855919935e+29');
    T('74334146952185.622333564428648946767', '476584680993387873045.31749635019901122634977692103894159588456540699130081843563616833608386', '3.542651571212300025591240199136282046613545603127423889427355578233920699125928663269397001117473297183365853355090147038788062e+34');
    T('-0.0000000000157591044652124620704467757472117236708299027185378061', '825889432875054704437419479225672139169234.4648865373257367774758779311867911088245084945960951054201828797', '-1.301527784939306255868774017049829614469141796766685094069536216576279534218241902166490354194411368867404472498297448815923977414878533155578679521444041822617e+31');
    T('0.000000000000001100192990777212594294335234679657995433198981402645', '0.000000000000000000432645284322379079219999', '4.75993309304295726917904095312991723862503538234489037361811165973555497355e-34');
    T('-300700711.27857809815492793761168238841641169113962704371', '2796485968452997110905186933271347618098487118212692028161371341773219361074458463009437202075408782.868217914378353128764067341119788514123', '-8.4090531979437954393871330563049695911136868591602684229475806517303872799072423007746634357788114292441025309971392965563899108585661101482006280251358427683195796604902336825200320040807331633e+107');
    T('1001261567690509940798222741590486780493666562063067481645961.90629710999960001', '-1650177790476279206501558139505.7050853', '-1.652259601460341163039584257033432854399411843740615967044468360193262523967905931854751303094262379472596022930853e+90');
    T('110.8604067291480106069111398751254426097826209058897035561124403844051579732', '3550086474131605383663436798312168506354131157360313848273263892613620358824680555084478737815742184487956353593187968793241400.17721303537436259886645', '3.9356403044587676036027794309018622288005376717971688259462205139902681207884104868717633863448326626441423669459931832858572563749403841913604929877516515276589416960678197046131472363670530588356080270487825651541549947914e+128');
    T('-9565239171980107624419624526395838241183446774838567911610629737292737676405985674082492.7402072097442088866372528167684894637964203298148137737241', '-36054341543178006514284988556899580296546999631717365906312843826084434013452', '3.448684000487559907760299189700848766200218042465011401311363613150401470742277874500718876731897516621371622912032460093110240951501324564382188117403446347500943089873810691365498189390424553234241009759752460955435365932e+164');
    T('0.00000000000000021536749330373908821656161952581400559880285070951784338817932051856533596270829157789717921906316591168026012467390896523070770210560122939454467353', '663477678146178303688345264055398845777282913816.2865250058407981284027739848602730238855', '1.42891524405327413808513101984282436944310120570351565859962360818367363905163907249459291799819814848604018845827474322713798614022002843947155226737103321232324111623370722541558737029258436237486465744476494522921928738155070489600815e+32');
    T('0.00000945', '-18898734150623755402431379573.925485263576945358998697169620788', '-1.785930377233944885529765369735958357408021336425376882529164466e+23');
    T('-118155484782065759745414566117547423380595772557270766076629821949550123865.7556876205552', '-3222725953437374057075335595917494.78154846586409115254934373165610464807636269976395928338097797032693881785669329213286427799731102411887254283256', '3.80782747348138016629045371008871196005073810159724255259507985221047370481336261384421677347963935331112831607680385035083546977933094742953609409763116007720964740775926559725243391158892800768754854303883925126424611683360687837312e+107');
    T('-190628036687751797516.3923598265032797533714657001', '865709203990726346661478248439122009697620464322316832519149040247619305112126151915240.927219690074057652788651697648519684669722701', '-1.650284458992685868486399903806413990004373003855903554255634262462272823920733859164088044294272768929194834986945666561794180291325817436074210916748703508868419322426333998279701e+107');
    T('-788627400197335866651447870.157709244984248131980873718306382781375', '-86747290916497451031316747659315856743776649872846183098534827784400266496743256523741518237922.2996321602121937', '6.84112905096393537461269413785832954919219508550269374591141540623116216431585547212308389464605406974151833014851983606637628384743188851383796216195778432408403881159962523375e+121');
    T('-1.04017', '148558325637199565292759778627500454502992119749146789207503706844555418', '-1.5452591357804587183056993893496714776037731319947001572996913074850120914106e+71');
    T('-0.00000000000000000071132398470582962692145075368461', '387290994676565.8926187930695693123250251643', '-0.000275489373574019100458714153409095201115930261231849509402017099019195631423');
    T('215107310441729713046298412931278726261089816.7425287833514081638904884659853465814509169056957391447566', '-0.000000000000000079530922946391176631073888012201003836910614023124515004051787554271', '-1.71076829319466519842618108119001097767954970538486717238178897562962688286230746264794767938468573458599488912245410770935262628286074407769931453705541079989415475854386e+28');
    T('15.20', '0.00000000168020242551215734349782244623375617292165135038473086956135734916317120833176', '2.5539076867784791621166901182753093828409100525847909217332631707280202366642752e-8');
    T('53.7', '-203077092210298580698048848822677', '-1.09052398516930337834852231817777549e+34');
    T('3762.1500774483361388784232631064469116842540525321933222132260527508280723', '-0.00000000000451157562475195223090446528742025080950824631951180', '-1.697322458607458258725685631392223266464385065379983966983024481605281774480724387957456810916611803963822277644621467110314e-8');
    T('10153060082382209456279162718229817773.21414954173571898129540', '13877.5946499736990', '1.409000522801288735724123829540759783413794325474382601016313019646829496846e+41');
    T('18897399203675243.753780', '-1910633732732845629536812142230308713253202119068241546428657394632038831097695534323128365467560033377437820071074546249694941907476629', '-3.610600837946073550532020697653346279388929417890343273657708768347378585716753592761967644855725372607255782094846473883590443720333438235921023941358040762e+151');
    T('-227851381988110698228234897200521545909.8859817013555168022664133019970486786396950937267160151127235063398214239139286950658576124761', '-1268874936070643773798575676971891302001120798002567287940.21946823635809002112374440535791936322353876611612756137359816293380527820953454', '2.89114907753771796464127821062921785105163932083151495322011931184509082675890958425989774091841783969857985176854191074417481688593300580341868089326459718767784372087364119694552216708565314138516855049665928747274756209929360259354799135676979673768285573391477874494e+95');
    T('696500910829095709265254100912961.759143821807206113527355359619517140', '1114499552366341774527606900484796988675131209334791717032223696865951521317145662953110337604968236933370458980418848545855167865.33', '7.762499533417764961744733643290572565963244168792774190520762259732634644303990430873725013181100121300237274692989559835517257654859131921380793007417874521366460660750927680178271377182536191467562e+161');
    T('-70.10', '-2517567781055870080456863350280219592820297586247709916931434675762.61506437297379043545134128087973548639372915', '1.76481501452016492640026120854643393456702860795964465176893570770959316012545462709525139023789669457596200413415e+68');
    T('0.000000000000002306594150940581693662924121203297813803898269978979627841840215966618235769199313660292073294', '116992676693387498070382.7747684654799920318525566565823', '269854623.7638501167227065187659703931498533193140103582402361671530932334102659535168542374567463444185883703688336666394633637064104492276191430962');
    T('-0.00000000001181358510850947772334650728239469358105', '-481890547669680463659904229596086456299864735360996516824114722268856.54851170927985881751230609513583653813147810', '5.692854997882013727740130126310283585722443259230619411261749891601386990764956284506368357210347041750883604578383235465621769499444496072167018650005e+57');
    T('-1834.126675', '0.00000000000008674517502282013089240795076167689517217195581862368207764378830001739241505540256750749795374881231669246429195318071966775335388150', '-1.591016394368981357967569774740781611664593018538591570853258932691148023923957854519289902594786129196141965293563166090383235636747739390125e-10');
    T('0.00000000000035250317144887670812951006342432995417313795500599613972504272719157358113604799695738826228638715709865929871185179926814011340468405980601224', '-0.000000000000000000021272512743884326405045478763658819652652411080930898072232071938774490149150675831747076538', '-7.49862820690587140909540970755250892258210729930767016105970954978799195506491402524535800885748254897893970247659807375624928755168639617915215048372226158776475176073323855448724956084743637169140454360251047844711344183201584482512e-33');
    T('15721631316833446647076872477517236.12954053920703267418936679341513919357706705809389209070714586294463311338245994298023554035379477', '-357511350671198870300372232100538.1303938329586437211936443603854018463080112537158549352615274628829848363889696735642169838', '-5.620661646835744415086989091837302307955447632522363902002938200959151381457803806059537394592953324800087575638876011854291111449657686052527475421964247595605170282782797258746087685871582969776908398036007564256205557694516425413130055587991480013614726e+66');
    T('3253729487345424036939309028740036451', '41382.193', '1.34646461615119395163461615513962735242317043e+41');
    T('-53618931066856441239525329925922774166747059804.731067937979588616198646926180', '428.71708', '-2.29873515597039782674008800318782280462672325780696736316522303311379246101428651544e+49');
    T('0.00460104302362018630202736794501376789373696947488687556056401041393190634456941939438735', '0.0097403733746400832576516808174515324023665911967721621686382928687157274600680878342008', '0.00004481587696284356635234124520882413754979811951974130365547261171837147431228113809768987174613255553265451013766186937944499945070524997906900028884951249482196583289287988');
    T('1677453254494.8933968213578859249745170393218098919671494230225238019960047762641999542148114948195560618412253838', '21698.9831813409037769663882983019728670821859931084790618654907569761557036686614568057014715225588686176', '36399029956770254.61815647295605403222195084034899389723728455774968833742619776793560171529933737657028158467430352145406981302848175254658241102272245868058796169820204651822347385243123767173210904612588453433543488');
    T('-0.0000000002919695530321722484984277810687310403212039464661356722375751251668297055979816704921817077930395835966342868337436171143003475385582696559', '0.0000467435515211462536099607610605749574554406010634606838859023639329665349097075031538491899684093202279174', '-1.364769384476538686936225893376326381400072912004108048321079964657333163471060859282060687267616249897947560336772938595308007366926166649543531172638654882898076593187120930620811092498003694929915967620884049583354836924979303135355647162266e-14');
    T('603854611243120547.787810466452796370957795270702329858515593134870178861102533', '-1.443648977792806959560328531759843896504517453521508829432901295106075946137', '-871754092256603815.457694771840809554026399109994406269191599674109909866767981863687374560559981613911867626356905487893301607765864732838103294942265021');
    T('-40.440526242216028465959594055135360244752337785292869659524201380035562721496158514354001447065595303342069691098', '-6241679606047503379025590422716839198006778643413679187399633462', '2.52416807903868662768373787395500221586271219331254483212435251241310894921233219736835628583965316050937610054902736153912767627312787284137615949322472984890293258224764321276e+65');
    T('190202434.508038647841031698547078216727', '-94800.49', '-18031283990554.97275426724712779530301404579623');
    T('240457787673551.0553964370137451859068301029702133344054038041468987152326', '-113811730.49021', '-2.7366916924974332953445795236260775735980418505302834775806957412715746250777592172846e+22');
    T('-0.000000000000000037347671655579143058079422192039757670106144334496120979342554992077029390338777020220866582016017618507350840075639338', '-66002749861804986801728090866144973725446555526.44841912823309868929360696717462761165075411', '2.46504903020401430710916622478946584523872946340038310101035741960964095064955939570946178742591696202144017351188867915011670426023840138265647815988159839485263479191111855834656201283339042728373652808117918e+30');
    T('2217096250855392361576457107363.550101329506097526554933312928808962970058721968159857675935', '-119.02573598179826220767289082192322334412324905093960546113476851847137178273867550322447', '-2.6389151300054870078699458746934883192689259758705923255722692155151793736620554306044775120676679617433953726881548219320386556081319536307857183199189515857363954254037282212945e+32');
    T('-7810543038413013183543974906750692474736112.830520775223157129955459725598357936920887935346548627357711660362938363582877899220351', '-0.000000024840601734880447844125586432330812489626056994428818563969', '1.94018588950360699674928168207639163235428509329502583916963340815490425553873121778659312254666940895194771657722665285619316279071834113799397487954421488584967639435397144832420520133119e+35');
    T('-215969900665491429229701.3940073328175247468', '115249.193647', '-2.48903569037205758977126520019369452248876591678435796e+28');
    T('-4035575127405764517339706203.4788226338445902', '-88902309983026598393661019935338468232233526534344738519100289640088125353379283048690019987369761984422527235042814970844399233265479337257', '3.587719509364193355575242986206913087493287494035221267169492881995478618778834577094297983987290045033929823209982268817160327957706935779582674240650855654673552267470295842307570814e+167');
    T('-28499916611563776888621.53827878180215801449832746', '5995.369746918629670729501318845959128845800374147641916915834504403849426193388405031670359811808264465541348192', '-1.7086753784267317072023465954287299476765112854412427476967519098923744309002169668338318340958052443834272196779007400662171578997777665622369069868825749495232e+26');
    T('33940277567855896556536207237998924729047510555567616051277715731698465468759889055793654824231539562678564552090900045034922322.1690641489242517', '-58557275066496364264951120471607827120696885728717812654290030305387606748831.9183665907629793676083704092979597697586525', '-1.98745016937417395543833870238306804764880834969233299088069121150704606919273152334891301543693138976149441332170609730695515633779077917894486225657656974898750258313446228915338253648124299689091087492416283574756990938405638221490525215652696287427161316283425e+204');
    T('-0.000000000000000001047064413365314260621529874256953696906592212846819', '-434397528124418421.6091661017223', '0.4548421929529367773911801643725801508623453120069985877346513296252893958219763637');
    T('-33370590738262171579.39614973283917480277678311111671774535779751556185640913284598686491', '-99094653.33173767906444057476506', '3.3068471206833860362071327479835859150736781389077457604266441207582457927611004156098420714391130319622364115692080446e+27');
    T('-0.00000000135893504172734', '-145791096031983569080162023719458335233663720930454033985903749.924827775901017923575087659941838981388109045', '1.981206291696982245471792411246101316206613787316920816048059429054568140323128384390929922747612723701453667023730777903e+53');
    T('-13865781910.2079575101787283939774081870084', '0.000000000000005111340576657977529690857668009570333996738347099523635843713836084214963667601914442680495175289459369931831218047341605612305371', '-0.0000708727337047360947483712809665199876351338098500645907437129231083200095113355222531742276112479425377592938317792723399224219930646266745465349945511268888900466157421164');
    T('2221303.063062607', '-2.525965215750429650596003299885690890329317816527744727340100271151083414522167788474814497266651607680421514303744', '-5610934.270936028330697409054729056703155654194124398987862017089179613782122545869272030899868261055124767892056053009313886500608');
    T('2955433876854127435547184981659750312874750', '-0.000039202878947452162560625708217061180169183736624538113434241595982106528764', '-1.15861516511511599582586163812175464411359319256995079161567403334139282606046617827274676780880858338633660404309e+38');
    T('-1925003256423680784876.1957689269203', '-0.0000000000000614144439205338076312802493579740530216692609642343477458243733481030491978062242259372884320561187326591221623660', '118223004.5384771047512790006924893059325401413863133808621379188835488070846162209706362064697933581769897034762423998928884355927161113795649414298');
    T('0.0001074280907302126774691277050759016234153511565364175703838489020817316583420637215', '0.0001532977223327450369874510044074807629409774927247949577150151195776859623266960380925487660870709945455405380437750382992', '1.64684816234970840550538622604713249522114056250203424510426725871022595010818109545611749855873201375214405305332022403202928107807661566637499538331414567985551667985554396394756099731355830293824728e-8');
    T('-51719564234003853480795874799029206659495378941873129625597250275327964731715068962774998751', '466532423420562663.592331220126361', '-2.4128853640345274449820011797672270168670456082913030458542405572274060582037181131606130323033781460111131337883517837175111e+109');
    T('-1724059986073957512357853.05703381906907621063941826220185749299041791046931825802106508069', '-2665994918609117220274024374289170787044923934794140833582674324712895082643859871981.5384174394916234884976873', '4.596335162250476126397000620689369599669734677111641881617412368616916429689082558324657810003289232013968094235442049486840526116938235377972333081125575786496773286246190410954882029026469852888237e+108');
    T('0.00000000000002795129561961146401319754718204318652084938036308535981529129883306076220009274119013027424', '-367284334695386275069239735137863507066443274836293057467619925457742005840610489941285870890827991341527453.1239055840633353121379761935', '-1.026607301552306124313300154008632390701208483751483889410351517683637370661669822560424911336313305943490756696083944005783385779384493150385978269507423733524787840537586575485518520814488626005350057699017603079788874630544e+94');
    T('0.065024658867154009934139288250506881782640024913856247796477081504212332678', '-665460681339474763575385930611037367230025491535512485820105677925713917024055708892630604.560260598070556046', '-4.3271353793603226678150325769871841452491924531112895833715271367485564019397270216591883369859017756012808701471442567394097379898539481503530181916728520372454137708175982196271188e+88');
    T('-276510.208587680613648136603273411746807332340011833', '2605351321798093.990970489610', '-720406237434580367010.08789881220282603686585579572198020594015398214120355513');
    T('-1141731373426523828', '0.00000000001228914544864000403177026028329087085', '-14030902.9113140661455213068073751399665217637223956138');
    T('-6945202132900812232267754762195507765101114.626933181713698994880961083764777532865251281976086752243853355949851812697573518483229325256100662271783', '198.500596182566233231418150714777497924550531544984107394883271', '-1.378626763989241829423752237699325897620912267936419616678649561070893719008729731590007841901671107837003264905764835754363036476641340160319240720502391830298256035482481144857802524759297321191775928962042193e+45');
    T('-0.00000000000003508292319046289357668381194881192144875489890254082933630984748085694196310674317752270255439632992013292438026236847255227135350509221', '-12646.289', '4.4366878563139579594698714752632876528625314168731416208665252478883885572167521207173040056393420870934788012794380752838459114284655905930869e-10');
    T('-0.287610207934561349588295090691549344568062900733', '43561994519313302798849015634739297829426206398579890440129222701736044543165037398693801937437.9243029452694915', '-1.25288743017439209045579990822356125048347677549255399828298801437378973121007271697418144364441489766184499365629256770107139603488677894036054186818978872695e+94');
    T('0.000000000000000192', '-12108079130041324.8599910305913709996877522568944631978562414383996429587415771634862023459492435054277466841987842715088475336753781193', '-2.3247511929679343731182778735432319400484333237369339883983561727314480783828153893508504222547530421273633661665801296987264656725989056');
    T('-20568177346839726327867757072303820722593133821514591458610274374266.37198646', '-534342814455338031486092101151521752991657451149454616317240974476834470502228759280758223653930620503606363601006870', '1.09904577717268667573895775359758445299657810692590923812884672106543889507154870122646024207383034114557837930915217170509202835912718118550506629814473881108189227609033460252466188180069802e+184');
    T('-1182.3299256870', '-147162546450055552210266162228061556539.797326023627550726867910750435749282172653416371899801978172967970344774632377', '1.73994682608203866701785740185594706489760121335556873257063559751827647851659356907682594962027863260816409968610867061154167999e+41');
    T('9106311100510091578555175.291251271962559609876', '1014206950166689350187558262800656656127736355378743002804820184380658978941538.13338393728923507197611', '9.23568400851740850405690546305915901453077329283645359090099261781771022159231929782452163389786781433252697559132084134612891947899159122199206236e+102');
    T('0.00000000002380790398795067678584772975148957851144823495943191934104092082796285119597281', '-311335492270699981.8187024249236948798391482088578', '-7412245.508022185205534542741414892061741870570633829375932307947952750675656606815024557059080304215250354778137764084129956418');
    T('-459107433083516704803135533549.9370726940122774506638331684', '5216864295258985882129407260355552822654299758311025336128418645120106444368253186174452684656258241404364726655870378516906394208438578086566108931', '-2.3951011753414023938728351576018231982234001717277301016858655888837322273016599246665882605588507148724528061606913078187945915687420371837702713713354429660018711277008065538782057324960908955177252669804e+177');
    T('0.0000000000321891162991981855413480133794894989319146938941669481853712504240526430027314092932643025', '-134763534415664538713532770059667389.177391730107496493', '-4.3379190821968230280422342891216605083499498614921463348518339967882865388159072601421584951618987475295234426996826071260203876918460408411325e+24');
    T('33279.339415206582540482746683123451895750217730735', '2358123523728734728589743.77319797', '7.847679312915151656953999591683173680703507048673633215999463330697682756730860795e+28');
    T('0.000000000000353739089246492910027064870427354171506304617311189028621762245079583293104983994786058488849', '89.2', '3.15535267607871675744141864421199920983623718641580613530611922610988297449645723349164172053308e-11');
    T('171.11526841158167203333557925506243707903346', '-892230436.9596630521366514219721041194232334089033401680786089416696171067640821518918159', '-152674250705.335543438952814693411686830371790621030553860131456031688753597684538585227522590915650930288422940391639997604056260014');
    T('-733600573426', '0.00000033040751206672045761849003644598960142858564314273065863456912502993453964294661705657514355828281447882514699', '-242387.14031640414208016942107704561068604361659765821593779056830839506769730896756901035759801454275354730316665273788774');
    T('5.407060250', '894983509287282057739447083.8543243233619681646503346546908188657720214623', '4.839229757472768644941169184087133839458644424846279660576202729065982810949203575e+27');
    T('-808729895781.624674969350592579908381307343041664310702922570660', '-0.000018', '14557138.12406924414944831066643835086353217474995759265260627188');
    T('-7874173051342200985556358445162694781995734030142926506325840936292568550580411005561682118906679842482219.0492', '-0.0000012325012891970851064894932661125', '9.704928437140208129135757974157260618986599406272057601438444485095519271950063154371970461800830427187707721546146166916789646799572330235e+99');
    T('-0.000000430107308276532278514', '224144306746606979302588712185931212406889.197263709151077', '-9.6406104440292501862428318854477364480895829071122484854759676386315467059578e+34');
    T('-78447932062514438523504874.05548646556284585439748424869932707256764818646061107800377213587367912600020326136', '-3618396947489172957173653777903437148775132', '2.8385575791184026440804730054109713727456120179794155436480050335238908442702365065025115219164988251654681117750347278731430170767508687816655566449952e+68');
    T('398344525499512577582336511121666224709052905420447547608128587685795296475632034766287454674444514141282803194155553367745120537420220770', '-27125618478287015045404726742380927685738591197795175985782379683976.193104266048757690370843265062495822', '-1.080534162161405142653380276457947626239920154503690438713413845124333388848808189678412350793281352453783298170743129726689403893393610196781463690430258145190692262396630679800143839228210109253361757862038429643553279024184277250644262294e+205');
    T('560555227022785413491923481073654909048982696.2480925260763', '-0.000000000055945909195749319312168314920740513457467773655137010097489061064437802811189813038277307920819234756363832360445689012158203384', '-3.13607718302193977963347461210034229231284614823237752102010861278943979945733599665261238405005674005758593157383769276422304789339955395466489473545510344991715182034227247859789021992e+34');
    T('53683812799175377405416129296695521380051667500787926235235161394163291.6772285236819124409364862784464258457438293794967799666118416541092194902', '1002085239338631.91098069654292203203638801404514242082065101889787248609067618438261168776', '5.3795756397471969187136355919525769970238781938603258307213243094992246282155354543484962264142098786182227068998815395594712635092562656959880937968190303422424114781273414341203880090074688223986213775703111763870360005321708779952e+85');
    T('85251406536953414226544773130024365036572408507583595068846068418600.1205319812043138751554685608133508306427759344342315262715891140344502', '-14640.836750817778351989018346781730874633202', '-1.2481519258851345347885051287664718872340382940818875870448237208943268320517859270539035447679237658640425284982425765828931101626280359992735997817678878451142046283911403167355404e+72');
    T('-1168964957570.815587458251340', '56538572696115.72608565692028718229319011374125733775862205437667843677102186943732802', '-6.60916102328293923983280676454563885183081101391883074333220411142712357555724202247544863269382868083511845468e+25');
    T('-0.0000035740568614143300428297245610418', '-220936232135526', '789638656.3990059006672364554989705373573509868');
    T('1346034386225456518679533104316275599194652955318802468313820086088149624400847.185', '54939560960135761994417267108815425036339300614381.4483866588714259041240857418173085472293222902548715740451745805798856530861', '7.39505382164723930246517776761647354791771483640955760963662039805511757685269752798232203634586599328591387494964164173089232999789108334073422192252509759081688578894765226433014479831461369862878497476285e+127');
    T('-155646778363951461204593301246056264317969228058189198896139899890727803045.11936198483334033209653315521827243605631548584036361770', '70010086124901511162734982850', '-1.0896844358323698924028061858087281789212298425539029658881075600265807741939071442787428242144667285959576990020034537638802277308860865062577335864173456445e+103');
    T('-96230341173782142876521207175875305814979162902343913723999663923462086933.11747987173088004223522808909664360812790761033270386408', '-32312766854681308785639606074893295460039.2098266500874834272005936578144638474562541816848168427108675212737366956591462833878750808347288369144371132', '3.109468578694861657044341174482395073888223668003904483303702568979989305498812009034748469873885971391784305796766553860166319366182690854126591215571252169482729464411083827831940112574078691557408084659925085229544889092188654423122525035195011188050614487145148823899800373856e+114');
    T('-0.000000548494172595574330396761429371414006142446808314253568896786945188386738792461354439029277', '-23599662.27946574215991340', '12.9442772355105479080497098082314463897599465046293055191920810370276950781896553331072508851470742134787983846118');
    T('-714491311271945967722626072689371246725304', '-354207932078705268748581131.065984233837379302661', '2.53078489853838501514954773016484025244072911508100754790233958626529737581211243343233944e+68');
    T('-2652957183438', '-195185962067717725512037169887386249542535008172118583806939423414913218407717522397396925805258634149', '5.17820000173808723699241726590004932229973891258816030817795368301911879552134013341717829627238806141061924024262e+113');
    T('-0.00000000000000000880590826878036444443656266764836587490740155586607932367514263056628321181262993864472136637', '221.48126943989476644014754266743958579083215022106146593457414', '-1.9503437419407411606247922977674915717900791357974569097861654104985704464836690328779827178384445759527338871093471950304259661832134813136971685648676718e-15');
    T('-347873602.23510519131378528375967688328126', '-0.00000000000000345204441953134921260412723999268616841434091539516160053217948913648444927706020879947861434828121114161104100848431013272935429403082369582072600641', '0.0000012008751272979631661860642678932206188355136599447128288384619284997247859154163277648673794145259219010025658692572618722220704615506152641552019366413559230553625413995603960631242165928766');
    T('0.0000000000000001442618965364152298486684187600173330090418464315351795690935142411476466184129035934014488253341654078976849545022104268819111681009555', '0.0000000000249240364882037699910299485535757120039682410050255081964884056237893758868', '3.5955887731310902548303070850838164719748874637094192870760300960851465410299817503704107844345957619545899785709783227712047477876114102968736355229590341265414695145023045767563414004483980850712921197398374e-27');
    T('11203361460741696775550516477439054249886501188874281520876798975981497083993389664224944576772981555476668884535000964169301021', '-0.009425091022859976408210896617129512523351916940774040126129926398280814501901637533674397', '-1.05592701529491998289184550400386588919196745317033009594950262014856245582393791969590569776888682089563381256271169054068993633728958894678614097027273021445496799602248296257190716802772690940886533141705293659337e+125');
    T('-50257275098882173690313530324319207319.7', '-0.00000000000002613102305812786358153112867873275089759049662992988804013925307324391675101078591150104728275428248350857948737528851613002722', '1.313274014447565385918882096099252569252443657688483069512563244738248437919967250811168909580079875716332790199500861141616087147571179420643034295663475485584242234e+24');
    T('-0.00000000019732481798', '11713877058294598799452.6300621325958315801323987275857206144411781296421875252993224990921811411', '-2311438658368.079557319116750642590563091456361363221635925091739233848401495958715457150683358908746196978');
    T('16669921204672133066496720461645831860294144062172262348452206781980345719813505226331586428501288033918045572872571033439052885163185959983499', '-251909114234', '-4.199305085019531263164571072959105073744794265399005234122464071331276442675313245235919630379775040752398208810774467987877807125340295724868202346024766e+153');
    T('127594991665.979', '2931972609362423110559000705020991756049379484274406531578719920328328631360570935031987.8511584086593935337222578544201427', '3.741050206564770789405448806731198284533698395535872424847129715200781225838343397951497453223347295962658413239336292329816540879152033e+98');
    T('146200133592544330684264498065226245560031705674109303503477692120859154893091630.871735716026997526317545935283624142687003866188151982212989698909', '46730789676874137872952436533.29531686073021669792243838852461391282932511897427150915122385179702857290277711857', '6.83204769364409047271650618653599900430147034336920824087779336527502529052104798054004653483290666541743622267860756708314673328113463875187686742000697177806992937541292873782614801211759243277925667772455483685539661134063357932775410662696035415889264013e+108');
    T('3305168235.08883', '-0.00000000015960253276367470672820299075290130045238822873945326349880534378217699817857400746554521112484146318053536850963687569374932812857474', '-0.5275132215302218955363945278671543840140049260367406641422620161137050522156464498199756178493590046194472374663980497123349110510329792890451941542');
    T('-14662664077162165311256', '0.000000141784657393925274142572490861043212868340562120628819802636951941686924487200580031', '-2078940802662653.108290285852001564512570305578867791848575532841089886824260278364785279496635830853128936');
    T('-0.0000000000000056998852880676332652472177552050285678774883196500512', '-36498373273900144419354144402538260265.64880867165981459073157696308446822865007237717278768', '2.08036540862304331717677642102316632522246004626115723942329232479603003027974589958566297786436869850538183264991752492295191922735133158729216e+23');
    T('-67968411827513303349511763330956716200597055731528479256856033995905188987752276494336231454282073.2592237192851649247647340481118', '-0.0000000000004483593999475811573860351927852363194231748110211408', '3.047427634237394269949752053446075793452954414318045278492820191953525157364829988068926830766709378481812043618023757341388343262182042155382714412297436468809738064216143412194144e+85');
    T('-39147071622153.33743465738395064998231007612242609707852571665922928037980935209746718640869047087190554662186743691289', '63424511281756665049556884134307448242418039636636009044809552022044426453480310050617427620937346481967898179810376485', '-2.48288388574700054052521039639443124893165696752230434717540647035194354741975215494021537917119812595584047998724074329330913195295973963059478012613800118844862490179027576674476090214756182225141979897773406174093090617028873704939165e+132');
    T('-0.0000000000000000000212', '166963558962441896333912989698468664503074325140998167446135880665447621153757238111137.174513086233214289455390442249465', '-3.539627450003768202278955381607535687465175692989161149858080670107489568459653447956108099677428144142936454277375688658e+66');
    T('-860642938911.89435988366786337586704323346250899248118740045', '140830725536103329346326306.425423317117473697116679279', '-1.2120496951448633875490135507286030453466902766109934494954321323997081079892561368828279080230440233059839027555e+38');
    T('5120155281492.6960891', '0', '0');
    T('483497234304151.93475846468237990040573513326581342398440051651712771865349390238040778985950490599787315241732009163910863036888245878997967132752', '-0.000000000000002446148373855415167', '-1.18270597345669190978054478684634031633264057012297038134354632718936884883092588556284387957205148298464894749852350309479922902362917548718181008887660019563249584');
    T('49107229571.216725255807725802556664025020334907', '0.0183027672070302023790702223019211', '898798191.0241693052645246478450553949374710665324134212540239364754063914898377');
    T('4777991472272023913003337327759575484434911659878.9391160', '-272.978878813339754436881', '-1.304290755080515609320060076869253031973150159686523391389068499267988263937196e+51');
    T('691961893816226173138683615558104657029075119080', '20888395139664451446632.865882039316262400286', '1.445397345962386803567566022135550445519666093682044976235972214321728596830297084207605688e+70');
    T('0.0000000000003033805695921308583790907838465039054504904757732225737126675767790336448122804692481183103833', '1205.341037096038791925207662937489878783324398262713191296436049856974303800264977495244455397149', '3.656770503869659792755630630441878632712190709939383192077151780666062487640831547779168381626737843643632860934266858208328198722651475946630361327414380262986385955514241668191884519172117e-10');
    T('-0.000000000000000013736762253040628738016656811899978900772420917465579992026756713474712981645066867464219941729626816955275801365161507762', '85532614698100819357606499054389025847104053990809', '-1.174941192988739408334389452599416522954290918785451326292660032528327766954585591614133632582363824486991674256064796714808554605539806946168016562596219749595467730159458e+33');
    T('-0.000000000000000000015811255247299305828768713319620074244982509614182062286978069545537489406407030102060780870055866980118153434550305', '-401137413593688737860912906172596426086830141009', '6.342486035571282948613963880018634581799042582084278022045824002489491031661976947293164151517578765536914386152201758345969760642775856850743822412630635653957745e+27');
    T('868871903240454856454229094081624011359909603881418403823490415408076494742619348242915473328227861764639800179679657635955448452.19436', '-0.00000000006357246685755280701854672125777125138', '-5.52363302722126457498705427469309802606911867827348426238286090544579757343893328680598652010805938682728728170222222699144643350355823304335981947914590621447842841782168e+118');
    T('-817490632.47780', '-0.05082', '41544873.942521796');
    T('-2566509873328000254011581163819375336312675622809818.499935237794106355143', '-14085586641244278298102529457882882173828.1386', '3.61507971863704252530700366641383269581722371260221251588353625777177940442779032699974632687837606902398909382268198e+91');
    T('503419281104.463633640902474726192736893485104591050840525886329718599066457645293563757497708980772570127618974706495417595', '-121337599145999931368859624997930779.73179', '-6.108368693302086597981507602493580554469919267653677670683934587044246440236052848418720220332789575988975507246301734145970281303551608797453924222097493814684505e+46');
    T('154.0752879034465903', '-0.008726217915728513196107992191445520422089690044688368256659372978169115950', '-1.344494537674084306953324167403048279838310386922350436364043480401117060195371791792845285');
    T('-0.000000000000000011925048592029545210459398688308718254092506044948381860935240918133166559166620982921389189346569737569028538401055', '2083276415584377368536532532727643929994867840790251749.88373757843573756621600', '-2.484317248647283703600678453474259458742779398299485727046453258915073511408926866511770738523415042481132395288773086582850710882881051220356645201811022177650375833106965396711340182675788e+37');
    T('0.00000000000000446904154566584455897206481462213986849554065179928600359644945423277723320322131526226161353244832569', '2848064161461423289727866756193778408645084968560840504840991868260331965438561614918967119347024529487381145007808689.574200435202790467855', '1.272811706229305662213683326319709782050267108388413502237287169373774908480672399099191144562736507324487505708069393969774714426776963142634656549866268950975004320862082201493957308813283909556739183697464382316012026987207034028651569495e+103');
    T('-0.00000004733747496524284528744980210835293091798469780', '-60369256501669614091439562465874779052299549893280439175064875222.062643118496795029', '2.8577281683181092272030103013062657800563801201278542890132513734588525148374106855868764763504825752739825308041149449651072362e+57');
    T('96456491774549605983464536192479065464697606538688448511393590515441846121829477068030573224599124', '552591880159850811255567071754556187177795094968199872657.3807356618203751867762303325381820718525675700180057477640927815410828', '5.33010741433215513846896037986563851532355661394443362975026204428856124749065340874569306244290877879518226101551796386327528977418142095601897892583643746390474594920802738822250754452900709400116274658794833132949668914672e+154');
    T('0.00000435296825302837417997979246513279920760355177075128726543859320043830213235385947701661297471019483638796996791390033912786070', '-2358972609625663685288774473895.6434231', '-1.026853287946401014950993771491057785216233603666290400912634027422541733751360917945594249383195357423341794633440301199534687372368265325725161906863912592796217e+25');
    T('-999234622854868865674773818245832433202378284835.73666608911561114433921', '-7.254', '7.24844795418921875160480927755526847045005207819843377581044464324103662934e+48');
    T('-78760433369517189268813718850989812439872780124626693423016073535122', '-11.0900738491866377', '8.734590224618892006011443929973965209196433850642586975929968912375943222522040392994e+68');
    T('-1510939307579695343987573960', '0.00000004320067801896720565303672103306587888166187016245346353772091834756228523943136134993165134358763411118907', '-65273602532951674469.8274051759179425105664207275230087993219234918464759004305190552070563017062681064499654251448984977190801686172');
    T('0.0894174964177934303779732054608056301726883008695547961408331314203105438641593697918217224788171493946008016972690054132568541347357906742329332833', '1542.6581508582549101995706396231', '137.94062967824784574736167582697025827541997000463104865008652399044560913829513820967821268072546354439954364140784723516217249346765923537667015058098902147542450230708975752423');
    T('-34577745227575239042650497034045377305765805548524711395.5081303310220196', '766658358890973242394467250763846956795577882707608858967751880636.0954859315385805368772376186546221646109', '-2.650931741032301486599844865029472285624680782442203783493297156082528515125839636070674383514156414623150702190980592575815090407165174168924973668598655192785690042142376617364e+121');
    T('83.3290153999204844106326', '1311627337486915320509440687345026266029743794924400721935513620655368692498627634744007885.7578920', '1.092966146044038692204564531458641541903270444270154411744236954983690234590929647426240374543484806952751680089941624792e+92');
    T('-1192151.908799751109585637800720757640651255179973011410490516408835753100899', '-6097036742802358386983942122025791952308256986659597643479361457987833051908958694867787164384275533358919693.249523575055559871322198016668187', '7.268593990954048718183298042908900396708340089605455889963655461676079135319303447970644868475734604822116794986972434401410410290069948464123089061651877757219473044801702473574398904984445482549630675240973614400113e+114');
    T('12873087032432609726511318658818382838704088', '-11137.85789449932987810195', '-1.433786140307564932441456398853868326855191909251446120695471457716e+47');
    T('-514407318470542052534960135899863052948602062295713.404163', '0.57617979470448909978527108240023648361885980490885247972540173726145900170394342', '-2.9639110315084366361019792930292554963023439694418106043485007867268143561606223483230236306497936769993015568968024431726476622934445746e+50');
    T('19864031434939435816482549499647863708767614292250', '266674221057214323300502059.20145204832171982196589122398', '5.297225109968493345109943564396209963433048692089789948298291839648394867940757685353484913375893928155e+75');
    T('-4754055625084332185755418342.562', '342203501523496667277706676371384769113403050858703638741982429.86030457236777579646956050309789441181343032128562816083443', '-1.62685448134133416999696896663497605074404274391890811668228808135026703965039960122943110479134355342110442043580444401677907314671327937812747350400966e+90');
    T('150750927242228755712.122222703133987729780', '11153110586322698752791057735178422360301.378975227', '1.68134176252326445776964103880327253856485045353577333614876702243490238494407508859016006e+60');
    T('0.0000000005454515643719086225314528110151760642884722399372', '-0.000000015543649516517081944335531513584387020723567068639189715742064587530870420218940682937593923251202031320330', '-8.478307944832903460053527019222484930464321162422574722274786852848535790350689038575946698474468453359077459886259429789018774414058766868470265072283276e-18');
    T('-2767036068909663273137653237379082714767201822111902341892857916392935025490148010094342382799970940711420469586533427545731180775808468923.9088539', '-106163436291247150687286.993186225478584736592', '2.937580574172739975981907042564559944340709871604734255385615604239771087687041986895276609517297709801222177972170328755157939564075490962060559952941922254377647597925548092640347481119088e+161');
    T('322929059228302.42232788641548949211838', '-18539056294225888575098493056536343700876218241905416897333383900668766550246400797654743627780376379843529081553892', '-5.98680000807490479064022688673406386728717075134452992916398938660729018368078136257909679075702485459797355840674648444941273018869686024213037721373496e+129');
    T('-0.0000119088486605', '-678482308015968521186583296185550742292089152413308996093003534425067540438719433029394014', '8.079943124988915136143008357350970716799926602463815180494764874359731216575673502367418360750618247e+84');
    T('-15743621782091209915924278', '3274082843013731438255081795999294296956951330200864645074905956456916040.35509269056', '-5.154592196364209761725129736597728957541850874359227108512452329645582903082160123855441179599042326424541568e+97');
    T('-22.04', '-5944551299976709752172805837341550253708966615717585971886595904737262.553978573497219171324864133558843421716871647969330963830798611962604850', '1.31017910651486682937888640655007767591745624210415594820380573740409266689687759878710536000005503636909014639851121244054442830801407655810894e+71');
    T('-0.00000000000000000555645728539942948834543543660522131579870362355003609281304516197635570002691794651513876516995679257618212853838', '-29306695827152569391012711584981295617371666610349814272.592165236226105635164951770704628516992499358459197490584668922484814646542200', '1.62841403539766953518495453372218761268090502299476097416218349383440252143468559124456611158096941013793431583395346583297449705537413859250236966991939668836100087684424197338992971973055292271335773446637724947073443337667809840027147206989636e+38');
    T('-0.000000000000020742270836226952980998683613591994841969458265756792', '0.0000085068798515187907992734965918590053220157266548600897228989451266931328328578374770020103860942048211855612454052631692704585242999552', '-1.764520058514448864430556069534618615275204892312035230025568038037623488871862099421613268028548477427078877470868347138110966013281940578093221932329336549462641760519469552917396957184e-19');
    T('0.0000000002219866544727448068271267401609565019963347224974926712349689958555511499', '112575212318901234841480884640021.488017899845441345152302010098074629364453', '2.49901947592318130801503047727550173178035497206246305960969166018454548964265488494296651336239176806475308333361242019778922151710635090703345047e+22');
    T('1315378829978163097323201091487091023884510464263405789489832239136944342027634418586990942689761050161994364084475', '-0.0000000000005431717253475371481154070141404996706352278219461841093282411', '-7.144765885648635691663776677388815688808217253830298250560692436430854724042690565481563931808762010822550658080798534063657410136765651632899419238667830655937868686635669225e+101');
    T('-11.974214873897', '-69620602709317858077606.7777617143271605405821834772501233928978990960832960289391723644435809527901763729636', '8.336520564915876725076403852155386259151906493644770055032514166066102032748457719926765893410251855328880867224141711492e+23');
    T('0.5799373425407396613321531402639174796275099785413933819926994175405948655805025226256707030596694071531988549812177396212002923068020219', '-0.000027700615530600411086471711309277', '-0.0000160646213575591435303047842679851674438314220751425839463942452348275488872543258932816330972165180823475893661313040152587644081646971818065194220662714757232798271663');
    T('3552978384198918.49229744871077180734861394888625630207038892347651291160127968', '576121651802272791027406554970', '2.0469477755224511189481484697284307523813499893489378816814079522112320677347783327847826609021022722640096e+45');
    T('-18851687060584485145327914172608439977632012360714293181151849.676443352833892494771644740339', '-710051449483.09545735', '1.338566772256972884671120004800472882868495911897525532968781498881932306536347328148798533337590085679119904165e+73');
    T('-0.00000000000000000288249562210477058762080967034190536380', '11030576382737761767940218.42753523411870710120067239740266744266743407186080051248604580', '-31795588.13253387463958232003043592787423655701203989880802112096311021607776492918973045954883598861925991488365393167246204');
    T('0.0002651045160796089842082260007521946896171492324757847312814436724243594046468985409527086868800904047336619267796004334725939839850264', '1.5', '0.0003976567741194134763123390011282920344257238487136770969221655086365391069703478114290630303201356071004928901694006502088909759775396');
    T('-45630450424356227610905727217979234106654796.6161863250137780341068134637326896292372723834060729494223789898', '-0.001886550312601736573060142331616041564292703429340077718703409523396153539560814169322896332023638792684056481', '8.60841405122272844640400481006709825973377910773092658383432035084194649814689826091063041039246763382818233815115923828311073497379982604148882785954606467953532261460988494258202205778413397486064962158760109228938e+40');
    T('1189249849326945544423032382429163536272388440707777088772904521287431570230109527744855960682093580486474033014', '6504.8683354042275751628267409987442515379734097114877784676929229119207894859954124', '7.7359136877710967170429074459214076095443123103950889587500385890668195031469937128361362071610022299701776151817353045025434440446556587282911741416992344550889955487947858660554683425301449736e+114');
    T('1128441920157431650427749624713171449845850142623381662768791487676773466730760868814283339962300837813340670485089015543152474935830631262056277625', '79061776144493796403585114968361776195990966081.4355019441515980323901471378982885369231', '8.92166224835496029459276238758633651524460082513027939264421048853489989185952160214129336946076678283640307013713880795010401659801489431413165623876916877756744842119523338662139879091814025301405422477576287618845313203749568756375e+193');
    T('0.0000000000000082641501664127551186707163886525969338633571732489264646653134052232915073527623626871791859115793743174790277', '77102203524923153670', '637184.188091283794704877392959386970281584723592270762046140361002187615856825504876006527697363766914328733379224518124369286659');
    T('-154596.64783108125962775029015421009207072050712414460575385753089518786884795842152456687953719640163452440709563114', '0.00000953332223165578725654281988611433', '-1.4738196597075074167285758911774621445701892232319827414730606050858237209327721967567187682158190683858892715205135805644946318114951019760935482362');
    T('626094027960191400373416029.419', '5878856.79754771959507653634625689098360680482358703172927092067871619778735053759313320563725801048848752364854140567987016428762009823015837615', '3.68071713217780322698039882190698318126112699362991022750878399644122991392056045799737440726628318401494664115665446003913196526833417240938632301385924540360002145766795685e+33');
    T('142.135419283057828760365017829388355940936300046104351305886714809787574819399072768256095762422384093950730185429', '-0.0000000000278515979862993195214307567411728513299170817121298333088852493894670155456948388404536227491002693927300401260266753267364837037', '-3.9586985574858228931018800299373061499410310433476663516734373778684106112589529389671174026955027434401703451041795013355130980833809943565348714743599848089313344119919746925003574800408491140122381937990968341446536009851615571381376933873e-9');
    T('-3414337375638988582664180574338695013525096328524003701356935598956539630495832919756207376.096050041684723108331618893085565788050841', '2373966573751563392591661339321041667260.9102329522532997791967528732655638468045668247650320116224114705207987248257276765954175435815311222155414632', '-8.1055228012775943922611598191168220209920422725184693447914123413517420845343602166955572458315096659666380761391540010074112348208219442252225691108563375371596959919631253585651006293756277244412869691262300395317383824508608721200136269451608738907028690741099725299413451305512e+129');
    T('-302467810214374958256067.032373830', '5575069632929333955431348.9768', '-1.686279103664794846091850650203678409366941699204314045597144e+48');
    T('82697078376296338907581778590825184109578442102991030323732250149625618801404609650700917759037258851030792.4579476961905660977126995470583812166076', '209841367832573904068305526440706142.946', '1.73532680422395935522579385025838046972848188875755297012803632653935308780712618867460319171676636851490602740492068944818297966533205669240452066743937774780200047624598512303547899896e+142');
    T('-8610723620694674804743328843770809170499375.7454758671', '-390208977887824714144', '3.3599816629058183220228074369266852148945886756309325082365153093080342624e+63');
    T('0.000000000001665736409252239537708350662977465625669000790963980', '-0.00000000005397325311245537834096132969282540541809141350200755301957235584804115716973637524555508536156078477308323210', '-8.9905212835203683504110846121534305137961327547168950515670333480752564275581116048493890275734599276350080922308328478982195507458726674696580816210133079758e-23');
    T('-55009.833387304033632191465037502050438168517958786455204058304623268020750747185676992712088', '-29561521305527851502676865044574530904951941035976693977553088501233865440936246487818963545187685243602080828543148264209993996454896778956464642639', '1.626174361692325529945956942756425331503823214619006101333940515950960317910361711714132411783105515670069490701197466001427788281114415821163283764678271096259297038980050657582474248326862791843561305280964954948600547092666115456335520232e+153');
    T('0.0000005510346818658465664306888534549271604193320861182474130165534720766271492178988616151168719125', '-0.01183566974341274034927329940717360016909321111795523305608990101374740733837917774832376107936390300470266447548265172072145593380615098624169574', '-6.52186451173066523843915450437892584263602058413986588969423688481780355800652939405885567360640536676093311565481528848197657456939614662844329592819951096602632005849951491911991775291110362116460575276787590328868726322084826837690275e-9');
    T('-0.000001849521254273283959945614449797', '-0.0000000015253958577166611145202508909209879321211559950068605128152947738844883802079744653882403', '2.8212520600273908617019782505256127608067239079286482382697098430394398747360047423507203058647464997472737712785222191e-15');
    T('-309.68', '-96055.1516378444925', '29746359.3592076824374');
    T('-168028626126473481129367789758521978889200869466491962302048311336890634520017.5719333163304589587068817821858799825706754229048601236351696679905637', '0.00000000000000040505144173091841345427692344370044084035179023758893212083311438716720662223829934353555898735535197317508971014099022876688542096545250', '-6.806023726459354860300059210154347949752163001995863383108662941548990570394989515646898112331550406123056248481183044010335252896104139538361899382958674774865348411475636358567387218161462977943906814852515597246369885881277132093738749070553676123096546436403361124299691370057425e+61');
    T('0.0000041405315442707777667317116430726678375268137201769082592971414397218413001195015562151372405002624925536507988661290804269379616336095616', '0.00000000020534154280912678549286088770865816', '8.50223135350417750807611605428001794994175049772882453947533102952716919656365787338607257071961225914246011148972124658358852928539815938659942645226103867281485281862656e-16');
    T('1043304625.7986054483292567142119628829071667318336', '-0.00000000000000000003922920237128071855393930461155089778347745292989380337114027290711582558804238092936477', '-4.0928008300346795587963967318969522795914555559316007448013653233486980241052075387119842284031574844035339709938086685807849050185342272e-11');
    T('0.0000000000577244850492733199753691968434531131534014494738041562671682385265947122048380667867064559302522087090151313923160444265178252188520771169749', '-2993829090737873263916664.0234418356069276036115961287838007488804067542802424350078567987894997758950299', '-172817242588377.90289435436410530982271580018756182908074690988652090894327112554557513833605455776187642341828319053607251432332962573366023560105756765820651824786361583489449624159271997847165480283033635286456942690484125635118492744583304951');
    T('-0.000000000019733986238945494869277217117479256444529951600715483268803452518656509029860', '0.00000000000000164627700103694856499141527646022342482582124935390975524916641794007931969687515151257818754024349160456008195507607', '-3.24876076839556011689439563662251683467519484990438085916787388341510942412905771246984808263084148148601145015559577022588882488930808591955187411190280597100157082627777854794533428182014502e-26');
    T('-11427925335330818004816066050106833418219402199072704112963107004970597981437954806793580004070019399256039487816876806901413994111491.92397663856039', '-10254398713648367399130671587602705.557162008583916929614232815559112128534704736523', '1.1718650285828592780495104592683632759974828335670562590852557778855769937220071548729686706912740577068594561471384906191535657977013468872849927726389729680735882934586903957393565745867332347237612282016833288027776053697412397e+167');
    T('194053275594004162536549158604917941716280933587153407126108810987941717.1', '29178', '5.6620864752818534544914313497742957033976450802059621131256028870061634215438e+75');
    T('2.93518376745944436515386335020372331712985006976884316865242', '-966659011212373171674223610192618777699658.9609647969094449683040295199948844301663048672586994151702046353417857765604445661', '-2.837321838378954758771215418938164310917942593004475873952183940640231881169627087395424110407746819193011896535794052106353148150659770269806093135838159918310696520280932274648614962e+42');
    T('-0.00000000000000000868510085783592320951067786028338014000842721104291268902134885144965679501434098211679237543640508019493070439633157498534035049527', '1.66186927561028596926036092509335854186047127558602856573976536260498222833648503213450552687521363067', '-1.44335022712140589682935718532287891186909515934902995812983197529942616459692310661388930461065190889143976230808707540505066234871399330617979826977854860688501351020336858399810037738138869688388995164376763031097320446355893619309e-17');
    T('-1181859428272891621990692513.97972526073548792078905838349464918869621234377765379776830944783886329774493550743931156263730', '2.9941', '-3.53860531419186480540233245610669540316812438363451970602132913587532937850467323589809531777434059977811140282404274969233993e+27');
    T('0.0407860495', '-0.00000000000000000067006193014429870550943276612546055857881417429492755101247850388305957467261270841516039308586250108088434662298612276060', '-2.73291790509309091456936475161149575524931645640945426945087233770604100240461282197497983428394457192787524651402698407269082497e-20');
    T('3534937774831542866352533130845566313027721824245809049775432305752915295270444679.5880933827075988', '-2.2480869970190', '-7.9468476468700692010170378639263153729049188935676493712057455085625903839492076731999624985988712896442479772e+81');
    T('-2313111414785056499431180531976979973.274', '7671974887242891859494.557233282222057816576248', '-1.7746132685625829899267375266227186594583558197192135674091228488559599633565223195952e+58');
    T('-0.049506264282575986354429257789413492175083859994025520010200438659280593549597224675611141989487638448856569022072780436586696496251665748576110537033', '-0.000000000000000002289376387781964560762840433567145550', '1.1333847249582310289779818259083630345427337255960896766203043455335894797786980608848419608105331975026702045607659909764116027289661369664795559011503382603816675539847618267537615315e-19');
    T('-0.00000000875646084168554507977167823489990902563799552509732315823818127203671896010029263145066030926978731172618906161505494', '-12149799422754916719269147530161643795542307713126182634497110622412638327814575847624536131684703485487672095750214266758123266193160', '1.063892428796870678069788900402015365706552939454485642953799687841866869693207537469912665183234951380917914005709858797891441500773219383040079223313752838870891947612334390210947680627998406712051291289215921823307231964371826198854050237980522104e+125');
    T('72132913784335037210708416954845481013.4936052396', '0.000000034758907396517145945375764660651269929701596542982929267988814344071126980935379146949580197412941449868688705948558', '2.5072612704706567177369364733761303227157324401681208246105574307760108529931727084685203750541786884736657231851778565267996322876935570476425834209668059168644968e+30');
    T('319.66733043418522086907604142851830292549270071301298537533804754923073658110499293992079580', '-151.725', '-48501.525710126752636360562385741939511370380015681895206073165264407033507768155053809482742755');
    T('0.00000000000000000062968826433918348928022932804766807886926653', '-0.000000000000000030428038130246925313880152590782914692618238491169604901884578172392510096079664807819', '-1.916017851748168043720386562747740471345349440563638610201143130913848507924678149083014143799108415035645952111410793293793899807e-35');
    T('-1180774887.3', '-1449.996894078842975987074068709452557439051769626362706935102826112305930', '1712119919191.295852285533989737156299954793129899433988390218967916669531638871689');
    T('3647164297747831538659156395004173038414109110759206277814463425856379161036312539485631.38948348284728053244339540610363604645614853959905', '-44392.7', '-1.61907470520630161146234332096501752442406021521200216529134130525014483182136711671623788583923408994470492599919244536883919513865273858746935e+92');
    T('17498312279239.00932701739727337804928343115988922324826729272279616797560451780334324648186406856', '-165176662774787477578875.101155425022270058043785237734912330043953397824558634005249868631913924077857553397476499801921399000', '-2.89031282647578469354264890469746211626219999574969073812160564852073608013566136037691524827633370435651099998507837807111037742964559522767880633090381980310349646177225049281653222840024159118865374106303342746711544e+36');
    T('-0.000000000000000000924379194701874135396133614362003093078303247619775269472734328426147105167965036903810455485324946', '-0.072771076651632335504153815223990944', '6.7268069232824253584377498803810917142357774490329000970581887327408582544296355494518772848722889546489345140622499161796902801289024e-20');
    T('-120631710673724347689914070602312.9151429', '-0.00002802807358811', '3.381074463822740563254319054484144416394255156390919e+27');
    T('512196210721455510182901457014276459874633282215822699880063790892256101411937345231821904839765586258', '0.0000000000000003806505766975721', '1.949677829934332018345035402585815281370286067595371424284055069028866856886403261381419605884609510991608281217242018e+86');
    T('-12004236887475073738586111006769029393080783935378309149099727.68396298775060968922', '-463794927584484417474190358889847435118899635706815444621012022509301590070944948658314884349', '5.56750417793349844330521891159840232636935946658560169085150684088850605724977314027337726117947637117197173970007342920606127105666878224551145677898907304818177310313201778e+153');
    T('6584641990290656838269978401214918847381615636.518803901787', '-10753941414172447057853743167450817.50583947377863062378420539493289850486515772906013498800287501534', '-7.081085419688558260857966029738760695277290042994837834892489736689162992602408154398193125842351999687246222800816463918193016012785992028984897208947841258e+79');
    T('-24326422199657762368640227996078927157504200019578797624814562110060901133357274750788.36441683868312318843748', '-0.0000000000006902888661514497196311777408365084768865919183378538264433157093409003947610911', '1.6792258397723212195313963158909185623783542066080048568383342089993434418422010559055047531507911817998642508826398204207544200195899037683811355076482082358044434397074053955290508934428e+73');
    T('21501938889227442926984999198582213780754593552865516434.28095561', '1275573970012590600214127925446975918013722828276558737918022879.290868107247330446595401054145784513619143055092036112746185085177017939280940668661320', '2.74273135518999619237055481685367562157141441273837681617196746425111391922129347808060414256695769199642463364622072974665066305632558241309767154727027823910405233929660720731520333952798686255808870704290440052e+118');
    T('-71541409973383879506417184487015218354.023574350361463350873760009451721040985761853384121351993525', '5992111795695111627085788865.512914195836892777247907010', '-4.2868412658217344634387154093342340829086139811418993420175349903462119580242132265078555221121329803402221988433584258370336736020674652911879732211025e+65');
    T('34142255447580822559151401211062905510', '-263926755678947832441215581540094557891886476037097583650654682043897799149499355822112508751738221779921998856296667571952006518196822431846845', '-9.01105471184188942905690908904627239542616349082031787011252961375696523930047374090057038095264861536129494798476922062541028503074147788683121044719759772706042769498406102661595e+180');
    T('291910578907226789405906209195597276379329314216442687970828.12263463390116587613', '905766156845279032080418309.2899374863460', '2.6440272319927938125314442437268631851150779004590992519957935351389114318457620877828712701683102714405409392300232098e+86');
    T('0.1447018135289410248822059919088140128370855413338568649453428485887', '-31531043177144606534540520126449707592.441165834043265865498607709043737814229488899678036083217728937497668745235164920031109748', '-4.5625991301921670224436171827297160639926118138546258979023381434676064727971907159899790572618884224647144712250542121029109924335769933935852618344978968520165094454255764789533981971966126476e+36');
    T('-431470847375352240973824243957438268864164144677055441855.1122835808', '-283926397264833307842262874592214804147456.35181960193341', '1.22505963220088520133492369378146202611227577382619697690196693448533411156116335413333343159557018405513846376263877954528e+98');
    T('43.645259992317026943608411', '0.0000000000000000000343476666438615307467230521728116897722871849771845212242115930032028373012984891992888161271678789193222138335354663458270965038', '1.4991128408007717160640135031205392680494419814377001223461964538550601533847575845289929527748139763281076549960076386814116184051973077956967114943734618e-18');
    T('-5333642642837544.62687709591677124286121489157762662337705954241856563514693012115', '0.000001092403520420007654847736885', '-5826489999.69800727677170880845575478173936457495066350494224786180067840981405695080871119365234031637361775');
    T('-72389949638529267084220162178469797619868037471866853897782590886837793391170450755475695445589382444913313865539107.825554816619359474078198937945329', '670516724101646254739075469170811171513447894797271200380414002599176331305558057030387883188608917', '-4.8538671889509795604939125299480164673783805114262471410372408819538068738391487961206173796503249288962752085213903270623213542356008521417558442327238499890085384270939054062390701273409174804755549787657232352912465878135282338593044925707898693e+214');
    T('0.00000000000093389590550371354609879546798604119093458584514838', '-436244725.94251597789915707849842497816062786670486162986', '-0.0004074071633553053150284952158066178287741661729136343492697908838085289189761762237068783682124527003386268');
    T('-210380536819319.64260798498975775170296381658684501981152412255070635544143685331980809905', '0.00030621239427093550265058736827171066633126148745977590497591435654761612693434536026517812303379', '-64421127887.4485697052582576831125251079439300578331516148925455276348682374579663836142871112701981303186673805005030452875519450671912320654524554714586680026745270896999533988168995');
    T('-2986425419210684489372385430630802680.1700076164378161986', '-0.000000000000000000174383713906052937878565432107027682509555072891773406016182697852642942595757484268776430171027151127581004748120018091764749919908464469126', '520783955905400215.3593326533209447186843411978634958052248208818590205254321998670705004791818240022569816115585565216755711284287526937950905747371255207376455031602089558157107952374519123844236');
    T('1005275502281605.7203063810011538411846251379520165504332670989327995886451', '-0.000000000000004001673036573006142766297120381368448210468914793665305672717', '-4.0227838718076871277132373250062298425694133513895898591969064598434150270288761898553450928567831052706301853626314400639691300657367');
    T('-592443055123445281554039884803217796883007011697299809752867837', '-128767025696067370042375219001771824840953470096164458063850.3083988758376157095926583752', '7.62871301025373359356475793746178927840450521702002697787427513491791642079585760593083059843100862890831979506992101025525289259825474551988167584424e+121');
    T('440119636500787798119778.1614067114799921393251', '-0.00000000000000000008016651264632167527854789402319094526310291781550499853504152970195676032634610434380960951927984204641071043406830501', '-35282.856405434903813597479779632705556601606542704671605957970152900017367125637334582859462287579739167125492423421901400646478981405910526064055108265969922348751');
    T('-71579.2', '0.00000000000000993906325920139009275587686844510659032911932338073755273459775736935248889756221559252800727756986462003224559457716', '-7.11430196843028141727391461541805973650486097872134489434700319794292355673296385342340680738522628853610212113863357451072e-10');
    T('-0.0000000000000000028252704404880797079738', '205661433462063.7105307433432819704421946280137966217786600779', '-0.00058104916870877463514486303435785934208231367367250497766551677412065596208835915902');
    T('31511547820580.4394382615198628132988414617215767834965945746200468417564092109397320304169501963915067332074901099286788653074716563043835', '39899961813398664937157171453593.90023813309746209966498824019924844847011387015958705088743565647183663555197208597527', '1.257309554722245458313010717601632793452987822633399487410911056875703458652204694414418020975982056391949850738256638817586034701650856414371301609334505840392336061143829107090319885694135741359164686790967904196966939338727755954779566674337378573596045e+45');
    T('-495789074385555943868529017377472010212654135435451505422731855063537551062677555928072920281877990746962752595360995056758586999317669647', '17819185082774026694204023148577882778297684550452324826832075039839807470403992920788019844375217029982704245209320846148492.201', '-8.834557278493440769527646032308030350371362475818934570787903683344802633346230326610094249834365327683855191264428319975098552784711089348596608431374093713258545096383387667958040878506159831317309788540734024264316478718947843168246822604530057437227626073923047e+261');
    T('-12262785235810622775007408988251878393679277845775461370985491116596241792393397087453508079734404478228220643516598880369382712979645406460335974', '-17339.4599485985180854570917062071088513028304627905849022429965380282572583049408147112553558507464317495273478217946882351121108297352639325', '2.12630073454603527661886448347291489452541354119893214674919284918523671819041714914484722504179832434598604666638655329939148126697219715586452788601752336764716691015791681243794848208962144155133293203564192719333981843088873686066209217435640467778541139472308985673249979514457755e+149');
    T('-114396868590854104192672352367580744901653263217987528344911658496559573111650716561664806136683756515973087947398968856550342371023724981841598828474', '-0.000000000905511055947334', '1.03587629274772706348234847002960858371371655011375374225792356944117914008860239779411591084427150020831085014159874092768298943748156678048631480006184964643588316e+140');
    T('-1112241862840106360548102452612787954701297842442745550953310708233414570014516673446141946344195030870599027775528597.64281848005244542515', '-6348759644967567183872592130062154839790.5635484413196596709331464307', '7.061356254242819213528914158861347824577247501609657702110667409707299733668207944491015232613785616142229000235550257974209644089293373052607176525740858805900274429133922740980503476595397297785266512105e+156');
    T('1108564966618799.684583511467562033896416379326883221554515730782746395008239020932004268892597106459172116648365972554761', '-980241488498709.989691822562361049071', '-1.086661372975934954665249154869827138993085763955003193792673025483663764315894189566505244862737823287988968852517424536981368134752599081608376589955677031e+30');
    T('0.00000000000000000002838698369819955658555277373271853993941828559300730453309757421421453', '43513833879.28', '1.2352264929772849320906997234371440706324351943721359734528135469244723396680419384e-9');
    T('-8511924985976613630478857403041973777452.09177107175699163666864323186579824676938621436941711058306956193771462975562483458844', '0.00000000000000002272278230386744849803445244424', '-1.934146184431965759189809035913423340545514889094246651943997790659345002151610321611910790026540789359818166350027713628491983499298272486356031374524485856e+23');
    T('-0.0000000000000000004316812723968992118505000444628085260048886312014882985221720513162602276841485038550245898508488835', '-76290177257460517.999473', '0.0329330407898855391252124225768438464877945578562524623859269076191844422317697448247001533505237464666728778267802556383955');
    T('-315381216106477443798809516461.945916162611156190552321997295114376958046547275354056014333919065425673748199256144380585548066158378662409475843035', '3589.161838511444431440733729960263707637958181400868325358533381567057455464602280029192715692411789833427', '-1.131954225432699752649141397708477473892667834397120107511962996304791377678417665209758473239521558381343101328776946782981992193865294194693770979873300748942276223781245879606796533776372414124841041914736508348886070269056497656762529089763048130945e+33');
    T('-429554289753358320963153203206734665772198736780.45185520786347258238318355302967532112035290', '0', '0');
    T('1463451471384605194456038106049436218092078691173664424376798273282402411629304', '5.34145410132810384872275111495210652002710418898122721083801583300401806143614616798518502693357282268142295737452661760061198730650979349477', '7.81695886392194762437336924065337257968714608565726584447407244448623703884415455226257285276362586454773057274509044560620808790280438685449822124417639104621469226432169534908781180559594976229125827018100297590274008e+78');
    T('473586353851131907618376944471474603970238923713969727224418527992189433742423567976837249481727621512554255639.8', '1286427255593.352272327514643909503984179320306560931658975694284708', '6.092343934711738377612937734307383870923174240356564095828149119059002227331699554845917346771273434048376444070758413332992760270463202297025312107690635975666422869160358961784e+122');
    T('-4048155812027991860998261874719005077642504207127030646327029367933424762620898655788666633040116830297381192885448334', '106705036497734766140329279268252590446.2335278949', '-4.319586136709639909348938311306692360922506424385494354567553905770000978932851239614330898183516223949738019390821277918151726982015490940436949045524065702817320966e+155');
    T('0.0000000000000000000915543732852883697633526279049753860806942872601198742215774747341', '-34152105784317312126489961356698852045721114680628002017655109882376030549039796836.83153535701271122760014588481469402075074299376935', '-3.126774641456043327979536556784366250157747125357071312778820430770070528036829464402201655884092881178626009467738410063014596140203388175163040146059581509034963217801746892436203877630743347979835e+63');
    T('0.000000606056178575650297523536090137837690540483833323054730991196951139940145168062878729776556286621722228058423687246723575421211', '-0.2110854059592627472281909321180610299910818145371006157746105830582652226002916315944873681237089216185278265414045060813822588197350141208020650990498', '-1.279296144887605810262234886377441922843377685091005337867319233708631851469414819167991307615079977909703057135546912192644428529187862612840717830395670958420462971297341460134768276466347220568187569616383072997479301070810241184256490139848082355340819140700544014708653078e-7');
    T('-0.0000000174023009167704116970725301110863248980544485359112331870888076484651233171728545', '812850723207869191281548186903956096.809765707322509394052629000163', '-1.41454728856777941909802731675169558153278554336163713719217823280456330004090313022045897019660317794534957404145735837838652198044782601796752835e+28');
    T('-2130698.0548286272900651895094179021589945303831135867320568', '-9165947089300259943733983387964594800521219964489263104.59571046797687349727612030295852399844295170184636', '1.9529865633834181981295933885978264475195798583990822467641671177002901506455322929500790695192903123945610282587760480932085484711958893867394353314006055160393248e+61');
    T('-326083155399690502439723947025744049762670117683.432074400669883911818553035189833194671636060400687941284537881087120570924444', '-0.000003445571861995590614007298331872337442294157873364826604749208387112491508', '1.123542944915909132217079826299777527201239718962104484441084589157856017183525173415387994466036390860102540946603848752279383640837621156142175767860780613378089921458710577851612660512939659621552e+42');
    T('-23.2079521420353162165629346282760720426054683804749740406', '0.0000000000000000100667680781319844905727827890837263875737788345658863306751556891847753254997696006873526462699281042889508598121471367829087954284592931196522647093', '-2.3362907178225593297823553952359877724440294726489222805197185879544455403490267478912169784494515330509275220029014923616029924211711606761207039492261868123451812767302600437565610895313205736991700539758e-16');
    T('2285581244840240639260487167234266.6210924312942573974763401176849472', '-0.000000000000000000918107', '-2098408139956538.8125895280916479508246913088182767764248101964273738189504');
    T('0.01199215867887013759356474044', '59219069282514349738400251796939074988014798278062054247507850372485277499304966991398291720701282976974931657695.89320830399601932636241718811893409', '7.101644756509164313135142859363774349015749437363131851507359602111507670252881439883943580721027909131341909904887723338723647408378876006443896747938535856090800949803175996e+110');
    T('10418927567085948892137885878723808945364687260625931932.039351', '599680853267121291448.38087680537808199', '6.24803137355843394317878805129936255762113268577294303839429005376139089696541797413362353758438849e+75');
    T('50831867721704613054022871310081961685717811744979380239875687986166840752637964249209739.95742211098733326424751917109066551862656', '-1632931078636285445774108746380428401452629936953024735101', '-8.300493658790009540471378875888368284941161669991237260884060249140601673097481745352940033672506184736998843139872004445042382050600280557809637308250946613651294900726384303212534288256e+145');
    T('7100289077488660412990.83', '0.842207839712975032430755755635', '5.97991912528935706872007298550620521929833614697582705e+21');
    T('71.01883', '1761970243586301256729933.7274571136169644922999518937631730701127745550670073949565808130784043676096', '1.25133065194314119280489519301543084253886394686592551344848526917216954629436791164270145276976454523688768e+26');
    T('39875156712019325311551200466142836628229123594325201379832637310133453471608904683559565236344258.967154811777952228563', '-0.00000000000000000070081075140934755506891264428157216975205610555238498806', '-2.794493853791575200615635819282954125975165218925920550666607458660524754995294291334846227959636949211292863866638640564674087684191891139999119222389967229521626102314595778e+79');
    T('5797150130947834056182621078494110956594842841052090075870166233975375056203178648058074850906399043556974734623', '5994943195099.1328888761373637634842940850229730116836324780692494703604483', '3.47535857284937649148307887121857419057110304246614305622459943600636593236940298049819575939494986921577262671435104495090825963819204860688181879997983293665235062953417708960478114909e+124');
    T('264016746346020173260674845542.56087744794671212', '44725565833116388541385131784578311136952.11515649206925514017678106974916075594822233327402018434035090', '1.1808298369744115980724840684122092341038122639077601880904123414433464879079693475998082113642766387031979298492866976697783365167381515796702082908e+70');
    T('-1204258217830.1047572987899835756536353', '3745937592881714229717990115898213651381593777161096717540301831660255825874475111361207039098321786912324541172077464946165364.14390772997939018900027', '-4.511076129706525686579204142051251397641532749272813862145610194389074922134315457597697830334597270566875350716009107169694204547970082327051675594936881425342543316554216670569498181531e+138');
    T('0.00001085056051858810623505714593197033408403035596225606886953365', '-392929408749548979689032253667965895311572351400702674561774493496364595721866845891578496858294676481040176.798243172529157', '-4.26350432917002414454392491493274497473851341095485596409214868708449409899775190195407623094650897889780302985371766392684564356442617678251382828651108441963579450892957153361763305e+102');
    T('5029414448475920188151028145401135310150737258101072206698406572639528330082067.9336479422747818663155268690086170021619688524908875089697158589347416', '-0.0005229224526200471446836303862066185994349069612658407253355478392257635933309390353751513396483385196163571877433495709051459895367873144796893', '-2.62999373863972991595232699135390284144005436661268919696790615365070651823630721931258425392749116101462135216825040904659228944045018325148257573243654477716244945479320745317393867583646412220760107366403103406898337360145950155726573614185125610071875889949474494080865196631936734378488e+75');
    T('-0.0000000000149459394556759606943604866160845855165524674884428420450005789266873424201139870021367301867234201955279838923502786908774569432473681039899', '0.000000000000072681121445777643724015525', '-1.0862876406992243098110834770746303342214020691767313742628853277726465868820586019765285955443439023247300317509304826500549194884609623643817234580349404842020431975e-24');
    T('-424139.3397723', '24.9352665519292948435181504860531561629245676859909123534754923791320492627466971516264644236625241080447', '-10576027.49238160664772089118930618199418545494982358874950081130097372753242050309994330560576035740865221100909622181');
    T('-6547933974356063515673579783328852017212683547729632232078003886270959230998276343908132763800852667899598581090407618744044143894167068562238.97', '-11922174512798027988.715520057164002099095961564815407735892440769625640988450493600253780499938690761112753154279778415248891368390538551750986', '7.806561154055215663901405645925227739464677757390641017715015265801022422067920560519544881469304761133200469523238148889436630472098386093418009954492665836535393992406767441416546896285667079520157050657599018677219464362114136929451396800416962537931259941624014093037081081406512442e+160');
    T('116971949153.5479374797237476837460980054925', '-7392852461118226343653879737274414841079276534234761286995956308826140702012532258763158080532', '-8.6475636218160290233694135116834390249179472139880806248404813419843222333387482382624808997980446329708149926437827055618140989332201e+104');
    T('0.094736370343830975556009350140982661429417188805833955451765939740836399749318571449220541572349173464405792553494108387767327206545387797', '-14063088472465823296636520114.7840889695829209677553679799383909290850887704576208141405158860265325506024127861905793354266036', '-1.3322859577055824770031704859177438035519692243531107997889353707418395463470343576295679587059797728931003195157525260292910231399354545892908442725681827168435407603526548235032165419174525789568586355685792534406527613767949403942954190037378443595809925962692e+27');
    T('0.0000000060238848102401094509085687708934429831403505207577935573', '-26397976144679538690.6353645112721463552724006844', '-159018367519.01583899352216272937345079686163173486566881281209888168576630569925947787199801314243061612');
    T('-3054832823620065247866462699675075655044.24965543051115834991093974', '-2755412779439299724.2984036924450889829105682176654094195240144615415006313170056714410711837165723063574799946207221645', '8.41732540125336804197906254683195597019539860395893943850239114957397624723405493043107443806607146233611284249167142426017200712427976573775245903141353510518411863114852845764186723e+57');
    T('-2450974019399956698469496563794.9748364333942615279874848551026505204635039431974104398444982010445818729382963397261226755940436258158321945719', '-997.24040302293', '2.444210318905143470429111243581921471467515949023475365592695716839122688195540502841004451264728108191685433698308378621706762322759533121835213000697233667e+33');
    T('-1593.003418430705083401260653839458373', '81482817738806321636670141568925456324894595.35515', '-1.2980240720128456541718518746184368534776478125249076285377131164060683232627757617095e+47');
    T('98261907174900314009700603815243346086200.8875197975215499156', '128758244401452895992559910962986981947835519218827223291426174867182696533638857.4611504455387701659979843027781766', '1.265203065937869250805348094516614652285677394459393456309889824224472248261724047240316582653646970392779473698285791164886759948690959417233989768983784053494623305125189496e+121');
    T('346496136331578345.6139565562', '-770.118198136243584727', '-266842980172845321727.9109640073233064983318371574');
    T('8094462815401859042799401705641425818247198451174542181431184727369479972319.283362207236223116403463114800998274436638818181016', '-44716739326169.50679740', '-3.619579837016970552211688799002785780552856029741836983454305219747190234820032824275611045529918418220339456506414179332920358828891256009156381584e+89');
    T('2729467653762704.3220008736708120084460677187730093661396089914034', '-0.000000000055233920094409680756264812311791211428686742640081962817736283081966745025774163718774682975', '-150759.198288205079331338550122412955542882826158428646159812354506434469254169683873619612365382943072278940175544745711284510129905967399982740638335337115');
    T('1', '98776520222261745669591551900242713389385936698028187815152403272299821654553681210659893142881686053028403096887300880878591448.26475', '9.877652022226174566959155190024271338938593669802818781515240327229982165455368121065989314288168605302840309688730088087859144826475e+127');
    T('0.0000000000000000576769268158760793228889322171711548712267346092999553202187549995149774466310618281592827181436884024', '7214897443070769737.590335358131669664171271', '416.1331118080442374873530552327247807419822048775263491897727868156732966268031408562709186237110762022701532092252726416209067252838924499674504');
    T('2563816381746605865113037452511580729789619725008213300126058517120912912629866105171095179961598', '-155142400902758369245790224073470757889134578664867029684200360213407983500899972118045933740420731880423071611781.6961697019774959718821', '-3.977566289379913215989211867005456529599318466838788807437369058021539398823672950585044348343474526479765303904605036245529631372734211590112787398817987454064611577927370338439226841015272470235504418419674575665836030379657835958e+209');
    T('21021355066083990352764111626531024748686292365672970531361459847295.43100373125999514720142962920161062', '-8692703317497385289852042779299.702257622199418950085745', '-1.827324029212387699226954866895393730056663738212949267989848701641289722199007782369745673635690581526275165825369689624008225949130316222067517051411026119e+98');
    T('-281371829459700411922161394173847749045', '4262.059148155501', '-1.199223379781965638825029107725389720131878012484246545e+42');
    T('-0.000000000002953739179434260253787432770866951567504749973', '309547007791848826075373946352866230269769314074366092085025869.7201225815415300560895', '-9.143211247914261165868175330266593984659858074863087669862336974871905611291966919042811817692587876933585012091675114363636105835e+50');
    T('-0.00000000000239144278978796819150765880370364103148388159945376101153092134918047349666341937807866834', '0.00000000000017790542655638507387717413464523193083130128517052867317685503104374366725848235452275428161059560313199945661107215', '-4.25450649602420004053833718175053649747723590806183497288310789806254330950196751041980603311711723907162265791776589017621131644531690317327724762991500539399348391156280420594867129685071798617771660731e-25');
    T('-418172866061503521911971552233519656327026674166049022680423475766548238660534576', '-90576902506171370108917411667870811129738963466006966688282481517335876800502911324072307434897211522733182430116410086632830502124065921343765439120', '3.787680291997906303359954806060523264425173800836418334594593478681399250024197130234921086970287168083653907490426018256804158591064373885502948936834304787910451280809462727218951755689222074507604311322831439358572513258301312e+229');
    T('-3430311267169742574955929826622072681758112689207488355884200258692448298952.3897753652042205852531267397500939984515487', '29178195104748190876234156211954739009200852852565396294', '-1.000902914234947463302590931129086303752468365453949881103219746142108956587996112362845161460507830640398391094393578265988318777026054838820693518977773210730880397735405178e+131');
    T('1217229941749445.9572811858261781662798606', '-7688.762839498170', '-9358992343247662165.263684546710966628782232475881555102');
    T('0.00000000000000074169408783659430746120211730010355927129635815598173767929633977753817875737683684742368617111968470780652946190285273916758224772647017665583547211', '20277751314053396744396463.85165787361341700070969293684', '15039888264.2541356850348902729846895882151710461905734702387731438442631412304238135592144651640509390778276828843359389845898882091777630101738827628755435200638106447703368100930825028533561255938115324');
    T('564381466888810169919601150245392062064224480660735222387818244250114897197669997801703266070021836470489338410440', '-0.0000000000000000002645655440014235375760091744435849282689052519875067111364162666736597818970677355465081835', '-1.4931588981175946834283111355443773198028167610654600849890869545798597157736617913162581558616543097793344871513878994482479287199763866058458885636014581139878719012494628251898131796309084420634183574e+95');
    T('0.0002901387540443867013405807910333533336446690397588380128405647147868703703433303126537291208249472115', '1532908562403392492424723937748.472475940195350', '4.44756180359692297666882276804364242887051626129128210500015334075754912171335276467442794092825498742382966447793841999956236194956994747766525e+26');
    T('-0.000000000225264190604268810784537320407445', '14950.700814220268672859713833679549117660443531292433032865528784491376833526537556454874844228048068717928075898239', '-0.000003367857517881911505578414004206612694308367570237761083545225919631139495505710310659653325677787421658102687518302736419664735602327222663837989355');
    T('-0.00000000000000000132422391255571832661986637', '-8685.9441213328949678022978068', '1.1502134908591787160769054777064094203031244635960077316e-14');
    T('0.00000000009742067142157691787222596751006921098920279989592268344573189495144592', '-118923723014528400203978798877563012809910061320326.53737153377573592386', '-1.15856289440289961067833399896083071996865135302176383556314783677919776746205807113913241561786412522310269565833727285343010237305940276512e+40');
    T('-0.00005563546373241014529561050614463373299027558680685062277259553861178444745012994288955540119513731389', '43565560449530398941183073235722526166955055524605404664121285806765679773941818978977694475240560247441941103738049224883.328637095', '-2.42379015837197033639269209261239035396339708689516443560833885654548577622441367344082188020100430582832598711242044837458341177912171781239207907145798643930933786640347757166079449567939368292304555736474640815549897983291274955e+117');
    T('-0.00000000000427087426712799927089415837629262439038369512842420608188380156879105597329387384339607914876727209877963249157620642500', '925233928141580102390081693311444.71', '-3.95155777477363086022568547662201291712827700290280460065453355510078335629837128123107501594590100763786464243066847452995303895192418602700657793426175e+21');
    T('-0.000000000005091071907525480076989317935464438083994221617598954017569512203716892574912245558148612628718382099960321042186876280738556548120017521', '-29849639725760264066839307790055758277806690063171510919436665089162295348507536342284533528662967910860808922458810578140340107788205629605', '1.51966662257574655588783076840748333702840299074683399397337485352697121303070516861952435606970784590094155132031721724526937976956111602321500551446919936325059565949482713352248442850374534543475972410515760725383665948678467615176539411200064096625744148848636243436309205e+128');
    T('-2532623712961933744380270221514261860541083273159263155049.929201610', '-0.000000000000000000012646589646423131239682610662957792721023875661746627573361000945171', '3.202905282663009949513269540690749564425465035038152243969308063023239476727318839202045865432868677151160472201684195600784341492531e+37');
    T('0.0000000113044864730', '0.0000000000000601669081479195180359444266582823155394447964452777', '6.801559992803896747300132989382930294307713993458802443785521e-22');
    T('33142360002065196584755139040522165.652289540188139925590361076693810562392719569608216426237486549208210658659065', '131866276226694967054888110190126225070936217278.208055190299743946923315513586077993', '4.370359598836895991628989736519636562344422619159613116474448702113850541696634666515624356906681122560009861221133939297280288166624498899890285407603655628297984634754638006796334523457886456545e+81');
    T('-28271980269206475098440832341.0', '0.00000000000000001997128856200158301984619314093468302232590147010149380231144706644261177500747535724053029495', '-564627876175.53771205568655371502005478701323612123758214517745046808228380387390782642610030197268449800392442510422897795');
    T('-613824085218213402416390718799790910276979950485725176851655692450022488003571999524663227579006467246542215327798466491629903216135', '144351', '-8.8606120525334322852208416649468617689392332832564915003713350860853196165803621703384661564257162553505615324783036436533268159152303385e+136');
    T('-2.6', '83102555490369.945045038594374940850', '-216066644274961.85711710034537484621');
    T('-19356482713244897360632880493785297953636172550378939890381044618408211766861486580267956414189437617939.34723659706434', '2096663623111671700117269467244749170.87006096167689688793276499897977784848766593786643930915441409', '-4.05840331762504879192862674091277246812216284989188033185403840621110675874956150938505763166302102413483441063564098934208044556598498878291756337336898624598153836135376440509322121089075137894784969112914467325506e+139');
    T('-0.0000000000961833377275620802044513471680247526397846980939658945385489196881637745633153811677968300170851695260551929219', '-0.00000000000015523082518616051240657860119777317366287857462125986656514276221641140341472994194237', '1.4930618884608626385191111567704817106628003163415171598035214188415333416493921720574942746386069040797685559452034643996408611374739944262662458626993363351126829421325696180467755211836761710903e-23');
    T('219117317452336788720880703911762541205752470989076742619261301626536476137450009416861100269148147444076', '1703053723960030665485934204490791810931377645235473549551623.9346390876850553262664923156', '3.731685634713343871742198830618170312603304239495468980986930004166517969952154798942905166375391398101794403344384735628903779970526327721072669544702681593941605616683824986240005980347423856e+164');
    T('-229026139172552757937028186554164451744686.4623797082584117720', '142692877312662716284497225068488555041426628476953112845882495240122781240223136406046110921847532189803193193212616817958104193853628', '-3.2680398778341887238160775782128956864982778025883686830736123355786002576636730049750417595903040868869020303794371246492434867047430164188551479071257052965280634450368893979035874971520108816e+175');
    T('-1073665452168840118738785397447323896819780779969711513798521784434976119794308932309275291527935867797575529606291327909398442666759773299', '-2201739131.40829642230910815', '2.36393124008131787118729847898108542201223436609958551819420766250456830353949023025701558031680369332682327153434667887063193820677205089342493716611601619687328685e+147');
    T('75900276157586733312083235.382581622118846776984080849994704930212640859922732548092821867297114657673701742587369980172993', '-148738026482687430520904431699391318319406299324616632922', '-1.1289257285170424910960307900697967942479647538118082242484827272252207217650225144658178111388034339556050832590401486962625381452243039292709188298700811929089250125886739075546e+82');
    T('3674513449.5', '0.123520835051992626211564329410225789797398349299387483082158104725685223328601760497980995245750734368030304555231401223', '453878969.6920179367892193608523230674423001146096982086973436692999598612243583269792089846259066311598292369117788993786442487385');
    T('-0.00000000000000000003630523450169119195624332326712988718220493077008794952403238435717494340472630938510', '-63664735097223219209774981628599525664223257757965282787982134793736977272874143846.500', '2.31136313719273856014857129786830896070271022062940478374598697364961332865316791963355096598256182029643618880489361616574337962520294943300606808278625781284036378715e+63');
    T('16255476060889702058292641519175308063089604.27385206453835321058', '-179922219665363.16403587084722191165281635104378752030512', '-2.9247213345924492933598059283240736222331848885894205158919467816021766897744680020212514605436690223674872782932121696e+57');
    T('-37337860121811988659501056235845132337764643336213883612586814001890615154275803513.70825146506875697717604166850546696', '-0.00000000000000499312215357184649280143043628595160134265705278153950603622340397592808084159267174620857129590490362315100615527713253386', '1.864324965411862434361080737439842005056233440510613636437519526417257892974279749554865180460594721444483260908377047401237999183242090755697516312142757552953410741754553786322115284832812113468103953081138139580969418569870010178873112656e+68');
    T('595287249.54365530407831622115559910904721', '-1768420334499109507714731763995306162286136171277649865409003891266116172008027525', '-1.05271807696104578648763801372031670967180464094032778762503630348461739223752684712175511968739692938359619321797420445525e+90');
    T('0.002815450816912', '-0.00000000000000018862881579393125180980026941613678890399387821675560344766145135638', '-5.3107515352016691075986894697522001159488606156481160553297195685733162144309856e-19');
    T('1746219149830810782027149888420786044489923228652389093.034680474110962166857959336903', '-1668828010190656.963346733783314', '-2.914139429168972634501569834110127443990322655116665224756513968188822900984956290803407975336799390526947925836542e+69');
    T('64662722228212130661621650365.32166567378954381', '-151753087137277233145197949.129178182548659416754566676577139611814504364107493968621776', '-9.81276772083142891387388835588024421410101593988612095879269873008015700198765486880253915926871899215898047800746249703290547200656e+54');
    T('84653669316972.30754613548716676668630807374200076888152269704972414345399368365406435043236681022822051377689088018808589089790', '-891907791289670302078281451791247530469932219962285948', '-7.55032672250669035947286471317344472517407746317731670298580361066330532006715429733763760659799434857873085352566481727017961595406096340089709578771542056983935886992682102727092e+67');
    T('4345027127164155965936089847807081938532105519246471030938300717258607661737728621832645960975070377608443948838275506481065283884757.660457292004587', '-0.0031549860729161313643870355404353', '-1.37085000726457005604716494913217288695044606549706377095554606468800726719208784612404038925962557552104905114304146931613984052107356347854256094879310971318422341980712315767211e+130');
    T('-61520610530668063822131867448046406754862343293090074441673351607446445867575168630626', '35605600761.929728479163049', '-2.190478297185136890729555264108152753112278766935841211441225374439764529201743516915979466007768687467908938674e+96');
    T('0.000000000000001947822987703', '-33311862590868220285105571017136406095755495416393335802876470598016841787968672731566765403', '-6.4885611717696735160488683809368479132926370588940189388177405221668999878153400559367803107491154839309e+76');
    T('-72035384592407021674980.84729507555', '40650025408409173438512516280344375884605.60024427411502645869761254054503221638189674172185', '-2.9282402139858721209738248775767586249381088104728312874024564502752576950437939324991537671241774101883194117425137328357675e+63');
    T('13803733920957278337452274188531173497859274744002844428727547285003127728359.612974872709554753729793023049535183014700983630415660322292927376558448', '1362366267088885135733900716922.19506685185416683405604525950523770517636717536975000710349005385816611', '1.880574145378278711827375831194045930202239941319475711762021264109852456142716124505511107065080979058954130330974983743544175658555804894085980685328101923082779320611251686876404105639204387659101043361189777091188374895482149778850837141250779728e+106');
    T('99584230876132495816697493861076736200925464688036538302231243310765908574488488858315092454091884601410984087967.53071632699032523', '-125146154822705515.5242914429658322722160073394188945992631305', '-1.2462583575124528246919426619953914719378688358583931729348000794287085154257080128549535423454367290540927132043549939350598411440675286201751061031732125669579309586594569286579560542932515e+130');
    T('-0.00000000012758277143478046864136383313563417', '-16907614855016026181418628647663025463883570088670313587786762910136346.2239859700447043819351603364622', '2.157120361554808579905490037140343865957737705652239636688633884876362102934163912327493095734496347577324386761512911704717665571233374e+60');
    T('11129202925396407157427240475525317417101748679895585149981795954110715244429638119040083910255519563482482.88385201997256314', '21121732286510044978255138780723583329997392678716700.9365222644226293', '2.35068044752467336469513267242489085155640464226702784189610421069783258880761029174834312728324802606762609982209717555410045636138013876460541334152485164353688420275011580410260339339064002e+158');
    T('0.0007623108288892070002324554289862', '-85942313073979832197394484133961158027209650751540287422505752621999709082525249310360508378232261949707995297970944910223297349', '-6.55147559160812975392489905452196370592406606471681012737363795317578187614200614611166153102989166031105288845674348069177007346051710313415670312952762175838e+124');
    T('0.000000000000000044051571525227145682264900344291236843501956911752', '0.000000000017712290570674458162141325247384093633836742093', '7.80254234949672231546338647163006869638114832232612780787802882189163497793578826950951184776936e-28');
    T('2497912210234.005032121063', '-36215243145530210288660899586798506035608544499.347970495067719072170763689884', '-9.0462498049813268339455589123940089929239003754340990669581623284783162621680610224389952660876426692e+58');
    T('1502959485835975870623286636747688.63', '-18.6', '-2.7955046436549151193593131443507008518e+34');
    T('0.0000000000000002380492844605809635389684807457429719545734217366913382', '-0.0000000691300263175410058423613287987265961212556285556225346008695026090127373853991949000359920026136176879063299466975538116975010485068', '-1.645635329963176721222121671096715786436871824519931699863275362362108471140125039004626432868692100285050495434763779725307894808337972261206505074892100990010512693296587878317760379976e-23');
    T('254809590039852410310539126422956405351723766563016602332405.68422228', '-0.00065877273880782339590525760713666216419301807744760105200422', '-1.678616115050522497913933697207225162184024783104908394273110760014145206072260328917980848745450315587200941660750818259780216e+56');
    T('0.0000000000000278510475015254355758436577787533929830', '457360.858470081742985', '1.2737978994588698477266685597352939795610307887931308474255e-8');
    T('-29020220592844713119041607050693801334769100420291179736770161092227817.69', '21673233203860610976626552967575106778601581986955436993267108076405912742379179', '-6.2896200853620150098094834197552528045796701728777707177496046234367216918962571321926709133055901673078103556052889626187364066099134572001385766387651e+149');
    T('-0.078265485392684407726026843083593796846197554496715815079396449815003056610109470601087662461730977229533667789541208863921705388520252404620853855', '0.0000000000000000206254796419314596280180899887058415', '-1.6142631756326962818018348319288616709731477037044772633530435371256854543702769134066969398322149439228993616976959581068599334680519507769306737453547711855684460684428941562939825e-18');
    T('4795305568846848112838662002421291203736834738342747362288755835416190464055590424568070003158113658996255292.35950008158232661087', '-8285467911375377.9458513915656103724404947804473238339', '-3.9731350415920213266579109721401773253848863967652965582593311148492458733327726591229165001156155949294034378674742185027297365357231327284258441411135637685909564095376656361814493e+124');
    T('19117591065319548455532984279934187350039995069275770.12929477022443443469354713128796911998383266548606048053491', '-65695070326024876590276239417471386610369211243031736907459699925951944200466086828836449.27041754314379361686911712287570702272', '-1.2559314895003525759288047359281823933287108050703977637835742243565477054442990115080659989437373048015263572203486399172864054362529301399064585328306575664987751933695137203217341064876484312700608044517901164971224777248000985491231552e+141');
    T('-4449958.97652133495121566', '-252540313515710072725302657773.59471991586456171844177757978469637150589979632648440614666063', '1.1237940350627462471642735367835141315103130147959353855777341370569264164618648847956641021208508179253842679614658e+36');
    T('-1258441607483954377789927095378751802020005502122407.10214476628115698182122581797494', '80891657196033813941356884134762328483.27517852967702319172611835658583660879767525096710103201452929464', '-1.017974271138177784694027841372230917155036713620577632485672383505466603972062360612431726994977661204677518975067557466197345901755339173598338486348474216803531725823378534129113963216e+89');
    T('39808017028002860936031338217973215314567637.102901794', '-57902551664450505458473980503658853607888324171.49605292290375427619687232427940212558542266526276651604284541035424385620765024160046792819', '-2.30498576262326111905050241194114191659986825956183943894195202199609220277997857123964697896577008957095100523340998232771311496428225722320228966585150676608054417194697150023556808021417286e+90');
    T('-25293916752365259143834809987793203971606533992589538543882915368792362597533769162577303959554268549391839092976944430801.45', '-18870536.1312144', '4.7730976997543781813462001933060950776383666075435301423297088056421996528868308501593986755779476128550409285754930853295224839815378088e+128');
    T('0.6419603235395239183208947139633444062611507467701373727615510595813003', '0.000000000000000000017952483446429057318650827831163686139172587165173817840377201106607889427351733260566157112519038473019359253459211', '1.15247820816075450454750045127898262549290759007121217263958499250330256525778703472457460506113402017388245419660594286457976772844458813380078355709054799484514557844989901980643920633e-20');
    T('-7754484348993.123525069214650584107205341890439441675333976581900424068864364093826806102195', '-1752105446017682.49037253813167091733073426140377278798600289379784348182745501211856094498254897275180116436441751208660573331994338298842267191', '1.358667425892973493966955704447747036342266355969033025086821842915237172969178185006052744518082018289583598988482542984184766184862727882606439182799978323965924231683530282046591309550608146208712260753677314753286354780307441584245e+28');
    T('116204805405208024790396987614152308611917319625528164258053148681924874821595877349738878308604676525193568190095523284.4546294386699942279642', '-0.00000708667732873965881702012704870812130887887783663833386408', '-8.23505959955691471303838517278590066464473883263415152528959807184051797771275805894703979322626180999206021924871332410324136063220356505352392864892088775379405012455775331410005572958884177905936e+113');
    T('0.00000000010139065992977811728', '0.2823639034545530635547682690320968784587487', '2.8629062511605290206092872865262220006122998552333654430647536e-11');
    T('-182348440817089344.0', '-365494613346284385774359945728371759418255497043130583704938461995522713031855368282526623182864551158365546976602079453.8724', '6.66473728707398913969618817118679541450450804984276803582504571866881111782170812402431629687112708340501385877734505804826605490564775757056e+136');
    T('35078436593053772121948478354132824046030742485793509661339795486768350160379351940260957647345172644134739', '-470315326468850136120.98841520254693896261066046950478030733711497927705290819414286702121213017731741', '-1.649792635827894394262863251819308110416062211172951136883946185746058880577253761809396392427026832922884334966951567100285510447677219200061048033820977456094076440088034531057882865490348221044489361050599e+127');
    T('-2329710971489131138898317317972150487.226887180882642662346810938', '0.00000000000000080780934683985383898326280513685583649350582', '-1.88196229820427637454825838040513247697835727714033766676609406173243323151115501339627651370238022434265916e+21');
    T('1689256363719086734358832495291997380220279912721648779060.022015003200579854886304', '-2259059589029194007856573438.47207932659178007', '-3.81613078678819075313019801142236253002420775187972657992120430084415285628119278545102507880850081033723214556951631082316128e+84');
    T('50563883339463774987198862916277845601202057166416042879.417778572998829235141574907848222440125486172315940364098463976083652560077213', '380058072907244.784369350321644073081361404543907907939563914660519351353607790299736723712817719111414068853481728614572841297911762329370311135686891', '1.9217212060703343272665422309643023974471329394919471100483903476011902558587720793118211708282887302802938658740501486070477164588947572483424138819524122982371487252360991540904867150086111696239666594880341944141794568786850282040411150653341851298511444181398173001624310751914783e+70');
    T('46294959374709179919178793118885893663797283026751959408680198256485686362073381865322911852807891547580600.01450863642145', '-172254', '-7.9744919321311550777982238299005707271637371904901320159827988704726854186125883198293328582935705506369486748991706581404483e+111');
    T('0.0000005527834082142680454399157347331241068314235320652520705781207217168327100784683628889780310703', '0.00000000000000266632277268185128455781020487589646959589371419742000347748975254376924718637309495578143940081972955041', '1.473898989682390821841521121371414207169953198718769475649011583919402328920280159796586990896854154136491120298716299421424991847787084749540756307376833028770272042850712186481647279973624030103823e-21');
    T('-3018957351229289626132713890715830302577902789980653248950686120322288204403609991088469882148969888336650704961738500782', '0.000000001082120521596790393125823482055072836760853689259276513674877920764922256435650861059862899919835', '-3.26687570359070362516085008576334548950877338799335353420537013795825989339548239608169241156257202285080364129276771767713053661332672872002678878052870887315156625253726777042206003909947050207392523720502088481097e+111');
    T('0.00010578119530223846946702960127201887002317294288', '-6085787778834088.70933788474669577642209247160329424394222', '-643761905600.8247941857377235732296308415119494854462530749858584648799519132617834281892261058500803936');
    T('0.000000000000000039289970150049295306833630957794488396625415545568122904585548214355360114104351072386053992611376825118885803929657418065649', '-4605169823674888008751577292618614971794.977555723667587656862637975931940238288328992', '-1.80936984908094126427921442372226709393792657401598962039210959706690306344862877971519465406694496205108752617960289681246511462795560122095156580067059723548593631880883004929720338763881489190940653165995808e+23');
    T('2514613511.2170783808206929866132543988564534527876194954598859691571100338559560', '-1964495794114274085237575951315085841.361649436638538985888913723131864823298797343859193187321313839924840812597640408726788696766685', '-4.93994766660887745881096220582576848896286904471239767301554888303067612828309748777331041576614562636212559985704314683156812973279114418194558517790467846327290437698974640024899151989425196795301938022962586e+45');
    T('5799359.56694741019279510257555786015925813988005191176124258432699765886085', '-0.0000000000007231844570746320510997217888', '-0.00000419400669980343608737887111010110559927717748555612552954077474280846281811020478125660977836613228848');
    T('-1791068145886144126734036774645051199503204286826392100458612918035133189286803934233671078314145954721325200457399093789769043791391200626757', '1.902', '-3.406611613475446129048137945374887381455094553543797775072281770102823326023501082912442390953505605879960531269973076388140721291226063592091814e+141');
    T('809656351460719225181711866.1488944461227535', '-33867.144809805871082384828278160351409245109', '-2.74207489010992553148307158515078420513099421238160223165035288480514204794793834876315e+31');
    T('-15343174181682054141420677206782114884223299540732121123190447946670136382584737580470391369', '987099689944419071747444299624152052403106779038923393493086986368730055942594131963617011747402639883887116360086428917.245', '-1.5145242477501571458201031358834948135288567189066332534201297139323596513233299183085395688552572218144560229423247824057601351422866714799537508985833062886631036720671807768726086293443750449585213823804063258405e+211');
    T('-6.1499', '-14122475646217852912636972117760232196408460299060710372963438774127.30802263764662251543254158300069146620610278670238171347884347702832', '8.6851812976675173627426114827013651984692389993193462722687852117005531608419262963807658587481295952448020911527940977299723539499376465168e+67');
    T('-252103580004042401308.937513693319696445897233569009398', '322191.07259437929639208064231154', '-8.122552284638533411190811393904476674853317117242659440655935323513978821796270385292e+25');
    T('-332385.3378738577828707399978866231142878436743418042927022688847501694303446138653358154658874513293895263254386919164060798805928631172377176121', '-1788688861556141964646237161499263851038929089394372356769751862189978338244963495542562526495618342381239342', '5.945339515995442741438198459409608195257376497495695646466626108763151210023427170436149956435379334122608797739249630758718894850267317176420365157416700495312818386418495814195596242152257323833373715286243473836090341661932706350920849774582188152382e+113');
    T('-2460917323354918446645703674853641464.424607984385990612569219446652731606596614873511538897698788038533', '-0.000000019704561911223284586046679188808477807835576405248282475083383206973764355330345760276507856652823084974', '4.8491297756448881664126623064115779205015987535516032622595439441897517259719875348865351513634911289023687531425512745832163192476366584227547545673644644097372482366494539257564003995127411984043445303142e+28');
    T('162243669579467948721172981736248370537958026297935040744.847805681773372416035821372548485508877545367724814214913560686058189175343393608601489512', '0.00000000000000043034872397155', '6.98213561759858159315183613323524194776931640410698827712570108401602008047713604207319502488289379085249184148133416471274154998412862192528868878238703113836e+40');
    T('2942112647049268674939521727079875936312678683322556734336248.11424534652681157516904544382063913587308466251549871327575873372911717', '-0.0000000160518477504399168052667437532822966025370257875590966186547766187236177521021479405317977917073345500604689071434454454499836553580673874665532292', '-4.7226344275078632315398240344022433291786804929459211275348315431326149856316741173727784448214255046618190169485768234658926420021181206553535921500696882020342752168452799288030099975139315001872319829531828024996830308930197541236951052531735501834035920248180157363728665364e+52');
    T('0.000000000000085659689652397679263363379344304760754897339', '6.8', '5.824858896363042189908709795412723731333019052e-13');
    T('-5.7783188901971298313183550831107549667729942738531150581362739386230606910679155155791688758', '-221439820124804823862034700.57305405733456151859741120374945380903497467757168028277653394776910998991571631868', '1.279549895669014265673487530332542622307080646887562219389924149894188918975837243317437652487919487957552517902434975981852190469467703844441311320668017835940689319709278323479039083091077241610139944e+27');
    T('-2847941374822', '0.00000000000000000333453862751515460136267946372896613495219431745263240560720335', '-0.0000094965705232425743530447087065739774971604318716917458420879678503055240537');
    T('4600164782241764006590425774876842089865111591027822696582831157578.739719314165811327385420927586685826049515030783212', '24936677097532922790671460124317897120172195409691302414459854884214881356875622080300.40462', '1.1471282377020572147332327802533044122369637791300506227907535665141877615112393905214612571695198704856557157162943485152720303637986357916099145417183717023786789993994223448696820674347492278452767910323944e+152');
    T('-0.00000260679215621874990889590646697464210606210167340857181603112129227967025884261071747351602786622983212594677321781361453743686420364802073156', '-0.000000001556976867693202856950382092896216853975131678027766508144349094921207161', '4.05871508611667956997596806284421681761326338922686367392307074925675080478202951240305304779651248204530654676779205376458787347615247100101002125251986813572273619622642745986755165968519176975902222802953070116e-15');
    T('112005422206895581683067200.66464306253548778644799733891467497177', '-569288990012093221416615337507679289992168170439593101496410.0385811397750145927182473472588677939073196039082322785618764898744620304415', '-6.3763453684041663102425299537134781104795400180652201585238496486086184313570463723811857606393356939337147660320432983174726251428956040334352123843908741307666227939307913535913017213265015893136455e+85');
    T('9234638972249568361641387675279591873348137130244080421631134092282316805807483776006033822789591399832066971', '-67062258760784733815191025025646336427603744103904997634972806618201463866617680780550570309742758409129550780654178901', '-6.19295748319427746239309128664117623036037907234855321924344705389173421377284837396403653127764945278959634318829418910758542716822570206539596799575970845747768528847286120187750160040083010843243686852268940286480535647178871e+227');
    T('-0.0000000000000000213737912857665573638079572432586728390000134190', '-181285730.138353', '3.874763359064957107044461619607858392925857065967379726558907e-9');
    T('-2506504.0733758501826133673932299604035650762719626337255035252843580215290504920568908', '-0.0000000000000000063307590401488217267263854328109316460163087745601605669460055525432479875260852024893294778103375548445194197525199702769907', '1.586807332169400912551173916660722325707840899719608136941744779695862574081783246376975996756197880571888252763332023979673897643998859766655287848000511959009182082181258704230204193519120752866923945862251556e-11');
    T('0.000000000000000029191265291623096374212238517809915598918566680688197689722067072109843781983891539215143111679796529799027', '-144459614607567236763647582499049882580370335188691777.776222539161298865028936239380239788850306312227587059786395648441342513', '-4.216958933935126326569517318236903884107951508793088777740048528137080091324499213666957905481836509907780548281139659624937009921418073052266920044400057847392420013165462539973879514483989622402887652609685114451199224677961134851e+36');
    T('-0.00000000000000000011367487320425818863869979220926084589271902620348942087918357405316552888186055679751253463369024199347442851320519227185478', '-21839', '2.48254555590779458168056476205804761345109081325800546258049007374708198525095269990087624386516119489548804429988819402503654042e-15');
    T('70555122248707171314736', '-81101086022274692488621411837767361950248378195397909.200440873455379623557692889032043422151272310592459622568950827', '-5.722097038804507341200180488072549073313712476829304641270901056694148836393515478119400477210997323863769882713087618465778390141724486672e+75');
    T('-2328737444159883.22585049478830', '-465474361749661451599.9951730137496', '1.08396757550285951917153850391172159248110224634381083904120968e+36');
    T('-20.3014066928633757647889348362325618964962565804945772008656587579802123642954157', '-329435370768184084561406820034073934012588977709700270652517248023565145783776412004629743988394401273.28545348', '6.688001440979140070188345542361244069517729332398623464379411528839275521534924214116901390055160850670677514105783601320874524580245478001576704187186030310275122663282192690671340259611636e+102');
    T('-32476062941804823808177212128.37047244026179396179206', '-23170264858.839398780672784729575796922981615252587039', '7.5247897993395677581189377054108136654093646195424085291052102413168985736328290334867475461403556911034e+38');
    T('0.00000000000000078020818918877022784107814476742023039526884490519321760350204369809967323559671586528756587388436', '0.000000000205123365786662618531603763262183979221647', '1.6003892978071778645361752741729365945858649779217485973276644181520266580188064434359630899417624168875864924106561648427968680391728674092e-25');
    T('16411.97479231952475505598642359391159894419529343140530675214816439312142161965104995811520160184950', '0.0000000000000027918217792698757486367905214734859040448642073369967425369035344103512043731', '4.581930866602584512178030964640390866062580122108157686730832013698006926287481502511491005515718454308878140351176787687577295267975260433555460720995298677352745266944804845e-11');
    T('-64342576782108353170532624771581267539756520906919.37', '10.7', '-6.88465571568559378924699085055919562675394773704037259e+50');
    T('-8221425425564202135543311357128878704299939907773337451688454087709054980064079701204709862893688091178322203851683767887893871786', '-0.0053653210895499081114778560023351704116389771011759394571181993140755819983', '4.41105872219414419707174038902324084811431456260158178418632957765849297276315251194170903369456489104239536734987785292755508500736273353438544501239198533098378964478014299793109607485495440119098699638e+127');
    T('-0.00000000001910608511655268019857813374990127054476192504583955285846583482452368825713345318314648457310037047203752064778987032587853577350', '642301865080793548011195664841322815727082571813145907.638646106551631362492680834939823385729510144767143760057', '-1.22718741047541772674654955433282115912253583024496254728712579960888844323021707984449130867906756160401346562961603346122134581742784760100299534939794183794586063570878664967245581007170245594883361157548393966363447660442291523748990895e+43');
    T('0.000000000000001899500268191217', '883952560680798125471977636433525656958767.4329146255465789678475476012476204472687459005798142889552058775500478237', '1.6790681260814890585836193220538636972839642793176878790660318627202422075166836170289452406463821318133532926386268184542463044429e+27');
    T('-506222074114478440.4212018359818757090468806843375176631454826045115958516526575279719878856236353605111026111752257846026439938084657014050761145504', '-5159467544042334960313178363211289944335613842064316815811191728903.574367721298576480151967142002627219994962105347353373165540336969132995273967', '2.6118363614714449452582198430103897223785994901299317101044259761348107189762413607706765732326606750493547847042725797461693311578242536847852702975212843374994786292094043375579903644474919183423720511760494827145234240751467691929508470719482500262148133264801792166487508484367183230294368e+84');
    T('8650434955204837420156251340980467125431552732.08397236030027468302684214339589220209558182529147', '-0.303570960693217884327420647078548564916276955021262691277956348864969879961811223297756', '-2.62602084976572571043981976309152638775264794392233958131099791715831899377187947876427492733764795120380985528043759980136856459126265934320288206950485593122394243946315413929694132e+45');
    T('166664781364.0082914723488023478368828305505987873686361307000655181790946128760191770642121717143556656346592000446628174724572', '-480041.0942847509055712529720906841565497160321331762055830088670429871444554935489589608266394637805469063', '-80005944024707299.88369343694993429517249943540140207247881593079529829548920836320477337300843753304432472775747784579377690170478442441481497272861023856984874550780497963725202716372180855504618999968964525770542110325165291916036');
    T('-43211558252159093527866775647205601084011492340.205459697805340231598755202803639527161744593', '0.00000000001119203318598549392536941753377009590965307584900110755022862027840043858728011387253539611180', '-4.836251939763099008266531873875699139740918027346229229666486821933921583162396652285702155362998553549998984080376784393703700976212048695921578240422117362224246009514826407968734974e+35');
    T('22228080669906830995384898726318434540920054474075066362723430068303595334', '0.0000000000000005446682564983826904165557014954366345827192263245436061673439169771964847765827397722973716801924439429612435686218283131447915481741738621944216616', '1.21069299437835559678074390552059815249561615752757133499522502582835547433276587506411508638591250461101776265492507290334698412116695650224909917771154983775120278858482062610470094757493360226297555949389464060902869744e+58');
    T('-0.0000000003773157928', '43297647023077445.54510130448338353765777486', '-16336886.012887026261648726857462053937811976384809008');
    T('-704246.0642491', '-4876468942183457666260007295840240729718873395834733463009561654592496364003930788774251638836263860.464149571397235826605163', '3.4342340599656720408721350433721409241108083813038963987160054952477748964430703827960612606796544474314358764054099696015239692357781033e+105');
    T('90714014677317257217388754359562724228350422511592300196367622823480490782750230695', '0.10551171877203891416100509846755006675817523511356135349573800436749642311', '9.57139160531570883071608150743717558732170393411960576472278636404390923564848224638754968731571966908325157310107689739849841961000661380686664893982936145e+81');
    T('16256367650251592857824070659043447853047682031758021447060795635763437999068158011730593356058028259231482670.842728511458309985368672626159', '167180302632355.05677826254070883700709474391390089985215716385024', '2.71774446347188795843522760152851417095331335558235538784521529465054664495076688729866682142620092642030334321689665117663066458919556787136329889313558843246657535262982668786110905407308427324058242816e+123');
    T('-0.000000000000000005140869693986476129573937292110832444827883905213371700103686737472419302083991260187191661701298052551015422048926889376', '-23431072984.29109719929265906334268220161090515289622128095638741310550195556470', '1.204560930025273608708687379702964400245754501914517994869604548744993478713638266232843096136298708651286988188211879699693589237471003927285113544165412103336583365360013429733201256002657445106272e-7');
    T('-600918601565864357615830916531004971541558836', '0.0002398203266606694050330194859330980464992506791531578245580976766372221543075302994826964325096371', '-1.441124953239982356850028499314436394823612382489365920407488055245261701578444032269000578787663442887261399958157232897473876372957266584156e+41');
    T('-0.000002378573545299614819606175997977561025598320050', '-2882653077216085525237966723240931593332010153721729409.189099950085184011450067199947461092968807651228141791418167', '6.85660234974270886050574307192845780707197555258670774440795390596137425374082134400993260259690471606609110758329634878468480296762286592478289418958225034835e+48');
    T('0.000000000000000022357617532781889076479320065100116692254213222725326015200603762919174701589837856906', '-896457719826992659089225870644004458751127732719124385827686320360654074025236', '-2.0042658834201645580346859820519392326977523701452584805357472701178299220185960756765568847872663515490447098727456428199599156161369223396351318781899083200879816e+61');
    T('-0.0000037591700832106546820837009314715135833879626195863911405199', '0.00000000128660973296737392590374219331743360889744123526004704657440431966332363276599678510386', '-4.836584816938601241595643894689727875085794631034207181521858384737358785559745009296624885016550841630384096559285949624409877337769212375896814e-15');
    T('-10897404485088933268299142109127940457874105398307905112497480738702104026493870', '6459527220783833615589828721781406862908330296731571946257487596628.142', '-7.039208090732380052543394587491979904440526984139707627324909518932550024566922074139234694919548719030400279757073454088117750506466392244643248954e+145');
    T('1252391487512578363516059332047552591823815440694963818513488609376352517930673851276.19244762777307975100', '22549776.9253795732526305732013511684558623600507908536351482864251791287592196740297262530719650195640957326260', '2.8241148666652939539350687862707201683973473917640485175382134027259511907319776870024731139293000940076904783362318907295063149688420418024813050345759700762391301983348609040284923961341431326021436020670656126e+91');
    T('-0.000000000004618950388937140493422755399930264176038354392749822437964314306322496775785511138074695877738144276032647315124913748488917', '-2713380462202072657447653028643460793172301', '1.2532969741222701540713742524625604310117116627579838128477044145948287310122585599028058960352298239073038474733050249887724953498915163176662179193294848309569888017e+31');
    T('-0.00000000000000000004741599927671153114706', '0.0000098605921767576416944956043265259701017397049855054246352774023236279136700079166226671683330780112375', '-4.6754983152108772107589021499824280537386842022454892219026854810089318448711395624891020610400431916945696952628194508675e-25');
    T('-600334522639128350301416069108895484950049158632569154577774908833218708159964256760025260070745036754849229258748618.286225296633751065085057954880221', '-20603943628058420.9233', '1.23692586624339624137684561274248493253093335427682675519597952187340115485564971154200167383285889714823571236526154847178654496322656526986532466296684549399002517280493e+133');
    T('-0.0028569903450426823012406248893590913347605950672345342794', '0.000000000000000000380602538484379176276476072502', '-1.0873777777486072321414819892742916452188931452780514481064796648209244384695987250588e-21');
    T('7633371138864371851511200109335895009200379214065654.14141197969364686617958181976', '46557774899433776362769332468929072168263071780847173536.32424609893425634', '3.553927752070818711219752919654829713936648328701795633611695455871498173222792379572585838047775680404274006272352702005591443767922861383251901395172784e+107');
    T('11816689310524760.33060749', '3240086146153074.763149055913088596613954276720424786571958312186345692516028911031344618033329875358392613', '3.828709132842640485458626662093761049902194180604315455762384568460513896245457880390402922939380711647608722106357184891221847137e+31');
    T('15417668979208863688007903355418023589336919725455814', '-2287252965683244062854057265399517873076559773521003653290361219949584429534587223153067', '-3.5264109096618027617770541672930242149319875097968700968868729901509384897856549235466082618911136178623675867468948846074586307080867081538e+139');
    T('-44231051261766981720932141949492661571946235314205992269845098822302266502035476097047272345277610.27', '-21829364252494551993461871095.1405414373418522117', '9.65535729263870199707274609187215999675619566645960063838135526473595293696284813052387836041619820102648568607484181212361915051957155111290134159e+125');
    T('-0.010471648280929367353726533714112845102028595890585874570958083', '31', '-0.324621096708810387965522545137498198162886472608162111699700573');
    T('9801144054.04251480', '-79669022889354091.1326070042372454589141728234307836693721872475118', '-7.8084756998336986277926157641231569523889190793366151638111003547152953122771467464e+26');
    T('29857288634175691192253935741525569423464902722491247366897306044982457983212231816738628626832523979506745945', '133673.6558945837023809692393557234541133', '3.9911329268300663632380133640663780097335900438380448470493780783062334184720774070186349410361053454199720794804033925701541209810757057340083455685e+114');
    T('-13620158075540606.0220850459251063150637623012169134311683793968716003579443803708152', '-14094712052845720944279961661927524928294844400168253261.8801483866631477108668134130846798999339316583941852334437626140968', '1.9197220618898615906375442169544326587585370014151488298656204877054492796167185482130313382428085300372006548553535032109971116684812746007217292632043932773898787721990877866744793392082655385848282771136e+71');
    T('118440515054.96300744924345961909763451770037124776047596926946', '3978918406101218410350317969873779924817925511337423100533163173007579791459856530353048879996496120205533862684343054321905', '4.712651453803007726438461712612354142589559988228956502605819373002120961113842720385180079632764208616661380363663300333950937121937309186788267547560787574638782242683284222185255213e+134');
    T('0.0000000000000000004979626118', '119953.13939299602151864098685411551208280009209744651134782647617437471653240473066119015267896990648067942927449283677891199638584032687735555', '5.973217858574576550243146820040482597564559171812500490156201032898210607636089901472178932446062156472087484005983212281811688264520970961370795522549e-14');
    T('4133032609317612147361.233208455670', '60149718767070729539657807610332371421265360276297353368024670202.145813386468110250239535755215076073418035935987159939685', '2.4860074910558688193760888076283428107792208632944279345307661267298591118711344604905557070531163947655318143762909457571230898163106422046776822919626395e+86');
    T('-0.000000000000000025988801412726981607051504723536759179533093115290316536803305521555847577878002593862833182498872', '-62190864847540861920221512167077698610328189518126509.945114225', '1.6162660362084827318707380558579363611834016595419194188990226173706520381985407013085330782761618687291735642283204415795057016756891900469697853795529736542e+36');
    T('-517391939544713325422033696525596189851051748767955039585693350056993951682945080450723027214906277369681756055494613881445451892', '-6355737319244501.33875834602457354455598517141883018726489236', '3.28840725884062937342287062927549804683222950446951497853928995858263827438383088820860677614531136832120859449547463148055636204133361775822367974808862660315286528874721657070976693834512e+144');
    T('248488108396888727192484307620472597201728811.43632801228625119529655174763542491519552462322578674423725814425253', '-244376619784336994670734053495423487949530922624294868474118463232994026818752162901576014805701186113050589437429269164232162718718', '-6.072468398663559342194397673594158367331416443540937376483832956458681282701204862291922555840434608500693418850945313497296767648108091241452234573071111256003091374254946595152378328332428736545902967819673107271115746769252798457479074985654e+175');

    // Exponentials
    T('1.153024e+0', '5.28973573008e+2', '609.919225043976192');
    T('-3.699875785122930862283231104748329088664056423999601e+15', '1.1e+0', '-4069863363635223.9485115542152231619975304620663995611');
    T('-1.2682525953252723e+14', '1.788378029508237622037088155833989378609386207655e+18', '-2.2681150773465187729527785601467557683746716925715084680772194565e+32');
    T('-3.87722166e+2', '-1.74278705869601992403691e+8', '67571717327.438998052674620914706');
    T('-3e+0', '-3.64329808384254180872888049513111969646643282968e+25', '1.092989425152762542618664148539335908939929848904e+26');
    T('6.953012278719261355e+11', '-4e+0', '-2781204911487.704542');
    T('-7.04663671550547513365402564941508037562051247993316079593e+15', '5.535517336770122093358205271769744142052184795629511766877e-18', '-0.03900677970460142822373864049115522460524845334243105937826127540936694775384656847162726619838459694385924193041061');
    T('5.08438408986e-9', '-2.606367e+4', '-0.0001325177090713613862');
    T('-1.2967e+0', '5.94990983e+8', '-771524807.6561');
    T('1.3117e+3', '-1.959557842524477358350764324331855847355274e+37', '-2.5703520220393569509486975642260953149759129058e+40');
    T('-5.3548e-11', '1.742694574037778940228462366629620551e+11', '-9.3317809050574986691353702808282921264948');
    T('4.34526424962996265825639250671e+21', '-3.754914933534859756171859142125715053796299171e+1', '-1.631609762109069348677868227008975151085048810070540943592037216417378493741e+23');
    T('4.7426914347369245430071315112274335473949505818891357635e+55', '2.099290936966289806252483785990857067e+13', '9.9562891457708756252380705318075217577762765683497811755225761339325645531279572292864156545e+68');
    T('1.2197662968047362383e+19', '-7.9257e+3', '-9.66750173858529800389431e+22');
    T('-2.18492048239986982664891448764e+26', '5.0217571e+0', '-1.0972139945426971341049955535599032244e+27');
    T('2.8477441033458111e-12', '-2.6015762266879431727233849707015975771758956198e+40', '-7.40862335895523532800693698581126602552353137494951139716821978e+28');
    T('1.17305251157767339030842411702548e-7', '3.1679877726710109082864387936446078459964397e+14', '37162160.13379088759968293791782997863641886182709969796604371507532234183556');
    T('5.516400791447843686549580838221025644959140288781e+40', '-4.534755696021348164010120097087738141133999137556364474656e+25', '-2.5015529910554782273339735168586403296046609840907360623635477256369630649686086353650780443350045195634336e+66');
    T('-1.086178703865e+6', '-5.412964e+6', '5879446221587.90586');
    T('2.193003362433320722921995078848109409779629e-11', '-1.87156484301625964803880921322257778262063404562091823011824e+56', '-4.10434799374664745958524117450745644772403340614160247100180995137281346990234693655901738534901333296e+45');
    T('5.690242268084896613323736558476149127814487192716110263e+4', '5.85123113232510962819522680703136616268672961423348513284699e+54', '3.329492270949058963099905818513145552769091859265632399465562585831994642969765945460416258196265143264172794765837e+59');
    T('-2.2964852129902920477142981e+11', '-1.01192386417445983894690800351420572044711646857422992584148e+47', '2.323868190748643763813766975749316051539457362388056941019107244885259571701270065188e+58');
    T('1.64014114524e-9', '2.33457695670849217356126573862065622e+13', '38290.357234267802543783512378452575905911293928');
    T('4.52030709268304468292307103018250587082757e-13', '2.4202633390406694150089337e+3', '1.0940333537626286438097741446790925743401036958119194290469762262109e-9');
    T('-2.531530179588420531938806173298571611356854e+42', '-3.7916295786409190517918e-6', '9.5986247081496130774858068268051041666243771242517966898979109972e+36');
    T('-1.1137e-20', '3.15532351096658148747044e+19', '-0.3514083794163481802595829028');
    T('1.26704207115899080748696654617058814620502905910804474e+17', '-1.1036640030158560360573681189153991777396167698e+36', '-1.398388724244832908797767208849960696897136903372124358147141607664782163824521550287804299792680852e+53');
    T('-1.92043925491801737087120450765880605794833102824745131e+40', '1.48390768547e+10', '-2.8497545698511264714107436784310097859137225929760606638486194657e+50');
    T('3.8135622104716384192078983238750322e+13', '-2.39302666425671400328234877933630532203640643176e-15', '-0.09125956055460405574747767900047040915488905349535492182534023415362543138557102672');
    T('-3.234931242339998871854389747974137006095446e+30', '-5.92883411067302421812958123642550690642906114730631103678724e+9', '1.917937069526724859889065751200796792104177866908520783368616010428214659504892064497475599582063490904e+40');
    T('3e+0', '1.99273095508512817553537488885e+0', '5.97819286525538452660612466655');
    T('-1.953336949e-2', '7.78542087974602115e+8', '-15207550.26792398884803047135');
    T('-6.76927248655350571291737558944587651874684243378e+47', '2.106647491079819039765594992079775666086664783295561e+10', '-1.426047090023359087715991793962565118985535044059537158764939014517624689564606363869607106631045058e+58');
    T('2.84765064643062294633e+0', '2.55136e+1', '72.653819532772341603485088');
    T('3.03393155013395755198972274893138442728102576e+11', '-1.794588238175697749312009789507e-7', '-54446.5787530056249211726327679537663382541795271931196078506483571264470032');
    T('-7.4371366140844e+11', '9.1277001754e+8', '-678839531768519399904.0376');
    T('2.56791237096035223695516010175181403674163385e-14', '-5.44464273285261087885992104112953082914e-20', '-1.3981365429151599690537623761404625947844618835506028383097657567011072106548790389e-33');
    T('-6.879908191615608804901708679355480110539e-15', '-4.0968480016502745852031526855040036466e+37', '2.81859381263577613382981765247793574699886457413439013342011267606204270915174e+23');
    T('1.407896156490752151388208148659e-8', '-1.377363868116052e+8', '-1.939185296009824854218448713898983585080174268');
    T('2.425103747079320530219213960814750892199747341e-18', '-2.365116997875961139721649192832330725431640562e+24', '-5735654.093829986735467358771314018265857755686256663053548830868280136074150452583527245642');
    T('-1.0967188654311383e-17', '5.50107804404633954170295415508097739e-8', '-6.033136071114646945658547999340034265651011304263037e-25');
    T('-3.2712219404248354159015350722161266784e+4', '1.40636e+2', '-4600515.688135871535507282864161871915434624');
    T('2.7739526916093949721614335309760564882447898334454312345e+55', '1.24528453636520646201893749622334742900013735e+0', '3.454360391469821959459359614081123116456332059470735649519645107811472952525654511905494830480058575e+55');
    T('-3.26272930891827103933126340157752087353407692e+13', '2.0026083903335067609700262e-19', '-0.000006533969089426773691398112669586901327358725244893395121554920405215304');
    T('-1.06137697482182359209772074638146895e+28', '3.0663106098e+10', '-3.25451147889358514503318856302707319949426571e+38');
    T('-7.1333686145776974736348748988848e+21', '1.62872571577602913313701931021625476208216466585507507747565e+15', '-1.161830090267232160311720624731057789079310830776668256181105708907630639297571581978415512e+37');
    T('3.271164612807454534123020114329520320585016126992181854263e+9', '1.2e+0', '3925397535.3689454409476241371954243847020193523906182251156');
    T('5.65403478840648195280973451110905199e-11', '-8.18034629055388719783063246807413028100652148732e+15', '-462519.625080035971400064460401798364338310053450183034154989804876490732716900057668');
    T('9.44482836533037505193155281233841e+7', '-2.067341641721856797e+18', '-1.952568697856325861901776699253387295308175672267277e+26');
    T('2.5111226381792956734986397e+9', '-3.65360655537789827590991569211646510131461e+40', '-9.174654132209716853544084660541570252769600723604642707862516736017e+49');
    T('3.28741239410951819553626698975108924106326e-4', '-2.62227844885453731582e+18', '-862051067357068.82790743503875251297002496305525999591232187732');
    T('2.2772892974034099e+15', '6.177601666756392528944e+9', '1.40681861593257990831209635468300461456e+25');
    T('-6.50848921524116628e+6', '-1.144580764938138569486790679009e+30', '7.44949156457235930691999052822025420513027461652e+36');
    T('-1.4551927019037e+5', '-1.3e+0', '189175.051247481');
    T('-2.2911981542413e-12', '-4.53314582071257190328650375668441355537191e+31', '103863353373233077959.40247540692426855128645966365381883');
    T('-1.4602128592500770116678944302583044846446637e+30', '-1.427582797083786e-16', '208457475794593.76574073813183484779514002948555208066927682');
    T('1.6700609441460181151986345895359954232196252236e+46', '1.68243152329e+7', '2.809763178246720865741573493401128674173862301164254857644e+53');
    T('1.05083997100929235995740938763615497143966041793319335e+49', '-2.524496056110348375423188927e+27', '-2.65284136241607138569403868866619712437928400385166771000044188224282590147003545e+76');
    T('3.100786363878827739e-10', '-2.86304063902707066e+17', '-88776773.7272606582182668524792103774');
    T('2.502713517421925552323011065985443554034244e+42', '-1.22434e+2', '-3.06417226792036033073115536852861796094628629896e+44');
    T('-7.9489222898867596260428e-12', '-1.0788548012690995443645e+20', '857573297.73592957352865844131522518881758006');
    T('-1.0755932899013878523165928263944458509156806951399812108e-5', '-1.11614e+3', '0.01200512694590535037484641917251896792041027851073538628622312');
    T('-6.4497917487303e-17', '-1.004446091246e+12', '0.000064784681113628528184449538');
    T('3.084474103157632963053e-3', '-1.340722625329e+11', '-413542421.7344814434949807418969437');
    T('2.007409677882519495029550241974657552014828965e-7', '5.222151840789271106861316521519869023311e-5', '1.0482998144572396943190891671428030237589403912003291601853143252123470079223263003115e-11');
    T('-2.488498956742602121296262808732706422946353052713e+14', '-2.23172e+0', '555363289174160.000613929563550495557821783503480065636');
    T('-2.9688672164600521862302335509380676629e+23', '-2.34340486619e+9', '6.957257882124446358953277414968471000555340527351e+32');
    T('9.6116339631e+3', '4.941558826e-16', '4.74964546426381633206e-12');
    T('-3.510917030490276336587658593367687803429e-5', '1.180564327372e+12', '-41448634.02559652698690017440995500011934045540158588');
    T('1.249503228e-13', '5.879424084035664549067080010774031325182324371002647085e+2', '7.34635937178350612118448086199642691938843199011087712925229038e-11');
    T('4.5e-14', '1.6224776733813843876610106340899993022215e+40', '7.30114953021622974447454785340499685999675e+26');
    T('-5.98567638319111415891202402487540407421463486631972864107e+17', '-4.54793136981650498391485340038861239718e-18', '2.72224453926846670043530235188742096666820419395601557608672857967843105674091877295333165001826');
    T('8.92108677749256373753068098541e-2', '-4.701266425389385608e+0', '-0.4194040574501097838530020557051108449340791197928');
    T('1.0445719060110887517378867373770257738782319e+19', '5.799e-7', '6057472482958.3036713280051900493724627198667881');
    T('-1.03890765460564576e-14', '-1.34206940160748687807435785969646342084e+11', '0.0013942861743420366640453267735350857670895370671868416384');
    T('6.39749371e+3', '2.5234527992374730183240434196649804550511817034984615e+13', '161437734106036264.31022782519073602768462872676198492440927165');
    T('7.914175439604437611967814601653913774828611014407671e-5', '8.32100403850523895222657658496599490340606e+15', '658538857943.8750019874631462394490423060270196984652115300400533954357304447023953861129188626');
    T('-2.77837203022891121310898693340776679571778100244092e-20', '-1.29e-1', '3.5840999189952954649105931440960191664759374931487868e-21');
    T('2e+0', '-3.785802336743340316719402396217939978601e+36', '-7.571604673486680633438804792435879957202e+36');
    T('4.743769864188027932328495491240985e+24', '-5.9891655632114551610420257227248006595584101099705918e-15', '-28411223110.395218469762107537426925959156755933965249012600778016167994609252836864923');
    T('-1.696501776305087785563120340668939029159482e+36', '-2.20704482451194839742722899349253308746537e-4', '3.74425546516947120760454369427493495577833827584040523256623062924543284078088213834e+32');
    T('4.0131499023574625019065378616938094123e+12', '1.177461924351806545225557804503154113578719e+28', '4.7253312067420823358733892576894302742518304481762080832752336264184374791768437e+40');
    T('-4.62155685185e+11', '1.65583875e+7', '-7652552920621239187.5');
    T('-2.776598951854774016146205e+24', '3.5341178108401263600119940986415244381516593e+29', '-9.8128278093099833546223999989350419583424311768423158174047121479565e+53');
    T('1.12e+1', '-1.313e-3', '-0.0147056');
    T('-1.400922738050340928068459005e-15', '1.669774637213352507258799185019866e+5', '-2.33922525669194448953065643831459603361384442257691893159333e-10');
    T('7.50109935679466448466358706299522e+28', '-5.03e+0', '-3.77305297646771623578578429268659566e+29');
    T('-2.38556354949153835408756963109992783478e+26', '-4.99378748e+0', '1.19129973861952045985823120474150382502278725544e+27');
    T('-2.94e+3', '-8.61615789244720791078571983086407412571238524628016e+2', '2533150.42037947912577100163027403779295944126240636704');
    T('-5.80381041944064404262216137492215065819338e+3', '5.677138821495566551897442869075850448375293389320539675033e+37', '-3.294903744480694771704130256831336545059429064900653708388680125250845128363784484521559308407188154e+41');
    T('4.58722638789532058289643e+4', '-2.292585677620131398099727011e+18', '-1.051660951688994125699713239960797492772817868647073e+23');
    T('-2.288825775843864143902825178240786758e-14', '-1.022792029007781346809e+13', '0.2340992759320655142089938144423568704277940784273012755222');
    T('-1.432063323237600412250117767285385708080998075274668364678e-14', '-9.23012609141738073365221260162e-7', '1.321812504437725779783150336060293956648246141009265660188911448444031899918334929357836e-20');
    T('-6.0806e+3', '-2.9505713511085379204927821042777582523174534e-19', '1.794124415755057567934841086327133682904150714404e-15');
    T('-2.1971689665281316657e+12', '5.06674545635318811308850459987394e+4', '-111324958779966411.74779876603862140385999575942221858');
    T('2e+0', '-7.9498279886418403969498688721389799731931074e-8', '-1.58996559772836807938997377442779599463862148e-7');
    T('-4.31446036399049665749135715315413935059097082785e-3', '-5.09957831192823753379633205333620130303488425232090581e-8', '2.20019284998799462125934843416682842768267375970275614241257898190943464155895136069876374903975748085e-10');
    T('5.6684216814938374789992297e+22', '-2.466e+0', '-1.39783278665638032232121004402e+23');
    T('1.4726466812656072908248567521825181138629034e+8', '-3.47948862867465172229571384341201136985691220463e+47', '-5.124057381519144835787886917183826378015360092082220951469308136228382069243924518066722742e+55');
    T('4.3284361218626063643720235128240704200079650833e+42', '1.4641063731834e-17', '6.33729091193628179321704177525739784198638290425046666717722e+25');
    T('-8.504503345e+0', '-1.6126451605490274984274251623885903733401871912282447644089e+21', '1.37147461621872663968730195332709350199064207907267622573942269977705e+22');
    T('7.7309990341924055295760169328629798135433331298237e+42', '-5.99563576510407238824175823080622306644936962384464739893e+32', '-4.6352254309389028017492862352717241512621152128519099776509088009611537721357769693774958840413184214468641e+75');
    T('1.31099220633236524445967265953445007243e-2', '1.7160044747e+6', '22496.68492363164434927557667458365943093619102521');
    T('-4.71244448219168433e+17', '-3.661845152473087014511441938e+27', '1.725624198341216588965585001399981214121943154e+45');
    T('-1.6192523166690470927016735287431037161e+8', '2.1063669951791069077512605999904333513315096716248026e+52', '-3.41073963669898840947516853657748402318394608095484774905332123128295765265305433698894186e+60');
    T('-7.9546255726227721651851197010394795e+32', '-1.6352825346150572721595214349862e+4', '1.30080602683123181981363225429281630656820439050469581096187376829e+37');
    T('-4.65033001e+1', '-1.78402957430342048751447188050189199e+35', '8.2963262681107211387373788951990821828756199e+36');
    T('-1.0747111621539139354559268707283340006236738352646385975e+55', '3.4569644402407395181922991072e+11', '-3.715238271095879729064413458963542564475178869110977001563130120111735883029910152e+66');
    T('6.3652937877835233734658553177768102e+23', '-2.739191316024006563208208745870453e+33', '-1.74357574674381829401359393298451323167803405210747026007699767690206e+57');
    T('-1.38596e+1', '-2.01668654e+0', '27.950468769784');
    T('3.1e+1', '3.99532408029111361202961444968519230785160272779405533506e+35', '1.2385504648902452197291804794024096154339968456161571538686e+37');
    T('8.752130293411895486461455570456266543110235191058256368242e-9', '4e+0', '3.5008521173647581945845822281825066172440940764233025472968e-8');
    T('1.7666567718645722011538689771389140608479155e+5', '5.79849364509293864972181107177185722325631e+34', '1.0243948064717127403933357900393416605736130527033851840351793404944700646104585721805e+40');
    T('-1.88074285551825927e-1', '-3.5892420997049074284601888671967281230296723689451e+31', '6.750441435745360244959256403222145003141120524314248902529158196077e+30');
    T('-1.47443449855473683902404463491959178173791276282416e+11', '-1e+0', '147443449855.473683902404463491959178173791276282416');
    T('3.6674516424397608e+15', '-1.621851622618484198437145865398587268422606620129963582e+14', '-5.9480623971657509801533671437416378775411584549470454175597505327911856e+29');
    T('1.852799859644936708675646349852062e+33', '-4.07939656803717490972435529358637164801722794978e+42', '-7.55830538869531417546824622551390200682044219768001754254044667676246763456544636e+75');
    T('-3.6242110037e+0', '-1.1278795340499000045446830565915076472512673379718862044e+0', '4.08767341815167642135552034202789183114074114504811682323070735628');
    T('1.4274012216017920060904e-5', '7.3181715e-4', '1.04459669389914186078985917036e-8');
    T('-2.3756329516520898291145904664793103180184540970355072e+42', '-2.270259567e+3', '5.3933034361686053900907941458116470570432078963452065594973824e+45');
    T('4.929295626989455124178205785e+23', '-2.09905e+2', '-1.034683798583221577840626285300425e+26');
    T('2e+0', '-7.18e+2', '-1436');
    T('-6.31146996107278795852155517509682305e+35', '0e+0', '0');
    T('5.62374544362317131178832531913e+25', '-5.028617311364517574605216817082040721294634e+10', '-2.827966369251080786848400856170544022762054465978646727405142173480654842e+36');
    T('1.117412077388384866590003439477599421523143e+1', '-1.61338414788659224331375974470976667613219454556537612e-14', '-1.80281493231544618608867814708290945943864723087524854355671733079894613280168308370993407954516e-13');
    T('-4.2815998483904942107791375e-20', '6.9376170311235847480494e+17', '-0.0297041000286500510137199365646358515056073393925');
    T('-5.86940489151059825558e+20', '1.186355039910488859404215239846695660365360637322362023701281e+45', '-6.96319807431887432746494916572974977870149668248845809245935171579248369361139798e+65');
    T('-1.18405412e+8', '-2.8902735e+7', '3422240245601820');
    T('8.642504975809385471415e+17', '7.5109001974465513712091271541148798280521311221e+5', '6.49129923292395160193292467556975546756516371487956307369563014247715e+23');
    T('1.9923555553060256693196663e+21', '-7.20338812908556886039013517835885875517875e+8', '-1.4351710356009111862906055289239352924294602722052150633824346851125e+30');
    T('2.47767224522360228025008764692368247199028078613e+13', '0e+0', '0');
    T('9.159951983506971778872e-16', '4.35572412991174861535348709e-17', '3.989822388339430055462173193590823971110558676248e-32');
    T('-1.2584903289619528522717972e+12', '-1.9048067354292e-12', '2.39718085507923740095024952130919735824');
    T('4.8222e+3', '-3.915307e+6', '-18880393415.4');
    T('-1.145743e+0', '-1.40499568633e+6', '1609763.97264279319');
    T('2.2428057847026326379001011260518421703171e+33', '-5.8239094523813465985489463975171171984367780708670099e-3', '-1.306189780938522558635234193371919783301088290650039938567007189410557075386960930089941183929e+31');
    T('-6.26193904e-2', '-5e+0', '0.313096952');
    T('3.0019845694844821786908363e-13', '2.59803721322e+2', '7.799267625032905531560694408803215886e-11');
    T('-4.6771111417557737587832171805566392575e+17', '-2.41963969908791889847485e-18', '1.1316923795638693208841937864685962710236300920790258386423875');
    T('1.368790147448792225307101642172296e+32', '2.382834531191820192940003254735240956141547e+34', '3.261600429296125258884096700972863323244136904532628866746657143899537981912e+66');
    T('2.5158133090673533e+6', '-4.50742632133e-15', '-1.1339843128842514618218435889e-8');
    T('5.45290152125555300060203251343e+25', '-2.3624677987030823546e+17', '-1.2882304253465295333570852578315749764228120522278e+43');
    T('9.10645280474914206117691354111985771303355e-16', '-7.46868647274590839548386658906247692173836809486984638e-1', '-6.8013240877528954266058199752847353931423569799021123026453827361109324522139420649351012286049e-16');
    T('-2.8051865003118537531e-11', '5.348454627859893296622387289464589021238848335043530157e+29', '-15003412719603032216.1087879676948803801286988008339781735642916313334822367');
    T('-1.7561380718435796202851095012247e-5', '6.128268306422028776297429697021742180071567401e+35', '-1.07620852873801007780502248253390491162313640920758504239716098138490580960047e+31');
    T('-4.378710689215449958543087541470086791901689639419136544e+54', '-1.9783905014509610108940939605033592e+20', '8.6627996361456371392438623941839474271341962222925165084899855051115783079519792754786048e+74');
    T('1.121716338034368180915e+5', '-8.734522008301422444882962812919703e+24', '-9.797656041632466817652476303536047619163255652072068245e+29');
    T('-4.8582993368534106923769355421057e+16', '6.98715048402856908663443073960052421774798629769213e+50', '-3.3945668563050984730942842784405126039162330280795884968022377310599078522350518141e+67');
    T('-1.147697695159307927e+18', '-3.14666e+5', '3.61141442944998788157382e+23');
    T('5.21292708738338107676256190382983420967375413562063935697e+56', '2.0716e+0', '1.0799099754223412238621323239973884548760149067351716491899052e+57');
    T('2.40767713664497193342119078614448816473118895591100004e+6', '-1.9484666614e-19', '-4.691278632167740060209890691091392232345592973376458043474066456e-13');
    T('8.84323002496195395098550834342755e-16', '2.074843038583988890307904822332637330993388021856189e-20', '1.834831425588922445909395217500126101937521988613705732420133880473831365442944060695e-35');
    T('1.4139590392221052468075225255352223739775768735149e+28', '-8.5071158697e+10', '-1.202871338167213628815991013832091374398315253263031540940853e+39');
    T('7.60905256044027294859360806368103238783888705635835726e+22', '7.626236267e+6', '5.802843259393881904794360045962793471613853022211697708475474842e+29');
    T('-6.49983097039610238828951299410887525e+23', '4.100424999934130974333860679470965920172048633176651e+51', '-2.665206940635830060248743820457885128628819326617038782969842356414737979985236017178775e+75');
    T('-6.44091388086048854999712e-2', '-6.4903080679715410063843348214810202569974e+22', '4.1803515326058717691453471440857864505008045873090454741429847488e+21');
    T('2.78029662683945916043494079823001566462283856388915e+47', '1.72292937157713197163667918785093807960421637821735095106e+24', '4.790254720078529163251026200113350912677847102429264772360101417505440468715765792439145764556851324914999e+71');
    T('-4.4878498622339775396888494885583054208940416614412529627e+46', '1.724e+2', '-7.7370531624913772784235765182745185456213278243247201076948e+48');
    T('1.352549686604181695307046110709197982598092383194e+48', '-2.3555586703119991494894059087716726417170242847945e-13', '-3.186010141308257402498477975479367405804581618494048262835305948601981051698397443353715881543633e+35');
    T('-2.019515564917190266675805443119046e-17', '-1.4788018868472268212026912165159431467984470085815808703e+27', '29864634279.168841526151723443673432805367034874393502449296552705312364840770199191857338');
    T('-2.1655275560855920418985633841581563513185032946266e+30', '-5.9625533125793712547572194147395797672923522437e+21', '1.291207350302005700228376617552289919885062421326450164415825007449363425520444307151212866370242e+52');
    T('1.012506744028479038160052533215313925528515964937e-1', '-2.212147e+0', '-0.2239813756282367818828645731194657054416130006287489739');
    T('1.433496071288945453514799813e+23', '1.3979267765863662e+5', '2.0039225421861753263084300184572426981095206e+28');
    T('-1.0851e+3', '8.013590881173773221229825407826356e-3', '-8.6955474651616613223564835500323788956');
    T('1.0544140083165e-20', '2.7639893671307065522219750157782938300627387865356111e-13', '2.91438910754047439029710260584090912925195329258292696061880971315e-33');
    T('6.9910144713252743945138327844029390845842716601381876e+52', '-8.482563824399426864364409762208780384877e-12', '-5.93017264503166569047842082409955073105581203136314428395603709690554785251717257461332289252e+41');
    T('-5.359798702e+9', '-4.932148432974659892667336636982770197907445436167e+48', '2.6435322769128916091609850224697296903108609164903710455234e+58');
    T('-1.71427280396517551988450013042709589140000549e+38', '2.403519034309521273463675792599073e+22', '-4.12028731432945393654068892074968286875285779764235024381198392132877356891077e+60');
    T('-3.1889196169851645e+16', '6.3303265668790672589901e+16', '-2.018690257104300648907301509647095237145e+33');
    T('-1.23339224241833842568898143251348600283e+19', '3.077450385078067e+0', '-37957034313826161513.8572222562474073059332490133292961');
    T('2.92677040682294450913892109671419035013083833e+15', '-1.8864e-13', '-552.1059695430802522039660756841648676486813425712');
    T('-8.6400999e+3', '-3e+0', '25920.2997');
    T('2.8174216976e+7', '-3.80064379799368614537758774048216223e+5', '-10708016301316.282693791323644782201752565201648');
    T('1.025429e+3', '-3.7942691388774640999508942702866141989404398978535327058969e-11', '-3.8907536088099791345485455606857325114052963440160501890751522701e-8');
    T('7.5475945189824540258952479977984445146259416e+1', '2.241307785984759464484472e-1', '16.9164823608512696233027083957170305568142612592815464214011615788352');
    T('-2.390294178360939572894052478069342172015510960221e-5', '1.0258531018946647560644677321558488928826911786e+6', '-24.520906973123289161325866068624287873503133376117055452224336029773591730793542320906922064706');
    T('4.13335e+0', '-4.9088577675430835705980477517385482283e+2', '-2029.0027253474204476531440674648528319443805');
    T('-9.49e+0', '3.11206e+1', '-295.334494');
    T('-3.08616078174107176e+14', '2.076558336804330489690054e+22', '-6.40859290004299236964222747218844417227504e+36');
    T('5.34715396168270921229718951112033768e+33', '1.185276582214392362269858422207e+30', '6.33785637227742951291731320592812398407062758490420416723385085976e+63');
    T('3.09857552788127670265426890018069173e+27', '-2.775660244927720047697549780961273164125e+26', '-8.60059290864598393204134197688911975222918946093511063812459672352832018625e+53');
    T('-2.152994e+4', '2.65842427162e+2', '-5723571.50625223028');
    T('5.330956358309028663608422004436504723721138561972562601791e+36', '-2.7e+0', '-1.43935821674343773917427394119785627540470741173259190248357e+37');
    T('-9.47262472923053e-20', '1.7815435405588685078649855417813049031471e-4', '-1.6875893398498851540266228993423166652387013603958400963e-23');
    T('-3.7245117604208154109238688461979388885871895e-5', '1.099513130741858342635426870578056147376018748384434822302e-13', '-4.095149586185160991329081422183979955901725647516234149636345755464052206534381389581417571266100229e-18');
    T('1.0834155200334824535073546679153022e+1', '-3.2878072e+3', '-35620.6134735782785171514593012553956333584');
    T('4.1364165902025092463453669062207235153719556580492365e+19', '6.95e+0', '287480953019074392621.00299998234028431835091823442193675');
    T('8.42371582961533136243e+0', '-4.7071941235449e-10', '-3.9652065651577439895485473058278107e-9');
    T('-7.45065795641536747833628483446224560146193991951403486e+17', '1.27523917338709350722670736519147669728e+36', '-9.5013708935291045870600560683168551870317994342017416888060151292391323390390803175995871808e+53');
    T('2.05416636316876816247008603104084729112e+37', '-2.67555245581664e+14', '-5.4960298576321336552408203766121162314254132314202368e+51');
    T('6.02518139223983254774103596e+1', '-5.541610436514578623372748271926826526e+28', '-3.338920808512969500784406497155751094267976654888337866644787496e+30');
    T('-1.886901000866449319960349324191903886e+27', '2.9119588739125107881913973682892608e-14', '-54945781136674.553048031354602674611785517327046962179124845815195874688');
    T('-3.167630633483217259922541256223568e+20', '-1.976822247538314258143070135525568198864845149591441e-1', '62618427082535077150.84042450833457702256004904708731141210786339513630567393755281488');
    T('-4.342121805414178979168499106872259725865474348828e+4', '2.87800764291519653e+5', '-12496659742.45073888635509104978249087676725149425279111442739516684');
    T('3.48934964368845845248178606547230673370875533672897e+45', '3.60994798002748312248366391691804980174190472460657e+19', '1.25963706978427685634963685436483508162346103715778631358243181904380097203373116193801232752539713329e+65');
    T('5.42527560030712498895e+17', '3.3118136084722e+4', '1.796750156280932065622648405138219e+22');
    T('1.1270004847878401285903765398526874938853992e+30', '2.0458381647e+0', '2.30566060341436511755234793837415859085314757145484824e+30');
    T('6.25593016708055943396626471164327645453174090870769922934835e+33', '5e+0', '3.127965083540279716983132355821638227265870454353849614674175e+34');
    T('2.3033584574555686865161618899734095161045e+20', '1.3010709745e+8', '2.99683283286453354141726776018746569820565525883525e+28');
    T('1.34211871248298281139772721139220298063196737768440691e-20', '-1.478359144e+9', '-1.98413347093272458362465744377928424672132387150944450161528504e-11');
    T('-6e+0', '1.05671309643762e-9', '-6.34027857862572e-9');
    T('6.4756599396864465846766547296e+24', '2.94968462813429622e+16', '1.9101154581118175282669146567918601241230402112e+41');
    T('-3.091e+1', '5.667830565788117917508080275569794124182460349e+18', '-175192642788510724830.17476131786233637847984938759');
    T('1e+0', '-4.6172103778523998784e+19', '-46172103778523998784');
    T('-2.5570672065082385679679091913879025e+1', '-1.2063049743853270960595806834829465677969295004031501739e+29', '3.08460289104848063763132960929740754910194979655799625586510645610283250550119127523124475e+30');
    T('-3.70293468184958402068082830264510960391603268883687825303e+45', '1.411163039553177355119999727715e+20', '-5.22544456090573674099746706657675074188431054961983786246940351702162084606420487372645e+65');
    T('1.74787882197705299292198556022976167231705195e+35', '7.7333671996220816e+0', '1.351698875079142520032926258655417527276870238724265543433912e+36');
    T('-4.096618331817365021e+11', '-1.013711236829518925258935118422711554106672e+5', '41527880359650616.57506268237434302892786107960903774595520112');
    T('2.12048782119154454967332210439e+28', '-9.2197418205e+4', '-1.9550350244900609425611967419011549641995e+33');
    T('-1.1505865830923532120744213733257299415660413583393e+16', '-8.46565236265629547979844640868246149886017535754876e-14', '974.0466025596414007536363196582134432561026804409558931080223917261617484174979797491453160432374268');
    T('9.07420636404752362993662380875781571271e-14', '2.51474955483770475273773727474896143461917754897697324764e-9', '2.28193564144939774816732185434917998866319599098823390828301213887829237747907197261589099255044e-22');
    T('1.246260472438897833535289124112549387151e+19', '-6.680412909470472488789414671059720951e+11', '-8.325534548643583067029478564395020366314784333266559701669016772756124900601e+30');
    T('4.0294278740792929940247525071574944742596836e+33', '6.00085175738377949776908065147e+14', '2.4179999339419911926322112001876929096606969209945947707543711809044074892e+48');
    T('1.55945832e+8', '1.1527307e+3', '179763548083.4424');
    T('-3.211101384979001257677085706325437228950660943386036671e+5', '9.228686729748967e+7', '-29634248739434.237821402397860319787760148942989060826624350048886368857');
    T('7.1768007105380238999489810862e+28', '-3.15802039762103328762026415391128e+24', '-2.2664483033540204459973246271168430597758318255590370472832336e+53');
    T('-8.146245193307731671e+1', '2.43845e+5', '-19864211.59162123829314995');
    T('-1.7260614660794362658661235883950941802e+20', '-6.765975e+4', '1.1678488727956813788943545545991497345878695e+25');
    T('-1.0423339556844604967203052423172210806005595277e-15', '-1.65790186e-3', '1.728087403870424630609117961005471539558877558014551522e-18');
    T('3.3874450138496810026558092372911790009595011319748e-7', '-1.844083119777027949884472374398549549372684360122809715262e+1', '-0.0000062467301692130573949905677401149904072205407708817196623282883165369601854286961699466138329393918717593976');
    T('-4.5677632943648704446515762998538554442851348e-17', '3.582872388623075466216438867772511708e+23', '-16365712.9851458715575421433474376658852503648131234292126180950207040799233582384');
    T('-2.86829101569688038860522495486e+2', '3.7e+0', '-1061.2676758078457437839332332982');
    T('1.06077027679826318938182294804181993899494704147284057e+37', '-3.261253544293047623648926725904240616776040078855e+31', '-3.45944082488905300826935851931788717711099607836502248838085413796777056450136214579772327128364314735e+68');
    T('-2.18507353576174076070959256350000774887e+0', '-1.59831147321681301466931141149354431e+1', '34.924281020304184328565238680515232418857862826204480512208558649806974297');
    T('-1.99647745343238059689196134517981116780466772090884720632224e-1', '8.6467613748664636508931985451006098243078232494163917e+32', '-1.7263064130130867409299452087506032624045135897393310593388261234352860098403285199668529693824805691038528261408e+32');
    T('-6e+0', '-3.4876006775596915566721213748733893e+7', '209256040.653581493400327282492403358');
    T('5.28124391735772273591469590185765758579874870468433745e+33', '-2.147e+0', '-1.133883069056703071400885210128839083670991346895727250515e+34');
    T('6.85038e+0', '-1.5901255569632960384981532502369e-9', '-1.0892964312910223916206979062357855022e-8');
    T('7.983812710598619216930700499e-18', '-1.335137072858e+8', '-1.0659484332675135134229403579270339956142e-9');
    T('-1.960334206940101e+2', '-2.959228e-9', '5.801075874534941202028e-7');
    T('1e+0', '-9.164e+1', '-91.64');
    T('2.027899432561029386047096809176e+12', '1.40213651157523255556127427614979949106e-5', '28433918.3619651531093388731497850317019747168257172892378111473796656');
    T('-8.3594749784821954269345060852858640828490521460887e-13', '-7.164172033751721e-15', '5.98887168576894141563842978474039341215235493797906672056370436527e-27');
    T('4.550077739716154666542802337e+11', '-2.7306574188036000270848865e+19', '-1.24247035360890335495046606524591731837703486895797505e+31');
    T('9.4633378246343026774101810918412358e+19', '1.578450860979302005254127126947731754671912e+27', '1.49374137370320099547200047736473092846440961340814649863546698920428216288496e+47');
    T('-5.2190603156319182229289905569617150480323e+40', '4.04355690292489982440257971296300398805279069834596e+48', '-2.1103567366054849391298527839468485796895719049012578983409941699614247722561603581562654508e+89');
    T('-5.13097206174328014241389093854003358779365258633983078e+53', '-1.59332306217979e+12', '8.1752961173757536414155211183332535775263410017806193494494865359362e+65');
    T('-3.00025764484794075488331e+16', '1.21837943722606727484247960651563238163989e+31', '-3.6554522208630400771401722295434531318286045235250273221033912359e+47');
    T('-8.034506919e+9', '9.59917303867585553e-16', '-0.000007712462219591941585402941207');
    T('-1.03623135167581303e+11', '-6.0727847191820070012464062e-17', '0.000006292809917994193771401113453514323750632786');
    T('-1.776830835655537305590797996218970905e+19', '1.4297825967432706650609604367607227448e+19', '-2.540481806177089727480969780595820579837949700040264880146150148682940044e+38');
    T('-7.06672750227869765640275129774849369371986497683548567624e+47', '0e+0', '0');
    T('1.201486e+6', '-6.4618819204288244e+10', '-77638606610483465.130584');
    T('-8.392439e+1', '-4.559646760722e+0', '382.66557300906980958');
    T('-4.892684791905e+0', '1.325742128654573684900693679335408e+0', '-6.48643835085599458713483949506930948917827224');
    T('-5.583623025078921446646733308770747651954925640892627777043e+48', '-2.49487928392226886507353963712136114e+9', '1.393046541450079222756134578078800193311267254493670540053212261265672987328881907800860430902e+58');
    T('-2.96526320854720999501457709614986308646e+12', '1.58934709e+3', '-4712832451588571.3331953326153464351003636194014');
    T('-2.278047134327102481e-9', '6.53948173493481078043032097446045568663006609238767572331335e+59', '-1.489724762625267407514295696211403251163397687148157704642933789435816632542135e+51');
    T('-4.34649668141838505956e+10', '2.7566141566303188003001360098750592488e+19', '-1.1981614283744620987582158070935888399955230644767716858528e+30');
    T('-3e-10', '3.285427839965717144526763107629871339325200898862235e+18', '-985628351.9897151433580289322889614017975602696586705');
    T('2.6431444802225494336841837930134668e+25', '1.5757672131509605631302369006921e-6', '41649804115556309200.4022799068651144359462695399494757742954037228');
    T('5.4197814884600979459047471764155193322e+12', '-3.45317672489168691123605172192567891610375269351773e-14', '-0.18715463289949233044577799707655967434015297575177174844144791767778460868554918438459906');
    T('2.1804041368605641467299918902653637965488411876504e-18', '1.5595945850567196835592942943641516156866395747026257882e+46', '3.40054648508300657595934821590957250693570708065275875065240265811212908037363934338779869619908640604528e+28');
    T('1.6644802913995172764608435e+25', '-1.64481887574951745057302561e+14', '-2.737768601606983206750201541817125086018588487702035e+39');
    T('1.345297580765936668864521475544600213e+34', '5.255894981691269736920878216903973555596e+1', '7.070742803629092178385260348541240791936901232154070386845812623023948941948e+35');
    T('-1.236303590387333100113303929204537712340659855471201673025413e+21', '-7.9e+2', '9.7667983640599314908951010407158479274912128582224932169007627e+23');
    T('1.8325580806128635358765e+2', '-3.171748e+0', '-581.2412427067688694189217122');
    T('-1.0243e+2', '-3.409589101402e-3', '0.34924421165660686');
    T('-1.273997601117917175698667546852761764039275631891486e-10', '7.856245279828564906705161224850856859963860198e+2', '-1.0008837640295551637408536690012436719563557239798756225068083188519724150459019497133976810474228e-7');
    T('2e+0', '2.0782554146127983844e+17', '415651082922559676.88');
    T('-1.0017426e+1', '1.05631201445e+2', '-1058.15274376638057');
    T('1.23321e+0', '2.76e+2', '340.36596');
    T('6.5482994824671797204789687e+6', '-1.810350618538593530488926394601031399259372856417988086e+12', '-11854718018460410708.6469761335753156476928972597617168054353701088346263301669082');
    T('-1.8464263e+0', '1.2578353631044943640519616250643946541369931149527985242e-12', '-2.32250029550618804198731651110963748297794789036777045368406646e-12');
    T('2.306905117986512123647e-15', '1.92224194054550245e-13', '4.43442977065274435217191058558414143515e-28');
    T('-7.7660157326825169689845327710896583341071831411984679e+23', '3.6431726508659866242336616738158288e+18', '-2.829293612350392270265658763343483917211646344882471424632373955590786112801497332869552e+42');
    T('-1.804410431608216174757910743628838673593296632e-7', '-2.708299883920527521842766517861172987221865596e+20', '48868845624695.20830931105195115261702836652954741973993651473991827943522861106002863472672');
    T('-1.800090865364229e+5', '-5.8264534155111055348482827550238e+10', '10488145570731753.6804095274061076304171665636502');
    T('-3.60855354781654573978597356957428456e-15', '1.866546962201332812e-19', '-6.73553466261781541696603311041890681571157507335298272e-34');
    T('-4.513629265554556014503659605626189283778885640833465154e+54', '-1.6679267957795545731497e-20', '7.5284031982332348463844383049275530663291324432825482209928639026696189755538e+34');
    T('1.0941972e-2', '3.45343163878253161341020408675072450114411418654261458e+9', '37787352.29547257500304927763151199847123286539395206554115176');
    T('1.24194883524432e-3', '0e+0', '0');
    T('4.5115e-19', '-4.72349600277e+11', '-2.1310052216496855e-7');
    T('5.7379616e+1', '-1.014091e-3', '-0.058188152169056');
    T('3.665008e-19', '1.20318611886502374360861219376e+18', '0.440968675112926294051551255902795008');
    T('3.33610310938677239000000947724228838577011e+13', '-6.096671817812092833664313029588e+1', '-2033912580831362.881020502005617192477576549025176845225368255784259601468');
    T('2.583458940580655231541895311105492814e+17', '-1.5156221815587830068151379463e+26', '-3.9155476754903950432396966951972758516587513180224498790533678882e+43');
    T('3.702736747441730847035655529e+20', '1.0018677975945079169067e+10', '3.7096527102316985801620293314995993182468964321443e+30');
    T('-2.83630154283079925e+17', '6.41074464694029283507262773575118086890104876e+10', '-1.818280493281103999466755581106175564517622369590252755402143e+28');
    T('4.4674110594344555786220486754e+28', '-6.727853004096336279764957767621729768e+4', '-3.00560849167492982673836524473329588821711484064022839144411493072e+33');
    T('-1.5688404306246196345593833419224858e+19', '2.63605019e+6', '-4.135542115227710406357993024757603658362302e+25');
    T('0e+0', '-2.64954402306017667049973249287275628634791783589648e+50', '0');
    T('-3.5009076896538e+3', '-6.6430229e+3', '23256609.95315628647202');
    T('-1.521924675204764636287003e-12', '3.7693609744915860629583e-20', '-5.7366834768326222380785330790588380575060209749e-32');
    T('1.11236129544558345600503719108591547020411211e+44', '-3.1253884214607362312987e+14', '-3.476561113266691720093444060759595557505158595083676675212825697257e+58');
    T('1.33815573609017992048200249790557568805710357380887861899e+52', '-2.5e+0', '-3.345389340225449801205006244763939220142758934522196547475e+52');
    T('1.611548475376932804e-7', '4.9802375112902234248e+15', '802589416.83347697323623227532963471392');
    T('4.166575179521503556226149051605877512974975774232e+25', '6.399872460241347446318418520381529620092936e+33', '2.6665549744944818866755013936324316057322003893851265592949522620090738985837783100394025152e+59');
    T('2.35506389265e+0', '4.006712248230173437693154988324e-9', '9.4360633440453853293582738230620847394186e-9');
    T('-7.242328039718679745240983432e-1', '-6.92464621048019340876524126396387834446077132758404786e+24', '5.015055941529240335287534191035479214939020902123532657328599638598099582175505552e+24');
    T('-4.193894403896958727143737666044e+30', '3.261588840189662e-1', '-1.3678759184684195494824524833564292922177237128e+30');
    T('1.5765195258987684156516463952714058260238e+39', '-6.4745770126610248e+16', '-1.020729708239542312739313896297935609020156882675181719024e+56');
    T('-2.040489518370981132782249800266e+7', '-1.174334689904e+12', '23962176258085484397.98077967950839046714464');
    T('-2.999e+0', '-2.745829033902881255806415521483615257e+36', '8.234741272674740886163440148929362155743e+36');
    T('-1.421995402238039424217983713e-10', '-6.62685949e+4', '0.00000942336372605751879737308119715948637');
    T('-2.91998097054133242068815e+15', '-2.008599636825475699484477749463054e+31', '5.8650727169666203572881875569551215932356120857036806101e+46');
    T('2.6e+0', '7.4773359790825494286810609654593232269035859893021495060685e-13', '1.94410735456146285145707585101942403899493235721855887157781e-12');
    T('7.50302677e+7', '-9.16389319e+6', '-687569359219906.963');
    T('-3.4496300003784699749429090893221619407742937e+17', '2e+0', '-689926000075693994.98858181786443238815485874');
    T('5.58909651552271e+14', '-2.9302356759838764984959768e+18', '-1.6377370006301816824127798758929684033128e+33');
    T('-3.21467608558886180085443357632011447658817714543954802587541e+59', '-6.05654450954627843543147e+21', '1.94698287961429431939792169536178895975298009949974623312844888292490502665078131527e+81');
    T('1.4473044599244751554764848267885956615840337279448e+31', '3.2978760548379995995551379e-19', '4773030722445.16982161490157947831158781808944842335126216028865139564758792');
    T('-1.52212585961814532229294847288693e+27', '5.4807677063154665054707604339457540829262049e-20', '-83424182.56342800099858567431320449627410280372645389871308978482983651711957');
    T('-9.90550793992759173966e+6', '3.335265462233194052458441615728696e+23', '-3.303749851791717304829547839188687665630386634122328336e+30');
    T('2.51287438279233642085429923935090523723e+30', '-9.451335136867210002148028438967398611467216454584204034e+38', '-2.375001794861871280485178924285492901455882867966860732042873907744155803603055976356149298582e+69');
    T('3.4082333651834518484189e+13', '4.35506385179170328272063457227625384554944253e+44', '1.4843073927180842671942017049002743738759608944705687993398956915817e+58');
    T('6.5818547070316952187958008e-6', '-3.73951282e+8', '-2461.2930056322368417019602053766256');
    T('1.97206174719719816981292592386e+16', '-9.0105789e+2', '-17769417968792207968.034967276795922554');
    T('3.6619571048211390692219928266376703435e+7', '-2.4799589894315235042761055970638006e+26', '-9.0815034410138196343173744241842493541845089867523197724164419200175061e+33');
    T('-7.84666331967208510490549760574105355103150267368e+19', '1.619717764380338390313718e+9', '-1.270937996998447419567301371334187807713815536655396765563064753098154224e+29');
    T('9.483006538328174932945681176608e+30', '-5.3373488401022043702090517246506626e+23', '-5.06141139480275047286128600549610642611475683804095134453348204608e+54');
    T('-1.4803912145480433328776377901902060963e+8', '-1.582058e+1', '2342064764.1054483391257298870727370763001854');
    T('8.9882523984348881655495577517148277303020468059964733526e-10', '-1.9880593317254807355650321572764e-8', '-1.786917905661241317492297819003818060408519912904334361445796515881479577099002479285864e-17');
    T('-1.28471301581497146597153639797443e+32', '1.42004323959128318e+2', '-1.8243480329229795026092654483949144472588365290874e+34');
    T('9.7783e+3', '-1.36173859052909811217858436668287617315269353636409624e+45', '-1.3315488459770680070315851512735168083938983206629042263592e+49');
    T('-4.67119137023742882426401e+14', '-1.212047464364320398948015745451394730100809445563379321597567e-2', '5661705655856.77098789712337972493426181265394901439758588512945491280590876618166367');
    T('4.21209472e-13', '-4.905686e-9', '-2.066321409857792e-21');
    T('-8.0534398142355474142562564558981481e+19', '-3.52823954947651480531133809737181713783475797e+44', '2.8414464861914654893810641177621530490552863751100871276411283589068922334715357e+64');
    T('4.1668071977029939763287789711116957000695558377e-7', '-1.3024216206228e+9', '-542.693978325508121622979460863479145783998910882101044971956');
    T('2.14936794322219777817392300235280096983947067201554505296068e-1', '5.56270924878341e+7', '11956308.9368006948399328359990270847329026003904275869850287225663085663188');
    T('4.4808187810392761874440073637915549517e+38', '-7.646754766255997951108787766099794e+20', '-3.42637223706414760467636032872081913139464887999833237904238953370499498e+59');
    T('2.6590306926035e-19', '6.065851175402e+9', '1.6129284452158934622539107e-9');
    T('-2.99e-3', '5.30673982e+7', '-158671.520618');
    T('2.7453398931708285228618465251335055626300456581132e+13', '-3.22074749108902263854425833e+12', '-8.842046573116551400389407780741144904662936292441998341089622224330041182956e+25');
    T('-1.927554010995289666334e+11', '6.691946123062138e+4', '-12899087590872802.405021000232368662092');
    T('3.1043442867282686296635094758709963529734603e-10', '-6.9061694467717526338079e-19', '-2.143912766526321799419146642311363281841178348205083711921322847637e-28');
    T('-9.9460755574581062016784211082305572914306783520097982603599e+8', '-1.69419433e+4', '16850584815197.112739421417524916526495882012852028744317145606339367');
    T('2.61564884146360410916221e+1', '-3.37673411255562774e+10', '-883235066943.67590562874468917360320357054');
    T('-6.63e+3', '-2.3664010008e+2', '1568923.8635304');
    T('2.6042340596970639861661053132244e-13', '-4.19696881552846756035609e+12', '-1.0929889136885679117123078859859216841502622841450076596');
    T('9.66932408746122723475707863151647060844849114776240053344e+35', '3.543132415517187808951809e+20', '3.425969561042502580998764203892614576219316524854247783921994540516844698885299296e+56');
    T('-8.75613931133e+11', '2.85579203853134364863246620418932562599339642887412e+50', '-2.50057129335675362001562521254298208477229393538495184240597796e+62');
    T('-2.50801681357e+11', '5.6482598133343504471083657127414336e-11', '-14.165930579254300605382428195360012246785733952');
    T('-2.30985517042381424317138251138e+7', '-1.356837662673868976569988292803227160100334665194252e-8', '0.313409849055299940654534970732121932438107278390194102752542104703069838330058776');
    T('5.862908424337665828006849479349960917695532524969888e+2', '-7.671778766584342308528805252661904591265896365900259438e+11', '-449789363602621.67756677207730170927431389968466555033513219445179870196178056661700171117319697232337802944');
    T('9.581282282850454426590480159624386252965047e+42', '-3e+0', '-2.8743846848551363279771440478873158758895141e+43');
    T('6.80255891e+1', '6.4939628006286648775556960482793713797e-10', '4.4175564510625077864220559174474627948177228127e-8');
    T('1.17e+1', '4.39880043917181857989519e+14', '5146596513831027.7384773723');
    T('5.18057e+5', '1.12095183227955985516792e+15', '580716943375251939888.72713144');
    T('7.9079109607883946443459466318246948653463050994769e+5', '3.36736267476382737799206797447753274243e-8', '0.026628804204714596632325780373652132822901517398195299752987744361561977288621298015434867');
    T('1.9192337832e+6', '4.3746589806622647519097525128325765043728672520610978379588e-6', '8.39599330566629402128776374017937235269096935960460880109100828973216');
    T('1.97054154322487963934e-16', '-5.29966794868061391983563001785802904827e+35', '-104432158581725291847.012347689094982662143786123082010509418');
    T('6.9435803780806824e+0', '1.312029461736620484829099495123927022691450102807689e+51', '9.1101820259781574883358006463573816901697004118371527017012130869736e+51');
    T('-2.02777011165205949332910260826373220997764e+19', '1.719346099690327466591195210611602452021664087e+46', '-3.48643863253758833917742037463014837753623268813161576588808665593545590271493786101468e+65');
    T('-1.35689510306015930639203912344e-5', '-1.7775524374291928790914680036598415373039480612e+32', '2.411952197780322048592902790431885908730809493500413918235779385964135474528e+27');
    T('-1.197093336042660715753664692387461089572e+10', '9.30322759e-19', '-1.113683175167722258780864100982789097855769169148e-8');
    T('-7.22954e+3', '-1.80621201849899035625232371577275379091004324e-18', '1.30580820362191907401404243961277544415357940053096e-14');
    T('-2.5487146811e+1', '1.23224022125341461664322693e+11', '-3140628742550.490076943920877369882023');
    T('-1.18509703682338023839102000456883783748380745862220202e+28', '-6.3419775864e-20', '751585884.5242932927360537668009595161218552675515150636252804528');
    T('7.1388416426585452586630469980942729444722426421412280025841e+11', '2.2273053664463959959973918980036896886955225978954e+4', '15900380300904382.68571628113627797346230258274544097276905843398058418502349718417824485312566047149642150314');
    T('-4.048812287518331136928265811389922096053793e+42', '1.883843038956722868136968070669521788203167379034479609892e+28', '-7.627326843883853713943674629620475969636818573439332541709592124635715493176124730990752735286920356e+70');
    T('-4.40496773173133229276988080861e+25', '2.6836361405552532182670933448535260065953975259e+0', '-1.1821330602853900620632833373905984586754469500681938106134905203144285417999e+26');
    T('-2.10698470492551613923273067e+22', '4.9829981981459258350705361168e+25', '-1.0499100988164872148563717105895284884047064402922062256e+48');
    T('4.153010660772414005280043833935812744967827327617095506753e-20', '2.527751586e-1', '1.0497779284442377486895243175380771288291439046358254767908369460258e-20');
    T('-1.775786834688476262481212524832086861722161695595273e+16', '-7.18e-17', '1.275014947306325956461510592829438366716512097437406014');
    T('-8.4572173659763154903842071410504969649015559593e-5', '1.55e+1', '-0.0013108686917263289010095521068628270295597411736915');
    T('2.1957687570313298348687272820162816911371646883313165861e+55', '-2.38569977592e-5', '-5.238445031621780511465933279321833876337532446936158618177349386712e+50');
    T('-1.27304464823058989292690796372853e+19', '7.469e+2', '-9.50837047763427591027107558108839057e+21');
    T('1.075014243303345850436753650150338343736e+25', '6.02230306841873236690335765889046842703055475561e+27', '6.47406157603958142830356266103466419129027532770065365087223464829450025112366565435896e+52');
    T('5.4644781816078472076480587668e-10', '5.533388289372726449619555652757e+18', '3023707957.76416324809553379608185627596205958651886704400676');
    T('-3.51050282698153075e-6', '-2.38e+2', '0.0008354996728216043185');
    T('6.8429855416436924582601339528425e+26', '-5.06163347121826253493439522309e-18', '-3463668466.0646345473598332283493482158871668931014551327133325');
    T('-6.6943286454175063790486144e+19', '3.4328180225062095992833728348740385020789e+37', '-2.298041202256879703336604670399729877443829865654374596865856447616e+57');
    T('3.4586536216937580446126883522083952059e+12', '-2.88703672447082268049428783480859803803275492e+13', '-9.985260023053895125434393341048712560458518029877932175692101389180863832497638028e+25');
    T('1.544220975398677252000528288503556128937132048384443331e+49', '0e+0', '0');
    T('7.7e+0', '5.629239278180308472085767973107775059451282267e-16', '4.33451424419883752350604133929298679577748734559e-15');
    T('1.072717719201024052696349931792614756e+25', '1.3771846282397089347926178e-3', '1.4773303533240107890345190437679728361254161112010424681482568e+22');
    T('-6.2982194473322433078922784904265197191653069665364692e+7', '-2.8678684613182319044997019428886e-19', '1.806246491546528554076417787115541085256514512890108233024447001160805124352749293112e-11');
    T('-1.732465708088e+1', '2.71524489294637185383888961456871107141931061365e+31', '-4.7040686660906618703715451371754514270759411014339610482012e+32');
    T('-8.96598237114090468243115825396177729e-12', '7.604366591101533e+15', '-68180.61679950920120868401395898211540605801952358557');
    T('-9.71839881931499436381251357007593505557676492579357e+50', '6.57868431363921445315728822689471152257263421455e-10', '-6.39342778663174158137496675720663924284622907149091698424887623612741936565068134530253299923904435e+41');
    T('-1.006931641466488693025e-9', '-3.4521295426580450451664697531545584755870088979e+4', '0.000034760584669436241976889349243420680611555496619415686043504166671475');
    T('6.00947607e+5', '6.812758675764029679963178704882229955116307e+38', '4.094111023268882532850848090812335308350862098327349e+44');
    T('-9.6836087377e-15', '-2.6459022649270745998e-12', '2.562188229174803984792301067246e-26');
    T('1.055921827168468904939466656863008144e+27', '6.32912299980432425349782865630544e+17', '6.68305912232736312925806512224733448892859379422335164811681167150336e+44');
    T('-9.98028905218791239e+3', '3.3600371506928e+6', '-33534141990.004018666701074203792');
    T('-1.45239016384017840495355131293445684596538291022094579841e+42', '-5.6775437718634921734497447e+2', '8.246008729026601881844137255200165069034156821222471237266712949036717046752165927e+44');
    T('-2.2979549681655763076566677319272798755304678418e+1', '-3.183497604578998e+15', '73155341365855197.813621009301952050894390937967417408666665164');
    T('4.0066264588364721690045277668336e+31', '6.737893728955e+12', '2.6996223291259444273370994565149283876986888e+44');
    T('5.846436541728802080043719344611e+21', '-1.2e-10', '-701572385007.45624960524632135332');
    T('-3.182300165687177420393599644356615e+0', '2.365832971505851366517267883747439591747414512839432822e-15', '-7.52879065721125810057489253493734512785942465676134438014645481107031765439734970381753e-15');
    T('3.825832626826099559783359922877e-15', '-6.5955112433918682619536836375146720871309857645017e+49', '-2.52333221055669854343885405756298648535866081882102237578852058574273365963353909e+35');
    T('-2.86423604077436742725253566687e-18', '-3.9616e+1', '1.1346957499131733999803645297872192e-16');
    T('-5.81865579e+4', '-3.0827768621936331602e-20', '1.7937617438481015688733727558e-15');
    T('-3.65098386509026325842574744310157864397940281992715898768e+16', '7.543511472508780470316703042149589376987868468e+20', '-2.754123867225285049343404492717016138666722719241254048568925571123034276751089068825616530843187247424e+37');
    T('4.71978532088277616359995233744199725174e+38', '-2.90845032007102932970578279149703516018735003308119692077e-12', '-1.37272611271880562032081502654149993248115310939203471275734361729098063870184524627400905246398e+27');
    T('6.66954264794400293153673670798603436474391677055481161e-10', '-6.0831130005762409912165773287576e-8', '-4.0571581589605851371281721138429286134755181825367445092430588795115847031409503355736e-17');
    T('-1.5359590725191838049406967873638064365696777077105943281364e+38', '-3.46671719279686986011120227659402959170189585e-3', '5.32473572413458873765078208479002392295654434125039963877442769432916923725014543243576464416487739394e+35');
    T('-3.8918273124023755760911999559263803895614e+13', '-5.9049071497197518967775767842381303529437097e+25', '2.298087892247939399387630879792186664312313395569266522629770751383705096713167192558e+39');
    T('1.6494930061e+4', '-1.4134663182e+6', '-23315028062.2881714102');
    T('-1.38082e+2', '1.086557106158916053738635237440757e+4', '-1500339.78332635446532338230856294608074');
    T('-3.236453714001566320662909602293056422741e-12', '-2.6292012409417075744241522002879275006552063e+30', '8509288121103316508.9776133643121846506311098158231648344441177311116642919353664683');
    T('-5.56185157584785e-9', '-5.3863586550733398733233e+22', '299581273738013.61300657427800794659905');
    T('-7.306228492885575e+1', '8.01710749999e-16', '-5.857481924695357768938364425e-14');
    T('9.078851355998902214e+6', '-3e+0', '-27236554.067996706642');
    T('-7.471572766864317095e+11', '-9.947035107615899737979837388819482785995e+39', '7.4319996621106228158954275728754194694522889053163705084525e+51');
    T('-1.265903731885e-16', '-1.207e+1', '1.527945804385195e-15');
    T('-4.726326821555207871753620716339193235463e+9', '-6.4126109518e+10', '303080951376910103067.328380769000717453065099436834');
    T('-1.91406e-20', '-6.456816473704e+1', '1.235873413965787824e-18');
    T('-3.1983053456730161e-8', '9e+0', '-2.87847481110571449e-7');
    T('-1.1250473182304781788249e-4', '-1.657377060472918137667968348296e+8', '18646.276171817696089408668926562813557672385751973704');
    T('1.1497865844851967254212601851139326807506796369434785706622e+39', '-7.76071990827718702947360345575041554086866713806786843198744e+45', '-8.923171636484296086155235679649166775015520367811462823386249811629379239580605875232547783752918665760034624822882768e+84');
    T('-3.3497708586119180439409399519615946383638197694153e+35', '-4.8561981458432843062333291774478231682e+38', '1.626715103259106287442319579436450524467374682092885927992940109533202075360145310755346e+74');
    T('1.06339694463513e+14', '3.012233219e+5', '32031996016130424203.8347');
    T('1.9633039492389670984077672122431784083773501182422065509489e+19', '1.6692272776747540826414430546718929e-7', '3277200506436.25462718284982490613239885158226875205709983451693837979539541036807585665417281');
    T('1.1467e-4', '6.77733085233686770034e-10', '7.771565288374686191979878e-14');
    T('-5.1701628249523227514579183256087778174687577e-13', '2.132619358400722076540485378725800253187225047660162663738e+9', '-0.00110259893265770873100902961300808852480005642266384867114383755051015481735901792658688929318256982826');
    T('2.18348342946585692342012771e+25', '-3.81634959382e-10', '-8332936099154723.6892526392312710267522');
    T('1.023307551757890323892037392256508719427002369e+26', '-5.20694036686411877720526e+13', '-5.32830139896505265680420021857733687673247020557939546162596921926094e+39');
    T('-2.8265491339447e+7', '-4.5434392049769450607387334481043271753316588900535258158e+55', '1.284225414995798036336141936613726795940619730566835387167617353958626e+63');
    T('-8.02970908483254769090703403995505109862035476919e-11', '2.3071404145426391103284923337981992716315980206711699715e+9', '-0.18525666346637359394264144605477583625489813085571289205234643919692091911432433571550028203557141378085');
    T('1.587431829883573713849409705849497e+25', '-1.49418e-12', '-23719088915754.3817175951099428620142746');
    T('1.6140449345603180298849693965438089354593840997322e+28', '-9.03841799979613578000119003816765e+23', '-1.458841278900975455540967582013269342009334677839779329905619862068104285214370333e+52');
    T('-3.723294e-8', '8.1668979393732624484790294912e+9', '-304.077620962808318348472796304080128');
    T('-2.145634432722793043073725435570720754433983080847542e+20', '1.465950677153e-4', '-31453942495727714.83031405298777297962982768524603399340055607926');
    T('2.278200008209245655472133211650862842e+14', '6.7270967926351916022156783304e-6', '1532567196.82058836270487268466918972063318028121075008094819589968');
    T('3.1343999e+5', '3.14336961975866116898902330896465119306450054556291e+20', '9.852577421834585592213077760716471803076251203562330547709e+25');
    T('-8.041439619908106697385565e+20', '7.78883706e+2', '-6.26334629272925752390308937810389e+23');
    T('1.77601311247551979976524852558057621908110590977554e+24', '-9.63987036475e+11', '-1.7120536170360171827608873268662828982548556336301315370428215e+36');
    T('9.807194626e+5', '-7.62599457122846035815911841262358376674896189395e-17', '-7.47896129768569306427921413491796612781212565774252219127e-11');
    T('-1.92719707950824442875770342240518e+16', '-1.70525973966481953e-11', '328637.15900850293995476091245818788722108232371654');
    T('1.16239377795254501916971749785697228868532854085e+35', '6.473102172409450243517628017455112739783779499e-12', '7.52429368925984729196132515935558757033934932864160658040770594113623888987378706054781403415e+23');
    T('-1.179784405848068e+16', '-4e+0', '47191376233922720');
    T('-7.538813675402315501713570566310033336449e+12', '3.41223043965380709597413486586383914131435e+12', '-2.572416950208617640223348424864689151961024519972222888201004983894402712962174315e+25');
    T('-2.519610125898322011290936135004574898e+10', '-1.363124864524128033329953790490685211016e+16', '3.434543211518771369514488568838182872952969792353237320906862717950506676368e+26');
    T('-4.4018359795112479954572037e+25', '8.064374150981933179268739012e+27', '-3.54980522900327467667853946121209296167777117106207444e+53');
    T('-5.5876311411746274e+7', '5.34197880056852641608623989794750613e+11', '-29849007101551382575.802997685240605484431232661965962');
    T('2.983561815076415871361124408351471429654035718756708688e-8', '1.118284411811800788510463e-16', '3.336470669476878476744869376687068610902363203935757551720993296308551931002544e-24');
    T('2.134734577507378691205480523075055640400370419357e+26', '-2.40845e-11', '-5141401493197646.20883383956580011775712227213650036665');
    T('3.47245322842069354627e-3', '-1.00754361885679357737028320286543060818544720573186927742e-9', '-3.4986480920739416255076813924095074265312312003153482496363088688338822362234e-12');
    T('-3.794245568368302794408011786555814e+20', '-8.37060859067434635093e-16', '317601.4454971178330815419624905170794066260320367580702');
    T('1.28940799891798555024002319648354556806250881774458599981e-9', '1.0028654150809960226369756911508906070980659188266e+9', '1.293102688043642049274122897660291144835301385402718280038596441757921696250413746340720089018990263022946');
    T('-4.27636406710816966834122598758048794168539e+7', '8.8982999317788742062040151406652152536669424005e+25', '-3.8052370086610255197545273472972163674292703635630344454164911934066209770042628022378695e+33');
    T('-2.948850630230385521369167273e+27', '6.672909985285753803977844488e+27', '-1.9677414815580527680894543930730406872388735650053041224e+55');
    T('-4.58435850212e-12', '-3.37588403664294220132546582786902937780785e+14', '1547.6262685555257703338148001260909269985470795177642');
    T('-2.5407577921477732e-3', '9.212688937755560725e+17', '-2340721120523603.242830965922612757');
    T('9.70814828823927437608576282702e-4', '-1.0450399929711279076844e+23', '-101454032189042387227.18166504580735273535431725952488');
    T('-8.986580647129736635012468025475589251e+25', '-2.32842674940416e+7', '2.092459476445462528863223485743121453574148915068416e+33');
    T('1.13e+1', '-4.694730618579590045444086579344431326591112917465804e+45', '-5.30504559899493675135181783465920739904795759673635852e+46');
    T('2.5304029888089e+11', '4.387914643257e-16', '0.000111031923279358510068465873');
    T('7.292170304772241302551375e+0', '-3.6216283825126026376967892815e+18', '-26409530945878724879.8331593964512856913252717030870625');
    T('9.49e+1', '-6.3604126376648187672456674994000370673e+26', '-6.0360315931439130101161384569306351768677e+28');
    T('-1.176852634451796072215996403677e+9', '2.44904391e+8', '-288216377737162735.922250619700705845707');
    T('1.373680713942569963597709e-10', '-4.5471428840104475371083297e+25', '-6246322483306348.1748793733532597161392782837366573');
    T('-5.3314956749576410979116539202451154407e+37', '2.70915269844828616659642472037869598192445e+24', '-1.4443835894576860174475218340998015353555909569592060809911322322844730795855115e+62');
    T('5.9e+0', '2.208687915206977e-18', '1.30312586997211643e-17');
    T('-4.933577839564e-2', '-5.81527983789613597327083109083065394990114741585e+20', '28690135739107706650.0330893037590591643386059592539244906894');
    T('-2.999683795083396322669132758034104118057863174352390023e+27', '-2.87555441825734267003450825531215971389862724174149604e+38', '8.62575399032701361118218619119383526371855243131272664024482478550553556850589314665513164176854330959000892e+65');
    T('4e+0', '4.73e-13', '1.892e-12');
    T('1.08754268552842900657636111617643472953987707185276968598108e+7', '1.81351345637832644608e-15', '1.9722732945916286331432129685647633013480203078627843626297182977144595945201664e-8');
    T('1.476869487377797869802075095495419497297018e+4', '9.16978415362210821336e+12', '135425744223249370.6870672636130364222488062879808291121723576048');
    T('-6.44960562766724813383113663723696894522318058842884424114e-4', '6.2987e+2', '-0.40624130966987695820562180336964496295277247572336761221668518');
    T('3.45e-18', '-4.5651228859493759221433089678212482448435184321088e+19', '-157.4967395652534693139441593898330644471013859077536');
    T('1.1116801887311179022882314500092e-16', '-2.3731060633715843891182383816509351972782343643683136984815e+27', '-263813499640.78831745125440250018216990705243508298365311908844491303220133333740292010298');
    T('-3.411622226349151970376832394365767151948e+39', '2.272882453750169129e+6', '-7.754216297093075438917262330382150382606746020237641813292e+45');
    T('4.813825375694300536878e-13', '-4.994458765e-10', '-2.404245234081581727695453283567e-22');
    T('-3.4004823042485333889969440789299923572353e+11', '-5.055670795945782666596715941784e+23', '1.71917190777197318977613475600295720724871164612058192437613842059897752e+35');
    T('-4.30182750049173941901359056714e-6', '-2.73059273e-2', '1.17465388985568150826129341738290608922e-7');
    T('-4.383659202779121282988e+9', '-3.26708101440047648993067e-10', '1.432176975500159562983467763399865447357044196');
    T('2.1032287098642227578833893517123706840232e+4', '-1.38738398481150077730631608976218467847e-19', '-2.917985828461377201803501253006512530189396739380234897663356402988476658020504e-15');
    T('-1.82989876256793e+1', '-1.42680066252682303444e+22', '2.6109007667889361627836979692295092e+23');
    T('-5.401957277401719742017451884201647908e-4', '5.57331798132165019229595829181742725699386949139427e-15', '-3.010682562847435019555936026646401099636466062637082424633510028806828395006935854868716e-18');
    T('-1.7025584579461e+1', '-1.89357506715785170663032403281086721920633943e-19', '3.223922246345454748113384654355437033006187500650177244723e-18');
    T('1.75701556278545512743452095698613449533241870186405314374e+21', '-8.0008069425919153153324522596175843489e+10', '-1.4057542312975910661097788666304204083938593139961296775572442278829856249685309185751666010886e+32');
    T('-6.0477171077679290199698548748670345744496299140266e+49', '-2.133215459449e-13', '1.29010836286647401512022142630193335625187354733582678886073434e+37');
    T('3.1064394721189e-1', '2.338713865381214106067869220656146181070789175e+10', '7265073065.4119709049662500151915998866163745003396324329075');
    T('6.6922115778644e+14', '-1.502476598814833512714989209432e-14', '-10.0548912900589540851343695771817446668970208');
    T('2.6e-17', '-2.671783935940821017261675012382562970940216397519591773e+33', '-69466382334461346.448803550321946637244445626335509386098');
    T('3.5201757425530436264024119194857657081987590263e+15', '9.331e-7', '3284675985.37624500779609056207216798232026204744053');
    T('-5.533255769459408437481792739718320122946890691e+22', '-3.531878e+2', '1.9542784320526756553356319177970861039193418399947698e+25');
    T('4.645259e+4', '-2.1e+0', '-97550.439');
    T('7.9497003230879251678395405634595e+18', '-6.1333445694821304513176871453320732006332281e+9', '-4.875825130562166374225780425406151552485642713795500618653851261127238861195e+28');
    T('-1.005369818933571484481949e+22', '3.135206365030571431738055544939894677892415929474640739e-9', '-31520418555301.66425121334176205932818570557123668182427124267161869460305520311');
    T('-4.60955142802279111987154280657676965775556e+21', '-6.999600895208299766764771673363791869163449812613584345e+21', '3.22650203020970252903982709059471354761827496584870916987798376422723879587819595266245394527082e+43');
    T('-4.42474356385592335769671439693513e-8', '1.265050947084194578462859951e-16', '-5.59752603606063023437875039568685608110784446235152882197863e-24');
    T('-7.077847732205e+4', '2.48584792112e+8', '-17594453071105.7057236696');
    T('-6.37752233724066550730707883629e+6', '-7.6039885222e-19', '4.8494606652452138136652467701959692830638e-12');
    T('-4.9433724780681818765776307e+5', '9.9959526923402244116455519e+25', '-4.941371743138620958161734043507096664065327269588333e+31');
    T('-7.687435480669860197725359437664161385731838770011635683114e-7', '-1.35484826677385443562865421591361401540341e+40', '1.041530863692139265267608718767277789101867106231335917307662291374878215844509357688744319363501874e+34');
    T('1.5012510295250038070878447757125272e+34', '2.88320380186540202497627762051674629931756151e+44', '4.328412675880839882083804634396863682183719498695681206471762208157714263548072e+78');
    T('-3.38921068317929605930700761538953746656360127100567655710865e+13', '5.69632435242926704290367713950973308658385274436e+8', '-1.9306043350107657372594071514185142475260849897600810020660411944811434813428061119686645756800301569194714e+22');
    T('-3.76914657349036275475693770766652109404782733181e+48', '3.827777748906093915789127662698600476674896035688672166e+4', '-1.442745538637205802306364313516282574241071243477898711033577246633708775227079459568580532954159340046e+53');
    T('6.662411223035412967621756635110157016806417500183356102e-11', '4.11713781541407721882458165080172938861902902e+10', '2.743006518819825052303708822086363491806643065891389452604894242568840422017902043029187832413208004');
    T('9.26006e+4', '1.782395040553430407053890679803958035e+8', '16505085019227.1987751434509284254396415821');
    T('1.669194958318640515063913971576976e-16', '-1.244248914671339151175490292104155e+12', '-0.000207689401526283965328871962139541102573486386336878117842659193528');
    T('3.16363014327124199446241593475618574106690619648e+25', '7.05008522459e+4', '2.23038621291441279938178011816995585372014349584271634674432e+30');
    T('-1.2499416265e-6', '-2.481016161522992373850612e-15', '3.101125376306835804917930031300418e-21');
    T('2.394272820993002468870139325593176e+14', '2.11414e-7', '50618279.4177414623953711635380955710864');
    T('1.1378282788937355438301626273e-8', '-2.48363251338640047864014818842048577888e-19', '-2.825947308110970660255163888048770257922851289911580643177307651424e-27');
    T('-1.117116020795727380964220670027372e+33', '1.2858e-9', '-1.4363877795391462664437949375211949176e+24');
    T('4.22729745775217473e+7', '2.7e+0', '114137031.35930871771');
    T('-3.209792098971668208636730400079e+8', '2.561617927875316631903780965290528364325200943605912675e+5', '-82222609854783.67957523073005932482022485150215647664198292591044805997494462687101325');
    T('2.791486045907779287369132431599698256688456376693553e+31', '3.01582028398776570554202910416394185546415e+41', '8.41862023971748410598194194885358670636908149176554482057465593277092965649017887260312762495e+72');
    T('-4.7987451889500086409222751881136004594238796502777e+3', '1.5763922061071358398417356638094106322793630666033e+48', '-7.56470451495490854118717493020497246765927486273345255064102022092233152887091090239341261644073641e+51');
    T('1.596e+0', '1.1278061910963898e-3', '0.0017999786809898381208');
    T('1.0019691597360265022444e+4', '-4.78747885958105888012393959e-8', '-0.0004796906170188423978033721353034376183189305015796');
    T('-7.840057154240753070926001e+13', '1.6771465194137118428e+11', '-1.31489245682394495937803684715730739761446428e+25');
    T('1.579380351053037416538973330388820879276958625730937001789542e+60', '-8.95594912974988579348053906659158935e+17', '-1.41448500805575195712136077006981122282508931148355054995764602589961835792946511370273959885777e+78');
    T('-8.6259000350458193370640181250303642061228049e+9', '2.50287016417625378022383686736285763674288500041793504864e+46', '-2.1589507836883083080681542896478167565436950513317074358030118564198671094847163184099349451694730336e+56');
    T('2.3565164149775678e-17', '3.29e-10', '7.752939005276198062e-27');

    T('-7.3082509513985065717321588249117283909294426665053038123171823802E45', '8.1139587436599483304895082011722489767478591E-41', '-592988.4670796104848902291110510024833882877779324139587779775769322761921828542989063538752670078960459222982');
    T('4.1580690407774531635854811718695276837491313289E8', '4.51151976050001428945887983E-3', '1875921.0642990819646935715021378546121515533349338737465486653798953306087');
    T('-5.94098742155317032555791061122172112467693488807700534435506921715E-24', '4.61016941217052394016E20', '-0.0027388958488934255950077406845338327546662445400484871083292926528860519832777944645744');
    T('3.7504E-12', '-7.88007879736459852E17', '-2955344.7521636190289408');
    T('-2.1186022052008407937878760699384240447915477894859451125820040738844629725E-19', '-7.216767917254229694821186934734207628E33', '1528946042391748.997410886033946108685159225196274137373381385049759221715038347354480872320019684962009305423');
    T('-5E-13', '-2.75399279758638331766833072E26', '137699639879319.165883416536');
    T('6E-5', '2.417496760754967572844203198215987E23', '14504980564529805437.065219189295922');
    T('-4.945015198370467209539041539486792258261028978257673527352148835976343131637595762491692863E23', '3.21738997057546245991016675193089492784008451753637062802134E-9', '-1591004230358037.215453223084728812766073228229224818741711464362077222232342773738670279322956619570773005741693064394880256558629265661028200068969642');
    T('8.944326872147001036632309667E-41', '1.34989853214019743744001484188796117541380712420727841534671603347856989127834147166127622e+48', '120739337.1569336009465330585026690676314127638673504378646869299090176172459431821906069831664699038568059542346321874');
    T('-1.06387569312217787644613114942E-25', '-3.49651047707433733724368394353972842316097364325909366154237667988339210449181953609691895611E35', '37198525073.064174722364904333744771229085129180022174384101305415837978911883846550330098510374779170577866567699408319562');

    log('\n ' + passed + ' of ' + total + ' tests passed in ' + (+new Date() - start) + ' ms \n');
    return [passed, total];;
})(this.BigNumber);
if (typeof module !== 'undefined' && module.exports) module.exports = count;